//
// MySQLException.cpp
//
// $Id: //poco/1.4/Data/MySQL/src/MySQLException.cpp#1 $
//
// Library: Data/MySQL
// Package: MySQL
// Module:  MySQLException
//
// Copyright (c) 2008, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/Data/MySQL/MySQLException.h"
#include <mysql.h>
#include <sstream>


namespace Poco {
namespace Data {
namespace MySQL {


MySQLException::MySQLException(const std::string& msg, int code): 
	Poco::Data::DataException(std::string("[MySQL]: ") + msg, code)
{
}


MySQLException::MySQLException(const MySQLException& exc): 
	Poco::Data::DataException(exc)
{
}


MySQLException::~MySQLException() throw()
{
}


ConnectionException::ConnectionException(const std::string& msg): 
	MySQLException(msg)
{
}


ConnectionException::ConnectionException(const std::string& text, MYSQL* h): 
	MySQLException(compose(text, h))
{
}


StatementException::StatementException(const std::string& msg, int code): 
	MySQLException(msg, code)
{
}


StatementException::StatementException(const std::string& text, MYSQL_STMT* h, const std::string& stmt): 
	MySQLException(compose(text, h, stmt), mysql_stmt_errno(h))
{
}


std::string ConnectionException::compose(const std::string& text, MYSQL* h)
{
	std::ostringstream str;
	str << "[Comment]: << text\t[mysql_error]: " << mysql_error(h) << "\t[mysql_errno]: ";
	str << mysql_errno(h) << "\t[mysql_sqlstate]: " << mysql_sqlstate(h);
	return str.str();
}


std::string StatementException::compose(const std::string& text, MYSQL_STMT* h, const std::string& stmt)
{
	std::ostringstream str;
	str << "[Comment]: " << text;

	if (h != 0)
	{
		str << "\t[mysql_stmt_error]: ";
		str << mysql_stmt_error(h);

		str << "\t[mysql_stmt_errno]: " << mysql_stmt_errno(h);

		str << "\t[mysql_stmt_sqlstate]: ";
		str << mysql_stmt_sqlstate(h);
	}

	if (stmt.length() > 0)
	{
		str << "\t[statemnt]: ";
		str << stmt;
	}

	return str.str();
}


} } } // namespace Poco::Data::MySQL
