/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.image.png;

import com.sixlegs.image.png.Chunk_IHDR;
import com.sixlegs.image.png.PngException;
import com.sixlegs.image.png.PngImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

final class UnfilterInputStream
extends InputStream {
    private final Chunk_IHDR header;
    private final int rowSize;
    private final int bpp;
    private final InflaterInputStream infstr;
    private final byte[] prev;
    private final byte[] cur;
    private int nextPass;
    private int rowsLeftInPass;
    private int bytesPerRow;
    private int pullSize;
    private int xc;
    private int xp;
    private int xPtr;
    private byte[] _b = new byte[1];

    UnfilterInputStream(PngImage pngImage, InputStream inputStream) {
        this.header = pngImage.data.header;
        this.infstr = new InflaterInputStream(inputStream, new Inflater(), 8192);
        this.bpp = Math.max(1, this.header.depth * this.header.samples / 8);
        int n = this.header.interlacer.getMaxPassWidth();
        int n2 = this.getByteWidth(n);
        this.rowSize = n2 + this.bpp;
        this.prev = new byte[this.rowSize];
        this.cur = new byte[this.rowSize];
        int n3 = 0;
        while (n3 < this.rowSize) {
            this.cur[n3] = 0;
            ++n3;
        }
    }

    private int getByteWidth(int n) {
        if (this.header.samples == 1) {
            int n2 = n * 2;
            int n3 = 16 / this.header.depth;
            return n2 % n3 == 0 ? n2 / n3 : (n2 + n3 - n2 % n3) / n3;
        }
        return n * this.header.samples * this.header.depth / 8;
    }

    private int readRow() throws IOException {
        int n;
        if (this.rowsLeftInPass == 0) {
            while (this.rowsLeftInPass == 0 || this.bytesPerRow == 0) {
                if (this.nextPass >= this.header.interlacer.numPasses()) {
                    return -1;
                }
                this.rowsLeftInPass = this.header.interlacer.getPassHeight(this.nextPass);
                this.bytesPerRow = this.getByteWidth(this.header.interlacer.getPassWidth(this.nextPass));
                ++this.nextPass;
            }
            this.pullSize = this.bytesPerRow + this.bpp;
            n = 0;
            while (n < this.pullSize) {
                this.prev[n] = 0;
                ++n;
            }
        }
        --this.rowsLeftInPass;
        n = this.infstr.read();
        if (n == -1) {
            return -1;
        }
        if (n > 4 || n < 0) {
            throw new PngException("Bad filter type: " + n);
        }
        int n2 = this.bytesPerRow;
        while (n2 > 0) {
            int n3 = this.infstr.read(this.cur, this.bytesPerRow - n2 + this.bpp, n2);
            if (n3 == -1) {
                return -1;
            }
            n2 -= n3;
        }
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                this.xc = this.bpp;
                this.xp = 0;
                while (this.xc < this.rowSize) {
                    this.cur[this.xc] = (byte)(this.cur[this.xc] + this.cur[this.xp]);
                    ++this.xc;
                    ++this.xp;
                }
                break;
            }
            case 2: {
                this.xc = this.bpp;
                this.xp = 0;
                while (this.xc < this.rowSize) {
                    this.cur[this.xc] = (byte)(this.cur[this.xc] + this.prev[this.xc]);
                    ++this.xc;
                    ++this.xp;
                }
                break;
            }
            case 3: {
                this.xc = this.bpp;
                this.xp = 0;
                while (this.xc < this.rowSize) {
                    this.cur[this.xc] = (byte)(this.cur[this.xc] + ((0xFF & this.cur[this.xp]) + (0xFF & this.prev[this.xc])) / 2);
                    ++this.xc;
                    ++this.xp;
                }
                break;
            }
            case 4: {
                this.xc = this.bpp;
                this.xp = 0;
                while (this.xc < this.rowSize) {
                    this.cur[this.xc] = (byte)(this.cur[this.xc] + this.Paeth(this.cur[this.xp], this.prev[this.xc], this.prev[this.xp]));
                    ++this.xc;
                    ++this.xp;
                }
                break;
            }
            default: {
                throw new PngException("unrecognized filter type " + n);
            }
        }
        System.arraycopy(this.cur, 0, this.prev, 0, this.rowSize);
        return 0;
    }

    private int Paeth(byte by, byte by2, byte by3) {
        int n;
        int n2;
        int n3 = 0xFF & by;
        int n4 = 0xFF & by2;
        int n5 = 0xFF & by3;
        int n6 = n3 + n4 - n5;
        int n7 = n6 - n3;
        if (n7 < 0) {
            n7 = -n7;
        }
        if ((n2 = n6 - n4) < 0) {
            n2 = -n2;
        }
        if ((n = n6 - n5) < 0) {
            n = -n;
        }
        if (n7 <= n2 && n7 <= n) {
            return n3;
        }
        if (n2 <= n) {
            return n4;
        }
        return n5;
    }

    public int read() throws IOException {
        return this.read(this._b, 0, 1) > 0 ? this._b[0] & 0xFF : -1;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n2 > 0) {
            if (this.xPtr == 0) {
                if (this.readRow() == -1) {
                    return n3 == 0 ? -1 : n3;
                }
                this.xPtr = this.bpp;
            }
            int n4 = Math.min(n2, this.pullSize - this.xPtr);
            System.arraycopy(this.cur, this.xPtr, byArray, n, n4);
            n3 += n4;
            this.xPtr = (this.xPtr + n4) % this.pullSize;
            n += n4;
            n2 -= n4;
        }
        return n3;
    }

    public void close() throws IOException {
        this.infstr.close();
    }
}

