/*
  Plee the Bear

  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file frame_audio.hpp
 * \brief This frame is shown to choose the audio parameters.
 * \author Julien Jorge
 */
#ifndef __PTB_FRAME_AUDIO_HPP__
#define __PTB_FRAME_AUDIO_HPP__

#include "ptb/frame/frame.hpp"
#include "ptb/frame/button.hpp"
#include "gui/checkbox.hpp"
#include "gui/picture.hpp"
#include "gui/slider.hpp"
#include "gui/static_text.hpp"

namespace ptb
{
  /**
   * \brief This frame is shown to choose the audio parameters.
   * \author Julien Jorge
   */
  class frame_audio:
    public frame
  {
  private:
    /** \brief The control next to the cursor. */
    enum cursor_position
      {
        cursor_sound,
        cursor_music,
        cursor_ok,
        cursor_cancel
      }; // enum cursor_position

    typedef button< bear::gui::static_text,
                    std::mem_fun_t<bool, frame_audio> > button_with_text;

    /** \brief Callback called when the value of a volume slider changed. */
    class volume_changed_callback:
      public bear::gui::callback
    {
    public:
      volume_changed_callback( frame_audio& owner );

      void execute( bear::gui::visual_component& control );

    private:
      /** \brief The frame owning the control. */
      frame_audio& m_owner;

    }; // class volume_changed_callback

  public:
    frame_audio( windows_layer* in_layer );

    void set_volume();

  private:
    bool on_key_press( const bear::input::key_info& key );
    bool on_button_press( bear::input::joystick::joy_code button,
                          unsigned int joy_index );
    bool on_mouse_press( bear::input::mouse::mouse_code key,
                         const claw::math::coordinate_2d<unsigned int>& pos );
    bool on_mouse_move( const claw::math::coordinate_2d<unsigned int>& pos );

    void validate();

    void create_controls();
    void create_checkboxes( bear::gui::static_text::font_type f );
    void create_sliders();
    void create_ok_cancel( bear::gui::static_text::font_type f );

    void save();

    bool on_ok();
    bool on_cancel();
    bool on_up();
    bool on_down();
    bool on_left();
    bool on_right();

    void position_cursor();

  private:
    /* \brief The sound 'mute' status when the frame was shown. */
    const bool m_saved_sound_muted;

    /* \brief The music 'mute' status when the frame was shown. */
    const bool m_saved_music_muted;

    /* \brief The sound volume when the frame was shown. */
    const bool m_saved_sound_volume;

    /* \brief The music volume when the frame was shown. */
    const double m_saved_music_volume;

    /** \brief The cursor. */
    bear::gui::picture* m_cursor;

    /** \brief The sound "Mute" checkbox. */
    bear::gui::checkbox* m_sound_muted;

    /** \brief The music "Mute" checkbox. */
    bear::gui::checkbox* m_music_muted;

    /** \brief The "Ok" button. */
    button_with_text* m_ok;

    /** \brief 'Cancel' button. */
    button_with_text* m_cancel;

    /** \brief Slider to control the volume of the sounds. */
    bear::gui::slider<double>* m_sound_volume;

    /** \brief Slider to control the volume of the music. */
    bear::gui::slider<double>* m_music_volume;

    /** \brief The position of the cursor. */
    cursor_position m_cursor_position;

    /** \brief The size of the margins between controls. */
    static const unsigned int s_margin;

  }; // class frame_audio
} // namespace ptb

#endif // __PTB_FRAME_AUDIO_HPP__
