/*
    Bear Engine - Level editor

    Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    contact: plee-the-bear@gamned.org

    Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file bf/layer_list_frame.hpp
 * \brief The window displaying the list of layers in the level.
 * \author Julien Jorge
 */
#ifndef __BF_LAYER_LIST_FRAME_HPP__
#define __BF_LAYER_LIST_FRAME_HPP__

#include <wx/wx.h>

namespace bf
{
  class ingame_view;

  /**
   * \brief The window displaying the list of layers in the level.
   * \author Julien Jorge
   */
  class layer_list_frame:
    public wxPanel
  {
  public:
    /** \brief The identifiers of the controls. */
    enum control_id
      {
        IDC_LAYER_LIST
      }; // enum control_id

  public:
    layer_list_frame( wxWindow* parent );

    void set_level_view( ingame_view* view );

  private:
    void create_controls();
    void create_member_controls();
    void create_sizer_controls();

    void clear();
    void fill();
    void update_windows_layout() const;

    void on_new_layer(wxCommandEvent& event);
    void on_delete(wxCommandEvent& event);

    void on_show_properties(wxCommandEvent& event);
    void on_toggle_layer(wxCommandEvent& event);
    void on_select_layer(wxCommandEvent& event);

    void on_move_up(wxCommandEvent& event);
    void on_move_down(wxCommandEvent& event);

    void on_close(wxCloseEvent& event);

  private:
    /** \brief The level we are working on. */
    ingame_view* m_level_view;

    /** \brief The list of layers, presented to the user. */
    wxCheckListBox* m_layer_list;

    /** \brief The button to create a new layer. */
    wxButton* m_new_layer_button;

    DECLARE_EVENT_TABLE()

  }; // class layer_list_frame
} // namespace bf

#endif // __BF_LAYER_LIST_FRAME_HPP__
