#!/bin/sh --

#
# A little wrapper which will fetch keys and add them to your public
# key ring as needed.
#

umask 077
tmpfile=`mktemp /tmp/keys.XXXXXX`
trap "/bin/rm -f $tmpfile ; trap '' 0; exit" 0 1 2 3

PGPVERSION=2

case $1 in
    -2) PGPVERSION=2
	shift ;;
    -5) PGPVERSION=5
	shift ;;
    -g) PGPVERSION=g
	shift ;;
esac

if pkspxyc -s luv.rhein.de "$@" > $tmpfile ; then
    case $PGPVERSION in
	2) pgp -ka +batchmode +verbose=0 $tmpfile 2> /dev/null > /dev/null;;
	5) pgpk -a +batchmode +verbose=0 $tmpfile 2> /dev/null > /dev/null;;
	g) gpg --import --no-verbose $tmpfile 2> /dev/null > /dev/null;;
    esac
fi
