/* HKP client networking. */

#include <unistd.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <time.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "hkp.h"

static int open_connection (const char *host, int port)
{
  struct sockaddr_in sin;
  struct hostent *he;
  int sockfd;
  
  memset (&sin, 0, sizeof (sin));
  sin.sin_port = htons ((short) port);
  sin.sin_family = AF_INET;
  
  if ((he = gethostbyname (host)) == NULL)
    return -1;
  
  memcpy (&sin.sin_addr, he->h_addr_list[0], he->h_length);
  
  if ((sockfd = socket (AF_INET, SOCK_STREAM, IPPROTO_IP)) < 0)
    return -1;
  
  if (connect (sockfd, (struct sockaddr *) &sin, sizeof (sin)) < 0)
  {
    close (sockfd);
    return -1;
  }
  
  return sockfd;
}

int hkp_doit (const char *host, int port, const char *qstr,
		    time_t t, FILE *ofp, int *lines)
{
  int sockfd;
  FILE *sockf;
  char buff[2048];
  char *s;
  int code;

  hkp_build_query (buff, sizeof (buff), host, port, qstr, t);

  if ((sockfd = open_connection (host, port)) < 0)
    return -1;

  if ((sockf = fdopen (sockfd, "r+")) == NULL)
  {
    close (sockfd);
    return -1;
  }

  fprintf (sockf, "%s\r\n", buff);
  fflush (sockf);

  /* Record the HTTP reply code */

  if (fgets (buff, sizeof (buff), sockf) == NULL)
  {
    fclose (sockf);
    return -1;
  }

  if (!(s = strchr (buff, ' ')))
    return -1;

  code = atoi (s);

  /* slurp the header */

  while (fgets (buff, sizeof (buff), sockf))
    if (*buff == '\r' || *buff == '\n')
      break;

  /* copy out the body */

  if (lines) *lines = 0;
  
  while (fgets (buff, sizeof (buff), sockf))
  {
    fputs (buff, ofp);
    if (lines) (*lines)++;
  }

  fclose (sockf);
  
  return code;
}

