<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:qof-qsf="http://qof.sourceforge.net/" version="1.1">
  <xsl:import href="string.xsl"/>
<!-- our own pilot-qof standard routines -->
  <xsl:import href="pilot-qof-std.xsl"/>
  <xsl:output method="xml" encoding="UTF-8" indent="yes"/>
<!-- Representing Palm expenses data as gpe-expenses data

  This stylesheet converts the output from gpe-expenses
  into another QSF XML file, suitable for import into pilot-qof. 

  This stylesheet is very simple. It allows users export iPAQ expense
  entries to Palm data - there's no point in re-entering existing data.

-->
<!-- Licence

  This file is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
-->
  <xsl:template match="/">
    <qof-qsf:qof-qsf>
      <qof-qsf:book count="1">
        <qof-qsf:book-guid>
          <xsl:value-of select="/*/qof-qsf:book/qof-qsf:book-guid"/>
        </qof-qsf:book-guid>
        <xsl:for-each select="/*/qof-qsf:book/qof-qsf:object[@type='gpe_expenses']">
          <qof-qsf:object type="pilot_expenses">
            <xsl:attribute name="count">
              <xsl:number value="position()" format="1"/>
            </xsl:attribute>
            <qof-qsf:string type="form_of_payment">
              <xsl:value-of select="qof-qsf:string[@type='form_of_payment']"/>
            </qof-qsf:string>
            <qof-qsf:string type="distance_unit">
              <xsl:value-of select="qof-qsf:string[@type='distance_unit']"/>
            </qof-qsf:string>
            <qof-qsf:string type="expense_vendor">
              <xsl:value-of select="qof-qsf:string[@type='expense_vendor']"/>
            </qof-qsf:string>
            <qof-qsf:string type="expense_city">
              <xsl:value-of select="qof-qsf:string[@type='expense_city']"/>
            </qof-qsf:string>
            <qof-qsf:string type="expense_attendees">
              <xsl:value-of select="qof-qsf:string[@type='expense_attendees']"/>
            </qof-qsf:string>
            <qof-qsf:string type="category">
              <xsl:value-of select="qof-qsf:string[@type='category']"/>
            </qof-qsf:string>
            <qof-qsf:string type="expense_note">
              <xsl:value-of select="qof-qsf:string[@type='expense_note']"/>
            </qof-qsf:string>
            <qof-qsf:string type="type_of_expense">
              <xsl:value-of select="qof-qsf:string[@type='type_of_expense']"/>
            </qof-qsf:string>
            <qof-qsf:guid type="guid">
              <xsl:value-of select="qof-qsf:guid[@type='guid']"/>
            </qof-qsf:guid>
            <qof-qsf:numeric type="expense_amount">
              <xsl:value-of select="qof-qsf:numeric[@type='expense_amount']"/>
            </qof-qsf:numeric>
            <qof-qsf:time type="expense_date">
              <xsl:value-of select="qof-qsf:time[@type='expense_date']"/>
            </qof-qsf:time>
            <qof-qsf:gint32 type="currency_code">
              <xsl:value-of select="qof-qsf:gint32[@type='currency_code']"/>
            </qof-qsf:gint32>
            <qof-qsf:kvp type="currency_lookup" path="expense/currency/mnemonic" value="string">
              <xsl:value-of select="qof-qsf:kvp[@path='expense/currency/mnemonic']"/>
            </qof-qsf:kvp>
            <qof-qsf:kvp type="currency_lookup" path="expense/currency/symbol" value="string">
              <xsl:value-of select="qof-qsf:kvp[@path='expense/currency/symbol']"/>
            </qof-qsf:kvp>
            <qof-qsf:kvp type="currency_lookup" path="expense/currency/fraction" value="gint64">
              <xsl:value-of select="qof-qsf:kvp[@path='expense/currency/fraction']"/>
            </qof-qsf:kvp>
          </qof-qsf:object>
        </xsl:for-each>
      </qof-qsf:book>
    </qof-qsf:qof-qsf>
  </xsl:template>
</xsl:stylesheet>
