#!/usr/bin/python
# encoding: UTF-8
#
# PhotoFilmStrip - Creates movies out of your pictures.
#
# Copyright (C) 2008 Jens Goepfert
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

import logging
import sys


def initLogging():
    if "-d" in sys.argv:
        lvl = logging.DEBUG
    else:
        lvl = logging.WARNING
    logging.basicConfig(level=lvl,
                        format='%(asctime)s (%(levelname)s) %(name)s: %(message)s',
                        datefmt='%d.%m.%Y %H:%M:%S')

def initI18N():
    from lib.Settings import Settings
    Settings().InitLanguage()


def main():
    initLogging()
    initI18N()

    if not hasattr(sys, 'frozen'):
        import wxversion
        wxversion.select("2.8")
    
    from gui.PhotoFilmStripApp import main
    main()


if __name__ == "__main__":
    main()
