# Copyright (C) 2007-2008 www.stani.be
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/

import os, sys
from unicoding import ENCODING

def _t(x):
    return _(x).encode(ENCODING,'replace')

def ensure(recommended,minimal):
    """Ensures the minimal version of wxPython is installed.
    - minimal: as string (eg. '2.6')"""
    
    #wxversion
    try:
        import wxversion
        if wxversion.checkInstalled(recommended):
            wxversion.select(recommended)
        else:
            wxversion.ensureMinimal(minimal)
        import wx
        return wx
    except ImportError:
        sys.stdout.write(_t('Warning: python-wxversion is not installed.\n'))
        
    #wxversion failed, import wx anyway
    try:
        import wx
    except ImportError:
        message = '%s: wxPython %s (%s %s) %s.\n\n%s'%(_t('Error'),recommended,
            _t('or at least'),minimal,_t('can not be found, but is required'),
            _t('Please (re)install it.'))
        sys.stderr.write(message)
        if sys.platform.startswith('linux') and \
                os.path.exists('/usr/bin/zenity'):
            os.system('''zenity --error --text="%s\n\n'''%message+\
                '''%s 'python-wxversion' %s 'python-wxgtk%s' '''\
                        %(_t("Phatch needs"),_t('and'),recommended)+\
                '''(or at least 'python-wxgtk%s')."'''%minimal)
        sys.exit()
        
    #wxversion failed but wx is available, check version again
    if wx.VERSION_STRING < minimal: 
        class MyApp(wx.App):
            def OnInit(self):
                result = wx.MessageBox(
                    _t("This application is known to be compatible with\n"
                    "wxPython version(s) ")+recommended+
                    " ("+_t("or at least")+" "+minimal+"),\n"+
                    _t("but you have")+" %s "%wx.VERSION_STRING+_t("installed")+
                    ".\n\n"+_t("Please upgrade your wxPython."),
                    _t("wxPython Version Error"),
                    style   = wx.ICON_ERROR)
                return False
        app = MyApp()
        app.MainLoop()
        sys.exit()
    #wxversion failed, but wx is the right version anyway
    return wx