(** Wrapper around Perl [Data::Dumper] class.
  *
  * Copyright (C) 2005 Merjis Ltd.
  *
  * $Id: pl_Data_Dumper.ml,v 1.2 2005/03/31 13:46:32 rich Exp $
  *)

open Perl

let _ = eval "use Data::Dumper"

class data_dumper (sv : sv) =

object (self)
  method sv = sv



end

let new_ r =
  let sv = call_class_method "Data::Dumper" "new" [r] in
  new data_dumper sv

let dump r =
  string_of_sv (call_class_method "Data::Dumper" "Dump" [r])

let dump_hv hv =
  dump (arrayref (av_of_sv_list [hashref hv]))

let dump_av av =
  dump (arrayref av)
