use PennMUSH;
use MUSHConnection;
use TestHarness;

$mush = PennMUSH->new();
$god = $mush->loginGod();

$god->command("&FIRST me=first");
$god->command("&SECOND me=second");
$god->command("&THIRD me=third");

test('grep.1', $god, 'think grep(me,*,d)', 'SECOND THIRD');
test('grep.2', $god, 'think grep(me,S*,d)', 'SECOND');
test('grep.3', $god, 'think grep(me,*,*d*)', '!SECOND THIRD');
test('grep.4', $god, 'think grep(me,*,D)', '!SECOND THIRD');

test('grep.5', $god, 'think wildgrep(me,*,*d*)', 'SECOND THIRD');
test('grep.6', $god, 'think wildgrep(me,*,d)', '!SECOND THIRD');
test('grep.7', $god, 'think wildgrep(me,*,first)', 'FIRST');
test('grep.8', $god, 'think wildgrep(me,*,FIRST)', '!FIRST');

test('grep.9', $god, 'think regrep(me,*,*d*)', '!SECOND THIRD');
test('grep.10', $god, 'think regrep(me,*,d)', 'SECOND THIRD');
test('grep.11', $god, 'think regrep(me,*,d$)', 'SECOND THIRD');
test('grep.12', $god, 'think regrep(me,*,first)', 'FIRST');
test('grep.13', $god, 'think regrep(me,*,FIRST)', '!FIRST');

test('grep.14', $god, 'think grepi(me,*,d)', 'SECOND THIRD');
test('grep.15', $god, 'think grepi(me,S*,d)', 'SECOND');
test('grep.16', $god, 'think grepi(me,*,*d*)', '!SECOND THIRD');
test('grep.17', $god, 'think grepi(me,*,D)', 'SECOND THIRD');

test('grep.18', $god, 'think wildgrepi(me,*,*d*)', 'SECOND THIRD');
test('grep.19', $god, 'think wildgrepi(me,*,d)', '!SECOND THIRD');
test('grep.20', $god, 'think wildgrepi(me,*,first)', 'FIRST');
test('grep.21', $god, 'think wildgrepi(me,*,FIRST)', 'FIRST');

test('grep.22', $god, 'think regrepi(me,*,*d*)', '!SECOND THIRD');
test('grep.23', $god, 'think regrepi(me,*,d)', 'SECOND THIRD');
test('grep.24', $god, 'think regrepi(me,*,d$)', 'SECOND THIRD');
test('grep.25', $god, 'think regrepi(me,*,first)', 'FIRST');
test('grep.26', $god, 'think regrepi(me,*,FIRST)', 'FIRST');
