/*
 * window_main_cat.cc
 * Copyright (C) Martin Singer 2009-2011 <m_power3@users.sourceforge.net>
 * 
 * pdfchain is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * pdfchain is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "window_main_cat.h"


/*** Tree View : Cat **********************************************************/

// Constructor
cTView_Cat::cTView_Cat( Gtk::Window& ref_window )
:
	pTMCRecord_Cat( NULL ),

#ifdef PDFCHAIN_TEMP
	mTVColumn_SourcePath( "Source path" ),	//TEMP
	mTVColumn_Tooltip(    "Tooltip"     ),	//TEMP
	mTVColumn_Commands(   "Commands"    ),	//TEMP
	mTVColumn_Colors(     "Colors"      ),	//TEMP
#endif
	mTVColumn_AddPages(    _("Add pages")     ),
	mTVColumn_Rotation(    _("Rotation")      ),
	mTVColumn_SourceFile(  _("Source file")   ),
	mTVColumn_Password(    _("User password") ),
	mTVColumn_PageNumbers( _("Pages")         )
{
	rLStore_Cat      = cLStore_Cat::create( ref_window );
	rLStore_EvenOdd  = cLStore_EvenOdd::create();
	rLStore_Rotation = cLStore_Rotation::create();

	pTMCRecord_Cat   = rLStore_Cat->getTMCRecord();

	get_selection()->set_mode( Gtk::SELECTION_MULTIPLE );
	
	set_model( rLStore_Cat );
	set_reorderable( true );
	set_rules_hint( true );
	set_rubber_banding( true );
	set_enable_search( true );
	set_search_column( pTMCRecord_Cat->mTMColumn_SourceFile );
	set_tooltip_column( get_search_column() + 2 );
	
	mTVColumn_AddPages.set_expand( true );
	mTVColumn_AddPages.set_resizable( true );
	mTVColumn_Rotation.set_resizable( false );
	mTVColumn_SourceFile.set_expand( true );
	mTVColumn_SourceFile.set_resizable( true );
	mTVColumn_Password.set_resizable( true );
#ifdef PDFCHAIN_TEMP
	mTVColumn_SourcePath.set_expand( true );	//TEMP
	mTVColumn_SourcePath.set_resizable( true );	//TEMP
	mTVColumn_Tooltip.set_expand( true );		//TEMP
	mTVColumn_Tooltip.set_resizable( true );	//TEMP
#endif

	mCRToggle_Add.property_activatable()     = true;
	mCRToggle_Add.property_xalign()          = 0.0;
	mCRText_Pages.property_editable()        = true;
	mCRText_Pages.property_width()           = 50;				// minimum width (expands)
	mCRText_Pages.property_xalign()          = 0.0;
	mCRCombo_EvenOdd.property_model()        = rLStore_EvenOdd;	// the liststore
	mCRCombo_EvenOdd.property_text_column()  = 1;				// text column at the liststore
	mCRCombo_EvenOdd.property_editable()     = true;
	mCRCombo_EvenOdd.property_has_entry()    = false;			// no manual entry possible
	mCRCombo_EvenOdd.property_xalign()       = 1.0;				// align: right side
	mCRCombo_Rotation.property_model()       = rLStore_Rotation;
	mCRCombo_Rotation.property_text_column() = 1;
	mCRCombo_Rotation.property_editable()    = true;
	mCRCombo_Rotation.property_has_entry()   = false;
	mCRCombo_Rotation.property_xalign()      = 1.0;
	mCRText_Password.property_editable()     = true;
	mCRText_PageNumbers.property_xalign()    = 1.0;

	mTVColumn_AddPages.pack_start(    mCRToggle_Add               , false );	// cell renderer , expand
	mTVColumn_AddPages.pack_start(    mCRText_Pages	              , true  );
	mTVColumn_AddPages.pack_start(    mCRCombo_EvenOdd            , false );
	mTVColumn_Rotation.pack_start(    mCRCombo_Rotation	          , false );
	mTVColumn_SourceFile.pack_start(  mCRText_SourceFile          , true  );
	mTVColumn_Password.pack_start(    mCRText_Password            , true  );
	mTVColumn_PageNumbers.pack_start( mCRText_PageNumbers         , true  );
#ifdef PDFCHAIN_TEMP
	mTVColumn_SourcePath.pack_start(  mCRText_SourcePath          , true  );	//TEMP
	mTVColumn_Tooltip.pack_start(     mCRText_Tooltip             , true  );	//TEMP
	mTVColumn_Commands.pack_start(    mCRText_Cmd_Handle          , false );	//TEMP
	mTVColumn_Commands.pack_start(    mCRText_Cmd_EvenOdd         , false );	//TEMP
	mTVColumn_Commands.pack_start(    mCRText_Cmd_Rotation        , false );	//TEMP
	mTVColumn_Colors.pack_start(      mCRPixbuf_Color_Pages       , false );	//TEMP
	mTVColumn_Colors.pack_start(      mCRPixbuf_Color_PageNumbers , false );	//TEMP
#endif
	
	mTVColumn_AddPages.add_attribute(    mCRToggle_Add.property_active()                            , pTMCRecord_Cat->mTMColumn_Add               );
	mTVColumn_AddPages.add_attribute(    mCRText_Pages.property_text()                              , pTMCRecord_Cat->mTMColumn_Pages             );
	mTVColumn_AddPages.add_attribute(    mCRText_Pages.property_foreground_rgba()                   , pTMCRecord_Cat->mTMColumn_Color_Pages       );
	mTVColumn_AddPages.add_attribute(    mCRCombo_EvenOdd.property_text()                           , pTMCRecord_Cat->mTMColumn_EvenOdd           );
	mTVColumn_Rotation.add_attribute(    mCRCombo_Rotation.property_text()                          , pTMCRecord_Cat->mTMColumn_Rotation          );
	mTVColumn_SourceFile.add_attribute(  mCRText_SourceFile.property_text()                         , pTMCRecord_Cat->mTMColumn_SourceFile        );
	mTVColumn_Password.add_attribute(    mCRText_Password.property_text()                           , pTMCRecord_Cat->mTMColumn_Password          );
	mTVColumn_PageNumbers.add_attribute( mCRText_PageNumbers.property_text()                        , pTMCRecord_Cat->mTMColumn_PageNumbers       );
	mTVColumn_PageNumbers.add_attribute( mCRText_PageNumbers.property_foreground_rgba()             , pTMCRecord_Cat->mTMColumn_Color_PageNumbers );
#ifdef PDFCHAIN_TEMP
	mTVColumn_SourcePath.add_attribute(  mCRText_SourcePath.property_text()                         , pTMCRecord_Cat->mTMColumn_SourcePath        );	//TEMP
	mTVColumn_Tooltip.add_attribute(     mCRText_Tooltip.property_text()                            , pTMCRecord_Cat->mTMColumn_Tooltip           );	//TEMP
	mTVColumn_Commands.add_attribute(    mCRText_Cmd_Handle.property_text()                         , pTMCRecord_Cat->mTMColumn_Cmd_Handle        );	//TEMP
	mTVColumn_Commands.add_attribute(    mCRText_Cmd_EvenOdd.property_text()                        , pTMCRecord_Cat->mTMColumn_Cmd_EvenOdd       );	//TEMP
	mTVColumn_Commands.add_attribute(    mCRText_Cmd_Rotation.property_text()                       , pTMCRecord_Cat->mTMColumn_Cmd_Rotation      );	//TEMP
	mTVColumn_Colors.add_attribute(      mCRPixbuf_Color_Pages.property_cell_background_gdk()       , pTMCRecord_Cat->mTMColumn_Color_Pages	      );	//TEMP
	mTVColumn_Colors.add_attribute(      mCRPixbuf_Color_PageNumbers.property_cell_background_gdk() , pTMCRecord_Cat->mTMColumn_Color_PageNumbers );	//TEMP
#endif
	
	append_column( mTVColumn_AddPages    );
	append_column( mTVColumn_Rotation    );
	append_column( mTVColumn_SourceFile  );
#ifdef PDFCHAIN_TEMP
	append_column( mTVColumn_SourcePath  );	//TEMP
	append_column( mTVColumn_Tooltip     );	//TEMP
#endif
	append_column( mTVColumn_Password    );
	append_column( mTVColumn_PageNumbers );
#ifdef PDFCHAIN_TEMP
	append_column( mTVColumn_Commands    );	//TEMP
	append_column( mTVColumn_Colors      );	//TEMP
#endif

	mCRToggle_Add.signal_toggled().connect(     sigc::mem_fun( *this , &cTView_Cat::onCRToggle_Add_toggled     ) );
	mCRText_Pages.signal_edited().connect(      sigc::mem_fun( *this , &cTView_Cat::onCRText_Pages_edited      ) );
	mCRCombo_EvenOdd.signal_changed().connect(  sigc::mem_fun( *this , &cTView_Cat::onCRCombo_EvenOdd_changed  ) );
	mCRCombo_Rotation.signal_changed().connect( sigc::mem_fun( *this , &cTView_Cat::onCRCombo_Rotation_changed ) );
	mCRText_Password.signal_edited().connect(   sigc::mem_fun( *this , &cTView_Cat::onCRText_Password_edited   ) );
}


// Destructor
cTView_Cat::~cTView_Cat()
{
#ifdef PDFCHAIN_TEST
	std::cout << std::endl << "cTView_Cat::~cTView_Cat()";	//TEST
#endif
}



/*** Combobox : Output ID *****************************************************/

// Constructor
cCBox_OutputID::cCBox_OutputID()
{
	rLStore    = cLStore_OutputID::create();
	pTMCRecord = rLStore->getTMCRecord();

	pack_start( mCRText );
	add_attribute( mCRText.property_text() , pTMCRecord->mTMColumn_Label );	// necessarily after 'pack_start()' !!!
	set_model( rLStore );
	set_active( rLStore->setMultipleFiles( Pdfchain::Id::ID_NEW ) );
	set_sensitive( false );
	unset_active();
}


// Destructor
cCBox_OutputID::~cCBox_OutputID()
{
#ifdef PDFCHAIN_TEST
	std::cout << std::endl << "cCBox_OutputID::~cCBox_OutputID()";	//TEST
#endif
}


// Signal Handler (protected) : on FileNumber changed (at ListStore Cat)
void
cCBox_OutputID::onFileNumber_changed( guint file_number )
{
	Gtk::TreeModel::iterator iter = get_active();
	
	if ( 1 > file_number ) {
		//if ( get_sensitive() ) {
		//	if ( iter )	vOutputId = (*iter)[pTMCRecord->mTMColumn_ID];
		//}
		if ( get_sensitive() && iter )	vOutputId = (*iter)[pTMCRecord->mTMColumn_ID];
		unset_active();
		set_sensitive( false );
	}
	else if ( 1 == file_number ) {
		if ( get_sensitive() && iter )	vOutputId = (*iter)[pTMCRecord->mTMColumn_ID];
		set_sensitive( true );
		set_active( rLStore->setSingleFile() );
		set_sensitive( false );
	}
	else if ( 1 < file_number ) {
		if ( ! get_sensitive() ) {
			//set_active( rLStore->setMultipleFiles( Pdfchain::Id::ID_NEW ) );
			set_active( rLStore->setMultipleFiles( vOutputId ) );
			set_sensitive( true );
		}
	}

	return;
}



/*** Toolbar : Cat ************************************************************/

// Constructor
cToolbar_Cat::cToolbar_Cat( cTView_Cat* pt_tview_cat )
:
	mToolButton_Add(    Gtk::Stock::ADD     ),
	mToolButton_Remove( Gtk::Stock::REMOVE  ),
	mToolButton_Copy(   Gtk::Stock::COPY    ),
	mToolButton_Up(     Gtk::Stock::GO_UP   ),
	mToolButton_Down(   Gtk::Stock::GO_DOWN ),
	mTToolButton_Shuffle( _("Shuffle pages") )	// label
	//mTToolButton_Shuffle( Gtk::Stock::DND_MULTIPLE )	//TEST maybe a icon for this button
{
	mSeparator_B.set_draw( false );
	mSeparator_B.set_expand( true );

	mTToolButton_Shuffle.set_is_important( true );

	mToolButton_Add.set_tooltip_text(      _("Add some files to concatenate")                 );
	mToolButton_Remove.set_tooltip_text(   _("Remove selected files")                         );
	mToolButton_Copy.set_tooltip_text(     _("Copy selected files")                           );
	mToolButton_Up.set_tooltip_text(       _("Move selected files up")                        );
	mToolButton_Down.set_tooltip_text(     _("Move selected files down")                      );
	mTToolButton_Shuffle.set_tooltip_text( _("Takes one page at a time from each page range") );
	
	mToolItem_OutputID.add( mCBox_OutputID );
	
	add( mToolButton_Add      );
	add( mToolButton_Remove   );
	add( mToolButton_Copy     );
	add( mSeparator_A         );
	add( mToolButton_Up       );
	add( mToolButton_Down     );
	add( mSeparator_B         );
	add( mTToolButton_Shuffle );
	add( mSeparator_C         );
	add( mToolItem_OutputID   );

	mToolButton_Add.signal_clicked().connect(    sigc::mem_fun( *pt_tview_cat , &cTView_Cat::onToolButton_Add_clicked    ) );
	mToolButton_Remove.signal_clicked().connect( sigc::mem_fun( *pt_tview_cat , &cTView_Cat::onToolButton_Remove_clicked ) );
	mToolButton_Copy.signal_clicked().connect(   sigc::mem_fun( *pt_tview_cat , &cTView_Cat::onToolButton_Copy_clicked   ) );
	mToolButton_Up.signal_clicked().connect(     sigc::mem_fun( *pt_tview_cat , &cTView_Cat::onToolButton_Up_clicked     ) );
	mToolButton_Down.signal_clicked().connect(   sigc::mem_fun( *pt_tview_cat , &cTView_Cat::onToolButton_Down_clicked   ) );
}


// Destructor
cToolbar_Cat::~cToolbar_Cat()
{
#ifdef PDFCHAIN_TEST
	std::cout << std::endl << "cToolbar_Cat::~cToolbar_Cat()";	//TEST
#endif
}



/*** VBox : Cat ***************************************************************/

// Constructor
cVBox_Cat::cVBox_Cat( Gtk::Window& ref_window )
:
	mTView( ref_window ),
	mToolbar( &mTView ),
	mFCDialog_SaveAs( ref_window , _("Concatenate - Save output PDF file as ...") , Pdfchain::Id::FILE_TYPE_PDF )	// parent_window , title , file_type
{
	mSWindow.add( mTView );
	
	pack_start( mSWindow , true  , true  , Pdfchain::PADDING );	// widget , expand , fill , padding
	pack_start( mToolbar , false , false , Pdfchain::PADDING );

	mTView.rLStore_Cat->signalFileNumber_changed().connect( sigc::mem_fun( mToolbar.mCBox_OutputID , &cCBox_OutputID::onFileNumber_changed ) );
}


// Destructor
cVBox_Cat::~cVBox_Cat()
{
#ifdef PDFCHAIN_TEST
	std::cout << std::endl << "cVBox_Cat::~cVBox_Cat()";	//TEST
#endif
}


// Method (public) : create command
std::string
cVBox_Cat::createCommand()
{
	std::string str_targetfile = "";
	std::string str_command    = "";

	if ( "" != ( str_command = mTView.rLStore_Cat->createCommand( mToolbar.mTToolButton_Shuffle.get_active() ) ) ) {
		
		switch ( mFCDialog_SaveAs.run() ) {
			case Gtk::RESPONSE_OK: {
				mFCDialog_SaveAs.hide();

				if ( "" != ( str_targetfile = mFCDialog_SaveAs.get_filename() ) ) {

					Gtk::TreeModel::iterator iter      = mToolbar.mCBox_OutputID.get_active();
					cTMCRecord_Selection*    pt_record = mToolbar.mCBox_OutputID.rLStore->getTMCRecord();

					str_command += " " + Pdfchain::Cmd::OUTPUT;
					str_command += " " + Pdfchain::quote_path( str_targetfile );

					if ( iter )
						if ( Pdfchain::Id::ID_NEW != (*iter)[pt_record->mTMColumn_ID] && Pdfchain::Id::ID_KEEP != (*iter)[pt_record->mTMColumn_ID] )
							str_command += " " + iter->get_value( pt_record->mTMColumn_Command );
				}
				else {
					str_command = "";
				}
				break;
			}
			default:
				mFCDialog_SaveAs.hide();
				str_command = "";
				break;
		}
	}
	
	return str_command;
}