/*******************************************
 PDF Chain
 
 Copyright: 2009 Martin Singer
 <http://sourceforge.net/projects/pdfchain/>
 
 Author: Martin Singer
 <m_power3@users.sourceforge.net>
 
 License: GPL version 3+
 <http://www.gnu.org/licenses/>
 
 MainWindow
 src/merge_options.cc
 *******************************************/

#include "definings.hh"
#include "merge_options.hh"

/*** Constructor ***/
class_window_merge_options::class_window_merge_options() :
table_rotation(2, 2, true),
table_evenodd(2, 2, true),
hbox_rotation_evenodd(false, 5),
hbox_pages(false, 5),
hbox_password(false, 5),
vbox_options(false, 5),
frame_rotation(Text::str_ROTATION),
frame_evenodd(Text::str_EVEN_ODD),
frame_pages(Text::str_PAGES),
frame_password(Text::str_INPUT_PASSWORD),
button_set(Gtk::Stock::APPLY),
radiobutton_rotation_0(Text::str_0_DEG),
radiobutton_rotation_90(Text::str_90_DEG),
radiobutton_rotation_180(Text::str_180_DEG),
radiobutton_rotation_270(Text::str_270_DEG),
radiobutton_evenodd_all(Text::str_ALL),
radiobutton_evenodd_even(Text::str_EVEN),
radiobutton_evenodd_odd(Text::str_ODD),
alignment_button(Gtk::ALIGN_CENTER,   Gtk::ALIGN_CENTER, 0.0, 0.0){
	
	// Window
	set_title(Text::str_MERGE_OPTIONS);
	set_default_size(0, 0);
	set_border_width(0);
	set_position(Gtk::WIN_POS_CENTER);
	set_resizable(false);
	set_keep_above(false);
	set_deletable(true);
	
	// Widgets
	// Options -> Rotation
	group_radiobutton_rotation = radiobutton_rotation_0.get_group();
	radiobutton_rotation_90.set_group(group_radiobutton_rotation);
	radiobutton_rotation_180.set_group(group_radiobutton_rotation);
	radiobutton_rotation_270.set_group(group_radiobutton_rotation);
	radiobutton_rotation_0.set_active();
	
	table_rotation.set_spacings(5);
	table_rotation.set_border_width(5);
	table_rotation.attach(radiobutton_rotation_0,   0, 1, 0, 1, Gtk::FILL | Gtk::EXPAND, Gtk::SHRINK, 0, 0);
	table_rotation.attach(radiobutton_rotation_90,  0, 1, 1, 2, Gtk::FILL | Gtk::EXPAND, Gtk::SHRINK, 0, 0);
	table_rotation.attach(radiobutton_rotation_180, 1, 2, 0, 1, Gtk::FILL | Gtk::EXPAND, Gtk::SHRINK, 0, 0);
	table_rotation.attach(radiobutton_rotation_270, 1, 2, 1, 2, Gtk::FILL | Gtk::EXPAND, Gtk::SHRINK, 0, 0);
	frame_rotation.add(table_rotation);
	
	// Options -> Even / Odd
	group_radiobutton_evenodd = radiobutton_evenodd_all.get_group();
	radiobutton_evenodd_even.set_group(group_radiobutton_evenodd);
	radiobutton_evenodd_odd.set_group(group_radiobutton_evenodd);
	radiobutton_evenodd_all.set_active();
	
	table_evenodd.set_spacings(5);
	table_evenodd.set_border_width(5);
	table_evenodd.attach(radiobutton_evenodd_all,  0, 1, 0, 1, Gtk::FILL | Gtk::EXPAND, Gtk::SHRINK, 0, 0);
	table_evenodd.attach(radiobutton_evenodd_even, 0, 1, 1, 2, Gtk::FILL | Gtk::EXPAND, Gtk::SHRINK, 0, 0);
	table_evenodd.attach(radiobutton_evenodd_odd,  1, 2, 1, 2, Gtk::FILL | Gtk::EXPAND, Gtk::SHRINK, 0, 0);
	frame_evenodd.add(table_evenodd);
	
	// Options -> Rotation and Even/Odd
	hbox_rotation_evenodd.pack_start(frame_rotation, Gtk::PACK_SHRINK, 0);
	hbox_rotation_evenodd.pack_start(frame_evenodd,  Gtk::PACK_SHRINK, 0);
	
	// Options ->  Pages
	hbox_pages.set_border_width(5);
	hbox_pages.pack_start(entry_pages, Gtk::PACK_EXPAND_WIDGET, 0);
	frame_pages.add(hbox_pages);
	
	// Options ->  Password
	entry_password.set_visibility(false);
	hbox_password.set_border_width(5);
	hbox_password.pack_start(entry_password, Gtk::PACK_EXPAND_WIDGET, 0);
	frame_password.add(hbox_password);
	
	// Options -> Button
	button_set.set_size_request(150,-1);
	alignment_button.add(button_set);
	hbox_button.pack_start(alignment_button, Gtk::PACK_EXPAND_WIDGET, 0);
	
	// Options -> Options
	vbox_options.set_border_width(5);
	vbox_options.add(hbox_rotation_evenodd);
	vbox_options.add(frame_pages);
	vbox_options.add(frame_password);
	vbox_options.add(hbox_button);
	
	add(vbox_options);
	
	show_all_children();
	return;
}



/*** Set Options ***/
void class_window_merge_options::set_options(Glib::ustring rotation, 
											 Glib::ustring evenodd,
											 Glib::ustring pages,
											 Glib::ustring password){
												 
												 // Rotation
												 if(rotation == Text::str_0_DEG)
													 radiobutton_rotation_0.set_active();
												 else if(rotation == Text::str_90_DEG)
													 radiobutton_rotation_90.set_active();
												 else if(rotation == Text::str_180_DEG)
													 radiobutton_rotation_180.set_active();
												 else if(rotation == Text::str_270_DEG)
													 radiobutton_rotation_270.set_active();
												 else{
													 radiobutton_rotation_0.set_active();
													 std::cerr << std::endl << "void class_window_merge_options::set_options(): unknown rotation";
												 }
												 
												 // Even/Odd/All
												 if(evenodd == Text::str_ALL)
													 radiobutton_evenodd_all.set_active();
												 else if(evenodd == Text::str_EVEN)
													 radiobutton_evenodd_even.set_active();
												 else if(evenodd == Text::str_ODD)
													 radiobutton_evenodd_odd.set_active();
												 else{
													 radiobutton_evenodd_all.set_active();
													 std::cerr << std::endl << "void class_window_merge_options::set_options(): unknown evenodd";
												 }
												 
												 entry_pages.set_text(pages);       // Pages
												 entry_password.set_text(password); // Input Password
												 
												 return;
											 }



/*** Get Rotation ***/
Glib::ustring class_window_merge_options::get_rotation(){
	
	Glib::ustring value;
	
	if(radiobutton_rotation_0.property_active() == true)
		value = Text::str_0_DEG;
	else if(radiobutton_rotation_90.property_active() == true)
		value = Text::str_90_DEG;
	else if(radiobutton_rotation_180.property_active() == true)
		value = Text::str_180_DEG;
	else if(radiobutton_rotation_270.property_active() == true)
		value = Text::str_270_DEG;
	else{
		value = Text::str_0_DEG;
		std::cerr << std::endl << "Glib::ustring get_rotation(): unknown rotation";
	}
	
	return value;
}



/*** Get Even/Odd ***/
Glib::ustring class_window_merge_options::get_evenodd(){
	
	Glib::ustring value;
	
	if(radiobutton_evenodd_all.property_active() == true)
		value = Text::str_ALL;
	else if(radiobutton_evenodd_even.property_active() == true)
		value = Text::str_EVEN;
	else if(radiobutton_evenodd_odd.property_active() == true)
		value = Text::str_ODD;
	else{
		value = Text::str_ALL;
		std::cerr << std::endl << "Glib::ustring get_evenodd(): unknown evenodd";
	}
	
	return value;
}



/*** Get Pages ***/
Glib::ustring class_window_merge_options::get_pages(){
	
	return entry_pages.get_text();
}

/*** Get Password ***/
Glib::ustring class_window_merge_options::get_password(){
	
	return entry_password.get_text();
}



/*** Clear ***/
void class_window_merge_options::clear(){
	
	//hide();
	radiobutton_rotation_0.set_active();
	radiobutton_evenodd_all.set_active();
	entry_pages.set_text("");
	entry_password.set_text("");
	
	return;
}
