/*****************************************************************************
 *                                                                           *
 * Program:   paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * Modul:     mirror.c                                                       *
 *            mirror images horizontally or/and vertically                   *
 * Author:    Andreas Tille                                                  *
 * Date:      30.09.1998                                                     *
 * Copyright: Andreas Tille, 1999; GNU Public License                        *
 *                                                                           *
 *****************************************************************************/

#include <stdlib.h>
#include "paul.h" 
#include <gtkimrot.h>

int MakeMirror(PAUL *p)
/* mirror a set of images on vertical (at a horizontal axis) or horizontal (at a vertical axis)
 * --- Parameter: ---
 * PAUL   *p            : list of images
 * --- Return: ---
 * int     MakeMirror() : RET_ERR or RET_OK
 */
{
  PICTURE *bild;
  GList   *pl;
  char    *desc;

  g_return_val_if_fail ( IS_PAUL(p), RET_ERR );
  g_return_val_if_fail ( IS_PICTURE(BILD(p->piclist)), RET_ERR );
  
  for ( bild = BILD(pl = p->piclist); pl; bild = BILD(pl = pl->next) ) {
    if ( HMirror(p->opt->f) ) 
      gtk_imrot_mirror_horizontally(bild->data, bild->width, bild->height, bild->storepix);
    if ( VMirror(p->opt->f) )
      gtk_imrot_mirror_vertically(bild->data, bild->width, bild->height, bild->storepix);
    if ( bild->im ) gdk_imlib_changed_image(bild->im);
    if ( !Rotate180(p->opt->f) ) {
      desc = g_strdup_printf("Mirror %s %s", ImgFileName(bild), 
                              HMirror(p->opt->f) ? "horizontally" : "vertically");
      ImgChunksUpdate(bild, TypMirror, desc, APPMIRROR, Mirror(p->opt->f));
      FREE(desc);
    }
  }
  p->opt->f &= ~(MIRROR_H | MIRROR_V);
  return RET_OK;
}


