#include <stdio.h>
#include <malloc.h>

#include "zchat.h"

struct command * new_command() {
  struct command * tmp = (struct command *)malloc(sizeof(struct command));
  if (!tmp) {
    perror("new_command");
    exit(1);
  }

  tmp->id = CmdNone;
  tmp->len = 0;
  tmp->data = NULL;

  tmp->mudmaster = NULL;
  tmp->zchat = NULL;

  return tmp;
}

void delete_command(struct command * command) {
  if(command->data)
    free(command->data);

  if(command->zchat)
    free(command->zchat);

  if (command->mudmaster)
    free(command->mudmaster);

  free(command);
}

void build_command(struct command * command) {
  uint16_t tmp;

  char * tmpptr = (char *)&tmp;

  if (!command->data)
    return;

  if (command->mudmaster)
    free(command->mudmaster);

  if (command->zchat)
    free(command->zchat);

  command->mudmaster = (char *)malloc(1+command->len+1);
  command->zchat = (char *)malloc(2+2+command->len);

  //command->mudmaster[0] = (char)(command->id);
  command->mudmaster[0] = (char)host_to_zchat(command->id);
  memcpy(command->mudmaster + 1, command->data, command->len);
  command->mudmaster[1+command->len+1-1] = (char)'\255';

  //tmp = command->id;
  tmp = host_to_zchat(command->id);

  command->zchat[0] = *tmpptr;
  command->zchat[1] = *(tmpptr+1);

  //tmp = command->len;
  tmp = host_to_zchat(command->len);

  command->zchat[2] = *tmpptr;
  command->zchat[3] = *(tmpptr+1);

  if (command->len > 0)
    memcpy(command->zchat + 4, command->data, command->len);
}
