# Portal command extraction code, used for debugging Portal
# client support on Abandoned Reality.
#
# This code is released into the Public Domain.
# Author: Catherine Allen (mango@turf.org)

import papaya
import re
import string

portal_regex = re.compile("(.*)#K%([0-9][0-9][0-9][0-9][0-9])([0-9][0-9][0-9])([a-zA-Z][a-zA-Z][a-zA-Z])([\000-\377]*)")
bab_regex = re.compile("([^~]*)~([^~]*)~([^~]*)")

def portal_filter(text):

    while 1 == 1:

        result = portal_regex.match(text)
        if result == None:
            return text

        security_code = result.group(2)
        length = result.group(3)
        command = result.group(4)
        remainder = result.group(5)

        # Portal includes the command in the length.
        length = int(length) - 3
        data = remainder[0:length]

        print "Portal command of %s with data %s and length %d and security code %s\n" % (command, data, length, security_code)

        if command == "BAB":
            parse_bab(data)

        text = result.group(1) + remainder[length:]

def parse_bab(text):
    result = bab_regex.match(text)
    if result == None:
        print "Invalid BAB (tell) data: %s" % (text)
        return

    direction = result.group(1)
    sender = result.group(2)
    data = result.group(3)

    if direction == "x":
        papaya.vt_append("[portal] You -> %s: %s\n" % (sender, data))
    else:
        papaya.vt_append("[portal] %s -> You: %s\n" % (sender, data))

    return

print ("Registering portal filter.\n");
papaya.prompt_add("portal_filter")
papaya.output_add("portal_filter")
