#ifndef INCLUDE_BSXSCENE_H
#define INCLUDE_BSXSCENE_H

#ifdef WIN32
typedef unsigned char uint8_t;
typedef unsigned short uint16_t;
typedef unsigned int uint32_t;
#else
#  include <inttypes.h>
#endif

#include "BSXCache.h"

#include <list>
#include <algorithm>

typedef struct bsx_object_ {
  BSXCacheEntry * entry;
  uint8_t x;
  uint8_t y;
} BSXObject;

class BSXScene {

 public:
  BSXScene();
  virtual ~BSXScene();

  void addObject(BSXCacheEntry *, char *);
  void removeObject(BSXCacheEntry *);
  void setScene(BSXCacheEntry *);

  void reset();
  virtual void redraw();

 protected:
  BSXCacheEntry * getScene();

  typedef std::list<BSXObject *> ObjectList;
  std::list<BSXObject *> objects;

 private:
  int stringToHex(char *);

  BSXCacheEntry * scene;

};

#endif // INCLUDE_BSXSCENE_H
