/*  ======================================================================  */
/*  ==========                                                  ==========  */
/*  ==========                P O L Y . C                       ==========  */
/*  ==========                                                  ==========  */
/*  ==========                 April 2002                       ==========  */
/*  ==========                                                  ==========  */
/*  ======================================================================  */

/*
 *	Coord   get coordinates by reading them or converting weight input
 *	Rat	rational functions
 *	Vertex	computes Vertices and Faces
 *      Polynf	normal form and symmetries
 *	-> class.x
 */

#include "Global.h"
#include "LG.h"

FILE *inFILE, *outFILE;

void  PrintUsage(char *c){
  int i;
#define	PUli	19
#define	PUitems	2*PUli
  char opt_string[PUitems][40]={
  "h  print this information           ",
  "f  use as filter                    ",
  "g  general output:                  ",
  "   P reflexive: numbers of (dual)   ",
  "     points/vertices, Hodge numbers ",
  "   P not reflexive: numbers of      ",
  "     points, vertices, equations    ",
  "p  points of P                      ",
  "v  vertices of P                    ",
  "e  equations of P/vertices of P-dual",
  "m  pairing matrix between vertices  ",
  "     and equations                  ",
  "d  points of P-dual                 ",
  "     (only if P reflexive)          ",
  "a  all of the above except h,f      ",
  "l  LG-`Hodge numbers' from single   ",
  "     weight input                   ",
  "r  ignore non-reflexive input       ",
  "D  dual polytope as input (ref only)",
  "n  do not complete polytope or      ",
  "     calculate Hodge numbers        ",
  "i  incidence information            ",
  "s  check for span property          ",
  "     (only if P from CWS)           ",
  "I  check for IP property            ",
  "S  number of symmetries             ",
  "T  upper triangular form	       ",
  "N  normal form                      ",
  "t  traced normal form computation   ",
  "V  IP simplices among vertices of P*",
  "P  IP simplices among points of P*  ",
  "     (with 1<=codim<=# when # is set)",
  "Z  lattice quotients for IP simplices",
  "#  #=1,2,3  fibers spanned by IP    ",
  "     simplices with codim<=#        ",
  "## ##=11,22,33,(12,23): all (fibered)",
  "     fibers with specified codim(s) ",
  "   when combined: ### = (##)#       "};

  printf("This is ``%s'':  computing data of a polytope P\n",c);
  printf("Usage:   %s [-<Option-string>] [in-file [out-file]]\n", c);
  printf("Options (concatenate any number of them into <Option-string>):\n");
  for (i=0;i<PUli;i++) printf("  %s | %s\n",opt_string[i],opt_string[i+PUli]);
  puts("Input:    degrees and weights `d1 w11 w12 ... d2 w21 w22 ...'");
  puts("          or `d np' or `np d' (d=Dimension, np=#[points]) and");
  puts("              (after newline) np*d coordinates");
  puts("Output:   as specified by options");
}
void PrintXUsage()
{ puts("Test/new options:   A  affine normal form");
printf("                    B  Barycenter and lattice volume [# ... points ");
							puts("at deg #]");
  puts("                    F  print all facets");
  puts("                    G  Gorenstein: divisible by I>1");
  puts("                    L  like 'l' with Hodge data for twisted sectors");
  puts("                    U  fano only: unimodular (&simplicial) facets");
  puts("                    C1 conifold CY (unimod with square codim 2 faces");
  puts("                    C2 conifold FANO (divisible by 2 & basic 2 faces");
  puts("		    z  fatness (4d)");
}
int  SimpUnimod(PolyPointList *P,VertexNumList *V,EqList *E);
int  ConifoldSing(PolyPointList *P,VertexNumList *V,EqList *E,
	PolyPointList *dP,EqList *dE,int CYorFANO);
void Print_if_Divisible(PolyPointList *P,VertexNumList *V);

#define	MaxFatPoly_2_stderr	(1)
void EPrint_VL(PolyPointList *_P, VertexNumList *V,double f);

typedef	struct 	{int p[SYM_Nmax][VERT_Nmax];}		VPermList;

int main (int narg, char* fn[]){
  int n=0, k, FilterFlag=0, lg=0, s=0, i=0, m=0, p=0, v=0, e=0, d=0, t=0, z=0,
    S=0, N=0, I=0, r=0, nc=0, g=0, D=0, IP, R, Tr, T=0, PS=0, VS=0, CD=0, ZS=1;
  char c; int A=0, B=0, G=0, F=0, U=0; int dd=0;
  CWS *CW=(CWS *) malloc(sizeof(CWS));
  Weight W;
  VertexNumList V;
  EqList *E = (EqList *) malloc(sizeof(EqList));
  EqList *DE = (EqList *) malloc(sizeof(EqList));
  BaHo BH;
  VaHo VH; 
  PolyPointList *_P = (PolyPointList *) malloc(sizeof(PolyPointList)),
               *_DP = (PolyPointList *) malloc(sizeof(PolyPointList));
  FaceInfo *FI=NULL;
  PairMat *PM = (PairMat *) malloc(sizeof(PairMat)),
         *DPM = (PairMat *) malloc(sizeof(PairMat));

  if((CW==NULL)||(E==NULL)||(_P==NULL)||(DE==NULL)||(_DP==NULL)
	||(PM==NULL)||(DPM==NULL)) {
    puts("Allocation failure: Reduce dimensions!"); exit(0);}
  CW->nw=0;

  while(narg > ++n) {
    if(fn[n][0]!='-') break;
    k=0;
    while ((c=fn[n][++k])!='\0'){
      if(c=='A') A=1;
      if(c=='B') B=1;
      if(c=='F') F=1;
      if(c=='G') G=1;
      if(c=='L') lg=2;
      if(c=='U') U=1;
      if(c=='C') U=2;
      if(c=='h') { PrintUsage(fn[0]); exit(0);}
      if(c=='x') { PrintXUsage(); exit(0);}
      if(c=='f') FilterFlag=1;
      if(c=='g') g=1;
      if(c=='l') lg=1; 
      if(c=='s') s=1;
      if(c=='i') i=1;
      if(c=='I') I=1;
      if(c=='m') m=1;
      if(c=='p') p=1;
      if(c=='v') v=1;
      if(c=='e') e=1;
      if(c=='d') d=1;
      if(c=='t') t=1;
      if(c=='S') S=1;
      if(c=='N') N=1;
      if(c=='T') T=1;
      if(c=='r') r=1;
      if(c=='n') nc=1;
      if(c=='P') PS=1;
      if(c=='V') VS=1;
      if(c=='Z') ZS=-1;
      if(c=='z') z=1;
      if(c=='D') D=1;
      if(('0'<=c)&&(c<='9')) CD=10*CD+c-'0';
      if(c=='a') {g=1; m=1; p=1; v=1; e=1; d=1; }}}
  n--;

  if(s+i+I+m+p+v+e+d+t+S+N+T+r+PS+VS+CD+G+A+B+F+z==0) g=1; VH.sts=(lg==2);
  if(g+lg+p+d+PS+CD==0) nc=1; /* don't need completion of points */
  if((T==1)&&(B+U+lg+g+s+i+I+m+p+v+e+d+t+S+N+PS+VS+(1-ZS)==0)){ puts(
    "\nT: change of basis must be combined with other options!\n");exit(0);}

  if(FilterFlag) {inFILE=NULL; outFILE=stdout;}
  else {
    if (narg > ++n)  inFILE=fopen(fn[n],"r");
    else inFILE=stdin;
    if (inFILE==NULL){printf("Input file %s not found!\n",fn[n]);exit(0);}
    if (narg > ++n) outFILE=fopen(fn[n],"w");
    else outFILE=stdout;     }			if(U==2) {nc=0;dd=CD;CD=0;}

  if(i){
    FI=(FaceInfo *) malloc(sizeof(FaceInfo));
    if (FI==NULL) {puts("Unable to allocate space for FaceInfo FI"); exit(0);}}

  while(lg ? Read_W_PP(&W,_P) : Read_CWS_PP(CW,_P)) {
    if(T) Make_Poly_UTriang(_P);
    R=0;
    if ((IP=Find_Equations(_P,&V,E))){
      if (D){
	int k;
	*_DP=*_P;
	R=EL_to_PPL(E, _P, &_P->n);
	VNL_to_DEL(_DP, &V, E);
	for (k=0;k<_P->np;k++) V.v[k]=k;
	V.nv=_P->np;      }
      else R=EL_to_PPL(E, _DP, &_P->n);}
    if (D&&!R) {fprintf(outFILE,"Input not reflexive!\n"); continue;}
    if (r&&!R) continue;
    Sort_VL(&V);
    Make_VEPM(_P,&V,E,*PM);
    if(!nc) {
      if(D||!(lg||CW->nw)) Complete_Poly(*PM,E,V.nv,_P);
      if(R&&!(D&&(lg||CW->nw))) {
	if(0==Transpose_PM(*PM, *DPM, V.nv, E->ne))
	{   fprintf(stderr,"Transpose_PM failed because #eq=%d > VERT_Nmax\n",
	    E->ne);exit(0);}
	VNL_to_DEL(_P, &V, DE);
	Complete_Poly(*DPM,DE,E->ne,_DP);}}
    if (U) {if (U==1) {if(!SimpUnimod(_P,&V,E))continue;} else {
	VNL_to_DEL(_P,&V,DE); if(!ConifoldSing(_P,&V,E,_DP,DE,dd))continue;}}
    if(g){
      if(!R||nc) {BH.mp=_P->np; BH.mv=V.nv; BH.np=0; BH.nv=E->ne;}
      else RC_Calc_BaHo(_P,&V,E,_DP,&BH);
      if(lg) {
	if ((Tr=Trans_Check(W))) LGO_VaHo(&W,&VH);
	Write_WH(&W, &BH, &VH, R, Tr, _P, &V, E); }
      else Print_CWH(CW, &BH); }
    if(s&&CW->nw) if(!Span_Check(E,&(CW->B),&_P->n))
      fprintf(outFILE,"No Span\n");
    if(I && !IP) fprintf(outFILE,"No IP\n");
    if(p) Print_PPL(_P,"Points of P");
    if(v) Print_VL(_P, &V, "Vertices of P");
    if(e) Print_EL(E, &_P->n, R,
          (R ? "Vertices of P-dual <-> Equations of P" : "Equations of P"));
    if(i){Make_Incidence(_P,&V,E,FI); Print_FaceInfo(_P->n,FI);}
    if(m) Print_Matrix(*PM, E->ne, V.nv,
		       "Pairing matrix of vertices and equations of P");
    if(d&&(_DP->np>E->ne)) Print_PPL(_DP, "Points of P-dual");
    if(S||N||t){
      int SymNum, VPMSymNum; Long NF[POLY_Dmax][VERT_Nmax]; 
      VPermList *VP = (VPermList*) malloc(sizeof(VPermList)); 
      assert(VP!=NULL); /* printf("=%d",t); fflush(0); */
      VPMSymNum=Make_Poly_Sym_NF(_P, &V, E, &SymNum, VP->p, NF, t);
      if (S) fprintf(outFILE,"#GL(Z,%d)-Symmetries=%d, #VPM-Symmetries=%d\n",
		     _P->n, SymNum, VPMSymNum);
      if (N) {char c[VERT_Nmax+38]="Normal form of vertices of P";
	int  Perm_String(int *p,int v,char *s);
	if(SymNum<SYM_Nmax)if(Perm_String(VP->p[SymNum],V.nv,&c[37]))
	{strcpy(&c[28],"    perm");c[36]='=';}
	Print_Matrix(NF, _P->n, V.nv,c);} free(VP);}
    if(R&&(PS||VS||CD)) IP_Simplices(_DP, (!D)*E->ne, PS*ZS, VS*ZS, CD);
    if(G) Print_if_Divisible(_P,&V);
    if(B){void LatVol_IPs_degD(PolyPointList *,VertexNumList *,EqList *,int);
	LatVol_IPs_degD(_P,&V,E,CD);}/* Volume, if(CD>0){(I)PS at CD*Poly} */
    if(F) {void Print_Facets(PolyPointList *,VertexNumList *,EqList *);
	Print_Facets(_P,&V,E);} 
    if(A) {void Make_ANF(PolyPointList *,VertexNumList *,EqList*,
	Long ANF[][VERT_Nmax]);
	Long ANF[POLY_Dmax][VERT_Nmax];
	Make_ANF(_P,&V,E,ANF); Print_Matrix(ANF, _P->n, V.nv,"");}
    if(z){
	  int CodimTwoFaceNum(PolyPointList *,VertexNumList *,EqList*);
   	  int f3=E->ne,f2=CodimTwoFaceNum(_P,&V,E),f1=f2-f3+V.nv,f0=V.nv;
	  static double fmax; double f=f1+f2; f/=f0+f3; assert(_P->n==4);
	  if(fmax<=f) {fmax=f;if(MaxFatPoly_2_stderr)EPrint_VL(_P,&V,f);}
	  printf("Flag=(%d,%d,%d,%d), Phi=%g<=%g\n",f0,f1,f2,f3,f,fmax);}
    fflush(outFILE);     }	return 0;
}
