###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_sun_virtualbox_priv_esc_vuln_lin.nasl 5287 2009-11-18 21:20:33Z nov $
#
# Sun VirtualBox 'VBoxNetAdpCtl' Privilege Escalation Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(901052);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.2");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-3692");
  script_bugtraq_id(36604);
  script_name("Sun VirtualBox 'VBoxNetAdpCtl' Privilege Escalation Vulnerability");
  desc = "
  Overview: This host is installed with Sun VirtualBox and is prone to Privilege
  Escalation vulnerability.

  Vulnerability Insight:
  The flaw is caused due to the 'VBoxNetAdpCtl' configuration tool improperly
  sanitising arguments before passing them in calls to 'popen()'.

  Impact:
  Successful exploitation will let attacker to execute arbitrary commands
  with root privileges via specially crafted arguments.

  Impact Level: Application

  Affected Software/OS:
  Sun VirtualBox version 3.x before 3.0.8

  Fix: Upgrade to Sun VirtualBox version 3.0.8
  http://www.virtualbox.org/wiki/Downloads

  References:
  http://secunia.com/advisories/36929
  http://www.virtualbox.org/wiki/Changelog
  http://www.vupen.com/english/advisories/2009/2845
  http://sunsolve.sun.com/search/document.do?assetkey=1-66-268188-1

  CVSS Score:
    CVSS Base Score     : 7.2 (AV:L/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 5.6
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Sun VirtualBox");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Privilege escalation");
  script_dependencies("secpod_sun_virtualbox_detect_lin.nasl");
  script_require_keys("Sun/VirtualBox/Lin/Ver");
  exit(0);
}


include("version_func.inc");

vbVer = get_kb_item("Sun/VirtualBox/Lin/Ver");
if(vbVer =~ "^3\..*")
{
  # Grep for VirtualBox version 3.0 < 3.0.8
  if(version_is_less(version:vbVer, test_version:"3.0.8")){
    security_hole(0);
  }
}
