###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_firefox_mult_vuln_jul09_lin.nasl 3622 2009-07-23 15:36:33Z jul $
#
# Mozilla Firefox Multiple Vulnerabilities July-09 (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900397);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"10.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-2462", "CVE-2009-2463", "CVE-2009-2464",
                "CVE-2009-2465", "CVE-2009-2466", "CVE-2009-2469",
                "CVE-2009-2471", "CVE-2009-2472");
  script_bugtraq_id(35765, 35769, 35775, 35770, 35776, 35772, 35766, 35773);
  script_name("Mozilla Firefox Multiple Vulnerabilities July-09 (Linux)");
  desc = "

  Overview: The host is installed with Firefox browser and is prone to multiple
  vulnerabilities.

  Vulnerability Insight:
  Multiple flaws are reported in Firefox, for more information refer below
  reference links.

  Impact:
  Successful exploitation could allow remote attacker to execute arbitrary code,
  memory corruption, XSS attacks and results in Denial of Service condition.

  Impact Level: System/Application

  Affected Software/OS:
  Mozilla Firefox version prior to 3.0.12 on Linux.

  Fix: Upgrade to Firefox version 3.0.12 or 3.5 or later
  http://www.mozilla.com/en-US/firefox/all.html

  References:
  http://www.vupen.com/english/advisories/2009/1972
  http://www.mozilla.org/security/announce/2009/mfsa2009-34.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-37.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-39.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-40.html

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.8
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("gb_firefox_detect_lin.nasl");
  script_require_keys("Firefox/Linux/Ver");
  exit(0);
}


include("version_func.inc");

ffVer = get_kb_item("Firefox/Linux/Ver");
if(!ffVer){
  exit(0);
}

# Grep for Firefox version < 3.0.12
if(version_is_less(version:ffVer, test_version:"3.0.12")){
  security_hole(0);
}
