##############################################################################
# OpenVAS Vulnerability Test
#
# Assess web security with w3af
#
# Authors:
# Vlatko Kosturjak <kost@linux.hr>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
 script_id(80109);
 script_version ("1.0");
 script_tag(name:"risk_factor", value:"None");
 name = "w3af (NASL wrapper)";
 script_name(name);
 
 desc = "
This plugin uses w3af (w3af_console to be exact) to find  
web security issues.

See the preferences section for w3af options.

Note that OpenVAS is using limited set of w3af options.
Therefore, for more complete web assessment, you should
use standalone w3af tool for deeper/customized checks.

Risk factor : None";

 script_description(desc);
 
 summary = "Assess web security with w3af";
 script_summary(summary);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright("This script is Copyright (C) 2009 Vlatko Kosturjak");
 family = "Web application abuses";
 script_family(family);
 script_add_preference(name: "Profile", type:"radio",value:"fast_scan;sitemap;web_infrastructure;OWASP_TOP10;audit_high_risk;bruteforce;full_audit");
 script_add_preference(name: "Seed URL", type: "entry", value: "");
 script_dependencies("find_service.nes", "httpver.nasl");
 script_require_ports("Services/www", 80);
 script_timeout(0); 
 exit(0);
}

# main code

cmdw3af = "w3af_console";

port = get_kb_item("Services/www");
if (! port) port = 80;
if (! get_port_state(port)) exit(0);

encaps = get_port_transport(port);
if (encaps > 1) httprefix="https://";
else httprefix="http://";

httpver = get_kb_item("http/"+port);
if (httpver == "11") {
	httparg=get_host_name();
} else {
	httparg=get_host_ip();
}

httpurl=httprefix+httparg+":"+port;

seed = script_get_preference ("Seed URL");
if (seed)
{
  if (ereg(pattern: "^/", string: seed))
  {
    httpurl = httpurl + seed;
  }
  else
  {
    httpurl = httpurl + "/" + seed;
  }
}

useprofile=script_get_preference("Profile");
if (!useprofile) useprofile = "fast_scan";

genfilename = get_tmp_dir() + "openvas-w3af-" + get_host_ip() + "-" + port;
cmdfilename = genfilename + ".cmd";
repfilename = genfilename + ".rep";
httpfilename = genfilename + ".http";

cmddata ="profiles use "+useprofile+'\n';
cmddata = cmddata + 'plugins\n';
# console doesn't work, so we use textFile
# termios error: (25, 'Inappropriate ioctl for device')
# cmddata = cmddata + 'output console\n';
# cmddata = cmddata + 'output config console\n';  
cmddata = cmddata + 'output textFile\n';
cmddata = cmddata + 'output config textFile\n';
if (report_verbosity > 1) {
	cmddata = cmddata + 'set verbose True\n';
} else {
	cmddata = cmddata + 'set verbose False\n';
}
cmddata = cmddata + 'set httpFileName '+httpfilename+'\n';
cmddata = cmddata + 'set fileName '+repfilename+'\n';
cmddata = cmddata + 'back\n';
cmddata = cmddata + 'back\n';
cmddata = cmddata + 'target\n';
cmddata = cmddata + 'set target ' + httpurl+ '\n';
cmddata = cmddata + 'back\n';

cmddata = cmddata + 'start\n';
cmddata = cmddata + 'exit\n';

function on_exit()
{
	if (file_stat(cmdfilename)) unlink(cmdfilename);
	if (file_stat(httpfilename)) unlink(httpfilename);
	if (file_stat (repfilename)) unlink(repfilename);
}

fwrite(data:cmddata, file:cmdfilename);

if (!find_in_path(cmdw3af)  )
{
    text = 'w3af could not be found in your system path.\n';
    text += 'OpenVAS was unable to execute w3af and to perform the scan you
requested.\nPlease make sure that w3af is installed and that '+cmdw3af+' is
available in the PATH variable defined for your environment.';
    log_message(port: port, data: text);
    exit(0);
}

i = 0;
argv[i++] = cmdw3af;
argv[i++] = "-s"; argv[i++] = cmdfilename;

r = pread(cmd: cmdw3af, argv: argv, cd: 1);
if (! r) exit(0);	# error

if (file_stat(repfilename)) {
	rfile=fread(repfilename);
	report = 'Here is the w3af report:\n';
	report += rfile;
	# rhttp=fread(httpfilename);
	if ('- vulnerability ]' >< report) {
		security_warning(port: port, data: report);
	} else {
		security_note(port: port, data: report);
	}
} else {
	text  = 'w3af report filename is empty. that could mean that\n';
	text += 'wrong version of w3af is used or tmp dir is not accessible.\n';
	text += 'In short: check installation of w3af and OpenVAS';
	log_message(port: port, data: text);
}
