###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for firefox-3.0, xulrunner-1.9 vulnerabilities USN-690-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840340);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"10.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_xref(name: "USN", value: "690-1");
  script_cve_id("CVE-2008-5500", "CVE-2008-5501", "CVE-2008-5502", "CVE-2008-5505", "CVE-2008-5506", "CVE-2008-5507", "CVE-2008-5508", "CVE-2008-5510", "CVE-2008-5511", "CVE-2008-5512", "CVE-2008-5513");
  script_name( "Ubuntu Update for firefox-3.0, xulrunner-1.9 vulnerabilities USN-690-1");
  desc = "

  Vulnerability Insight:

  Several flaws were discovered in the browser engine. These problems could allow
  an attacker to crash the browser and possibly execute arbitrary code with user
  privileges. (CVE-2008-5500, CVE-2008-5501, CVE-2008-5502)
  
  It was discovered that Firefox did not properly handle persistent cookie data.
  If a user were tricked into opening a malicious website, an attacker could
  write persistent data in the user's browser and track the user across browsing
  sessions. (CVE-2008-5505)
  
  Marius Schilder discovered that Firefox did not properly handle redirects to
  an outside domain when an XMLHttpRequest was made to a same-origin resource.
  It's possible that sensitive information could be revealed in the
  XMLHttpRequest response. (CVE-2008-5506)
  
  Chris Evans discovered that Firefox did not properly protect a user's data when
  accessing a same-domain Javascript URL that is redirected to an unparsable
  Javascript off-site resource. If a user were tricked into opening a malicious
  website, an attacker may be able to steal a limited amount of private data.
  (CVE-2008-5507)
  
  Chip Salzenberg, Justin Schuh, Tom Cross, and Peter William discovered Firefox
  did not properly parse URLs when processing certain control characters.
  (CVE-2008-5508)
  
  Kojima Hajime discovered that Firefox did not properly handle an escaped null
  character. An attacker may be able to exploit this flaw to bypass script
  sanitization. (CVE-2008-5510)
  
  Several flaws were discovered in the Javascript engine. If a user were tricked
  into opening a malicious website, an attacker could exploit this to execute
  arbitrary Javascript code within the context of another website or with chrome
  privileges. (CVE-2008-5511, CVE-2008-5512)
  
  Flaws were discovered in the session-restore feature of Firefox. If a user were
  tricked into opening a malicious website, an attacker could exploit this to
  perform cross-site scripting attacks or execute arbitrary Javascript code with
  chrome privileges. (CVE-2008-5513)

  Affected Software/OS:
  firefox-3.0, xulrunner-1.9 vulnerabilities on Ubuntu 8.04 LTS ,
  Ubuntu 8.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-December/000803.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of firefox-3.0, xulrunner-1.9 vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU8.10")
{

  if(isdpkgvuln(pkg:"abrowser", ver:"3.0-branding_3.0.5+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"3.0-branding_3.0.5+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"3.0-dev_3.0.5+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"3.0-gnome-support_3.0.5+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"3.0_3.0.5+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner", ver:"1.9-dev_1.9.0.5+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner", ver:"1.9-gnome-support_1.9.0.5+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner", ver:"1.9_1.9.0.5+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner-dev", ver:"1.9.0.5+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"abrowser", ver:"3.0.5+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-dev", ver:"3.0.5+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-gnome-support", ver:"3.0.5+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-granparadiso-dev", ver:"3.0.5+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-trunk-dev", ver:"3.0.5+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"3.0.5+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"3.0-dom-inspector_3.0.5+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"3.0-venkman_3.0.5+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-dom-inspector", ver:"3.0.5+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-granparadiso-dom-inspector", ver:"3.0.5+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-granparadiso-gnome-support", ver:"3.0.5+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-granparadiso", ver:"3.0.5+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-libthai", ver:"3.0.5+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-trunk-dom-inspector", ver:"3.0.5+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-trunk-gnome-support", ver:"3.0.5+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-trunk-venkman", ver:"3.0.5+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-trunk", ver:"3.0.5+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner", ver:"1.9-dom-inspector_1.9.0.5+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner", ver:"1.9-venkman_1.9.0.5+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"firefox", ver:"3.0-dev_3.0.5+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"3.0-gnome-support_3.0.5+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"3.0_3.0.5+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner", ver:"1.9-dev_1.9.0.5+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner", ver:"1.9-gnome-support_1.9.0.5+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner", ver:"1.9_1.9.0.5+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-dev", ver:"3.0.5+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-gnome-support", ver:"3.0.5+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-granparadiso-dev", ver:"3.0.5+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-trunk-dev", ver:"3.0.5+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"3.0.5+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"3.0-dom-inspector_3.0.5+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"3.0-venkman_3.0.5+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-dom-inspector", ver:"3.0.5+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-granparadiso-dom-inspector", ver:"3.0.5+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-granparadiso-gnome-support", ver:"3.0.5+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-granparadiso", ver:"3.0.5+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-libthai", ver:"3.0.5+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-trunk-dom-inspector", ver:"3.0.5+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-trunk-gnome-support", ver:"3.0.5+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-trunk-venkman", ver:"3.0.5+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-trunk", ver:"3.0.5+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner", ver:"1.9-dom-inspector_1.9.0.5+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner", ver:"1.9-venkman_1.9.0.5+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}