# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1287-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58338);
 script_cve_id("CVE-2006-7191", "CVE-2007-1840");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.2");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1287-1 (ldap-account-manager (0.4.9-2sarge1))";
 script_name(name);

 desc = "The remote host is missing an update to ldap-account-manager (0.4.9-2sarge1)
announced via advisory DSA 1287-1.

Two vulnerabilities have been identified in the version of
ldap-account-manager shipped with Debian 3.1 (sarge).

CVE-2006-7191
An untrusted PATH vulnerability could allow a local attacker to execute
arbitrary code with elevated privileges by providing a malicious rm
executable and specifying a PATH environment variable referencing this
executable.

CVE-2007-1840
Improper escaping of HTML content could allow an attacker to execute a
cross-site scripting attack (XSS) and execute arbitrary code in the
victim's browser in the security context of the affected web site.

For the old stable distribution (sarge), this problem has been fixed in
version 0.4.9-2sarge1.  Newer versions of Debian (etch, lenny, and sid),
are not affected.

We recommend that you upgrade your ldap-account-manager package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201287-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1287-1 (ldap-account-manager (0.4.9-2sarge1))";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"ldap-account-manager", ver:"0.4.9-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
