/* $Id: prefs_comment.c,v 1.1.1.1 2005-09-10 17:36:45 renaud Exp $
 *
 * Copyright (C) 2004 by Greenbone Networks GmbH
 * Author(s):
 * Jan-Oliver Wagner <jan@intevation.de>
 * Thomas Arendsen Hein <thomas@intevation.de>
 *
 * This program is free software under the GNU GPL (>=v2)
 * Read the file COPYING coming with the software for details.
 */

#include <includes.h>

#include <gtk/gtk.h>

#include "preferences.h"
#include "openvas_i18n.h"

/**
 * @brief Fill comment textview with preferences.
 */
void
fill_comment (struct context *context, struct arglist *ctrls)
{
  GtkTextBuffer *buffer = gtk_text_view_get_buffer(
      GTK_TEXT_VIEW(arg_get_value(ctrls, "COMMENT")));
  const gchar *text;

  text = prefs_get_string (context, "comment");

  if(text)
    {
      /* XXX remove unescaping as soon as prefs_get_string handles this */
      gchar *escaped = g_strcompress (text);

      gtk_text_buffer_set_text (buffer, escaped, -1);
      g_free (escaped);
    }
  else
    gtk_text_buffer_set_text(buffer, "", -1);
}

/**
 * @brief Save comment from textview to preferences.
 */
void
store_comment (struct context *context, struct arglist *ctrls)
{
  GtkTextBuffer *buffer = gtk_text_view_get_buffer(
      GTK_TEXT_VIEW(arg_get_value(ctrls, "COMMENT")));
  GtkTextIter start, end;
  gchar *text, *escaped;

  gtk_text_buffer_get_bounds(buffer, &start, &end);
  text = gtk_text_buffer_get_text(buffer, &start, &end, FALSE);
  /* XXX remove escaping as soon as prefs_set_string handles this */
  escaped = g_strescape(text, NULL);
  g_free(text);
  prefs_set_string(context, "comment", escaped);
  g_free(escaped);
}

/**
 * @brief Build a box element with a comment text editing field.
 * 
 * Returned arglist holds keys VBOX and COMMENT (textview for comment).
 * 
 * @return Arglist with widgets hooked into.
 */
struct arglist *
prefs_dialog_comment (void)
{
  struct arglist *ctrls = emalloc(sizeof(struct arglist));
  GtkWidget *box, *scrolledwindow, *textview;

  box = gtk_vbox_new(FALSE, FALSE);
  arg_add_value(ctrls, "VBOX", ARG_PTR, -1, box);

  scrolledwindow = gtk_scrolled_window_new(NULL, NULL);
  gtk_box_pack_start(GTK_BOX(box), scrolledwindow, TRUE, TRUE, 5);
  gtk_widget_show(scrolledwindow);

  textview = gtk_text_view_new();
  gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW(scrolledwindow), textview);
  arg_add_value(ctrls, "COMMENT", ARG_PTR, -1, textview);
  gtk_widget_show(textview);

  gtk_widget_show(box);

  return ctrls;
}
