//                                               -*- C++ -*-
/**
 *  @file  t_HyperbolicAnisotropicEnumerateFunction_std.cxx
 *  @brief The test file of class HyperbolicAnisotropicEnumerateFunction for standard methods
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-05-21 17:44:02 +0200 (mer, 21 mai 2008) $
 *  Id:      $Id: t_HyperbolicAnisotropicEnumerateFunction_std.cxx 818 2008-05-21 15:44:02Z dutka $
 */
#include <iostream>
#include <sstream>
#include <exception>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "NumericalSample.hxx"
#include "HyperbolicAnisotropicEnumerateFunction.hxx"
#include "LinearEnumerateFunction.hxx"
#include "Exception.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Type;
using namespace OT::Base::Stat;
using namespace OT::Uncertainty::Algorithm;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try {

    fullprint << "Default q : " << HyperbolicAnisotropicEnumerateFunction::DefaultQ << std::endl << std::endl;

    // first verify consistency with LinearEnumerateFunction
    UnsignedLong size(10);
    UnsignedLong stratas = 3;
    for (UnsignedLong dimension = 1; dimension < 4; ++ dimension)
    {
      HyperbolicAnisotropicEnumerateFunction f( dimension, 1.0 );
      LinearEnumerateFunction g(dimension);
      fullprint << "First " << size << " values for dimension " << dimension << std::endl;
      for (UnsignedLong index = 0; index < size; ++index)
      {
        if (f(index) != g(index))
          throw InternalException(HERE)<<"Results are different";
        fullprint << "index=" << index << " " << f(index) << std::endl;
      }
      Indices strataCardinal;
      for ( UnsignedLong index = 0; index < stratas; ++ index )
      {
        strataCardinal.add( f.getStrataCardinal(index) );
      }
      fullprint << "And first "<<stratas<<" strata cardinals :" << strataCardinal << std::endl << std::endl;
    }

    // values with varying q
    size = 25;
    NumericalPoint qValues;
    qValues.add(0.75);
    qValues.add(0.5);
    qValues.add(0.25);

    for (UnsignedLong dimension = 2; dimension < 5; ++ dimension)
    {
      for (UnsignedLong j = 0; j < qValues.getDimension(); ++ j)
      {
        NumericalScalar q(qValues[j]);
        fullprint << "First "<< size << " values dimension=" << dimension << " q=" << q << std::endl;
        HyperbolicAnisotropicEnumerateFunction f( dimension,  q);
        for (UnsignedLong index = 0; index < size; ++index)
        {
          fullprint << "index=" << index << " " << f(index) << std::endl;
        }
        Indices strataCardinal;
        for ( UnsignedLong index = 0; index < stratas; ++ index )
        {
          strataCardinal.add( f.getStrataCardinal(index) );
        }
        fullprint << "And first "<<stratas<<" strata cardinals :" << strataCardinal << std::endl << std::endl;
      }
    }



  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }

  return ExitCode::Success;
}
