//                                               -*- C++ -*-
/**
 *  @file  NonEllipticalDistribution.hxx
 *  @brief Abstract top-level class for non elliptical distributions
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: NonEllipticalDistribution.hxx 1866 2011-04-11 10:32:27Z schueller $
 */
#ifndef OPENTURNS_NONELLIPTICALDISTRIBUTION_HXX
#define OPENTURNS_NONELLIPTICALDISTRIBUTION_HXX

#include "ContinuousDistribution.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Model {


      /**
       * @class NonEllipticalDistribution
       *
       * All traditionnal distribution inherits from this class.
       * Classes derived from NonEllipticalDistribution are known by themselves,
       * without being reconstructed or built in any way.
       */
      class NonEllipticalDistribution
        : public ContinuousDistribution
      {
        CLASSNAME;
      public:

        typedef ContinuousDistribution::Implementation                        Implementation;
        typedef ContinuousDistribution::InvalidArgumentException              InvalidArgumentException;
        typedef ContinuousDistribution::InvalidDimensionException             InvalidDimensionException;
        typedef ContinuousDistribution::NotDefinedException                   NotDefinedException;
        typedef ContinuousDistribution::NumericalPoint                        NumericalPoint;
        typedef ContinuousDistribution::NumericalSample                       NumericalSample;
        typedef ContinuousDistribution::CovarianceMatrix                      CovarianceMatrix;
        typedef ContinuousDistribution::Indices                               Indices;
        typedef ContinuousDistribution::IsoProbabilisticTransformation        IsoProbabilisticTransformation;
        typedef ContinuousDistribution::InverseIsoProbabilisticTransformation InverseIsoProbabilisticTransformation;
        typedef Base::Stat::CorrelationMatrix                                 CorrelationMatrix;
        typedef Base::Type::SymmetricMatrix                                   SymmetricMatrix;
        typedef Base::Type::SquareMatrix                                      SquareMatrix;
        typedef ContinuousDistribution::NumericalPointWithDescriptionCollection              NumericalPointWithDescriptionCollection;

        /** Default constructor */
        explicit NonEllipticalDistribution(const String & name = OT::DefaultName);

        /** Virtual constructor */
        virtual NonEllipticalDistribution * clone() const;

        /** String converter */
        String __repr__() const;


      protected:


      private:


      }; /* class NonEllipticalDistribution */


    } /* namespace Model */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_NONELLIPTICALDISTRIBUTION_HXX */
