//                                               -*- C++ -*-
/**
 *  @file  CopulaImplementation.hxx
 *  @brief Abstract top-level class for all copula
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: CopulaImplementation.hxx 1866 2011-04-11 10:32:27Z schueller $
 */
#ifndef OPENTURNS_COPULAIMPLEMENTATION_HXX
#define OPENTURNS_COPULAIMPLEMENTATION_HXX

#include "OTprivate.hxx"
#include "ContinuousDistribution.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Model {

      /**
       * @class CopulaImplementation
       *
       * A subclass for Continuous usual distributions.
       */
      class CopulaImplementation
        : public ContinuousDistribution
      {
        CLASSNAME;
      public:

        typedef ContinuousDistribution::Implementation                        Implementation;
        typedef ContinuousDistribution::InvalidArgumentException              InvalidArgumentException;
        typedef ContinuousDistribution::NumericalPoint                        NumericalPoint;
        typedef ContinuousDistribution::NumericalPointCollection  NumericalPointCollection;
        typedef ContinuousDistribution::NumericalPointWithDescriptionCollection  NumericalPointWithDescriptionCollection;


        /** Default constructor */
        explicit CopulaImplementation(const String & name = OT::DefaultName);


        /** Virtual constructor */
        virtual CopulaImplementation * clone() const;

        /** Comparison operator */
        Bool operator ==(const CopulaImplementation & other) const;

        /** Get the mean of the distribution */
        NumericalPoint getMean() const /* throw(NotDefinedException) */;

        /** Get the standard deviation of the distribution */
        NumericalPoint getStandardDeviation() const /* throw(NotDefinedException) */;

        /** Get the skewness of the distribution */
        NumericalPoint getSkewness() const /* throw(NotDefinedException) */;

        /** Get the kurtosis of the distribution */
        NumericalPoint getKurtosis() const /* throw(NotDefinedException) */;

        /** Get the i-th marginal distribution */
        using ContinuousDistribution::getMarginal;
#ifndef SWIG
        CopulaImplementation * getMarginal(const UnsignedLong i) const /* throw(InvalidArgumentException) */;
#endif

        /** Get the copula of a distribution */
        Implementation getCopula() const;

        /** String converter */
        String __repr__() const;


        /* Methods inherited from upper classes */

        /** Generic implementation of the quantile computation for continuous distributions */
        NumericalPoint computeQuantile(const NumericalScalar prob,
                                       const Bool tail = false) const;

        /** Get the mathematical and numerical range of the distribution.
            Its mathematical range is the smallest closed interval outside
            of which the PDF is zero, and the numerical range is the interval
            outside of which the PDF is rounded to zero in double precision */
        Interval getRange() const;


      protected:

        /** Compute the covariance of the distribution */
        void computeCovariance() const /* throw(NotDefinedException) */;


      private:

      }; /* class CopulaImplementation */


    } /* namespace Model */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_COPULAIMPLEMENTATION_HXX */
