//                                               -*- C++ -*-
/**
 *  @file  TracyWidomGUE.cxx
 *  @brief The TracyWidomGUE distribution
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: TracyWidomGUE.cxx 1473 2010-02-04 15:44:49Z dutka $
 */
#include <cmath>
#include "TracyWidomGUE.hxx"
#include "RandomGenerator.hxx"
#include "Exception.hxx"
#include "PersistentObjectFactory.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Distribution {

      CLASSNAMEINIT(TracyWidomGUE);

      static Base::Common::Factory<TracyWidomGUE> RegisteredFactory("TracyWidomGUE");

      typedef Base::Stat::RandomGenerator              RandomGenerator;
      typedef Base::Common::NotYetImplementedException NotYetImplementedException;

      /* Default constructor */
      TracyWidomGUE::TracyWidomGUE()
        : NonEllipticalDistribution("TracyWidomGUE")
      {
        throw NotYetImplementedException(HERE);
        setDimension(1);
        setRange(Interval(-1.0, 1.0));
      }

      /* Comparison operator */
      Bool TracyWidomGUE::operator ==(const TracyWidomGUE & other) const
      {
        return true;
      }

      /* String converter */
      String TracyWidomGUE::__repr__() const {
        OSS oss;
        oss << "class=" << TracyWidomGUE::GetClassName()
            << " name=" << getName()
            << " dimension=" << getDimension();
        return oss;
      }

      /* Virtual constructor */
      TracyWidomGUE * TracyWidomGUE::clone() const
      {
        return new TracyWidomGUE(*this);
      }

      /* Get the DDF of the distribution */
      TracyWidomGUE::NumericalPoint TracyWidomGUE::computeDDF(const NumericalPoint & point) const
      {
        throw NotYetImplementedException(HERE);
        NumericalScalar x(point[0]);
        if ((x <= -1.0) || (x > 1.0)) return NumericalPoint(1, 0.0);
        return NumericalPoint(1, -1.5 * x);
      }


      /* Get the PDF of the distribution */
      NumericalScalar TracyWidomGUE::computePDF(const NumericalPoint & point) const
      {
        throw NotYetImplementedException(HERE);
        NumericalScalar x(point[0]);
        if ((x <= -1.0) || (x > 1.0)) return 0.0;
        return 0.75 * (1.0 + x) * (1.0 - x);
      }


      /* Get the CDF of the distribution */
      NumericalScalar TracyWidomGUE::computeCDF(const NumericalPoint & point, const Bool tail) const
      {
        throw NotYetImplementedException(HERE);
        NumericalScalar x(point[0]);
        if (x <= -1.0) return (tail ? 1.0 : 0.0);
        if (x > 1.0) return (tail ? 0.0 : 1.0);
        if (tail) return 0.5 - x * (0.75 - 0.25 * x * x);
        return 0.5 + x * (0.75 - 0.25 * x * x);
      }

      /** Get the PDFGradient of the distribution */
      TracyWidomGUE::NumericalPoint TracyWidomGUE::computePDFGradient(const NumericalPoint & point) const
      {
        return NumericalPoint(0);
      }

      /** Get the CDFGradient of the distribution */
      TracyWidomGUE::NumericalPoint TracyWidomGUE::computeCDFGradient(const NumericalPoint & point) const
      {
        return NumericalPoint(0);
      }

      /* Get the quantile of the distribution */
      NumericalScalar TracyWidomGUE::computeScalarQuantile(const NumericalScalar prob,
                                                           const Bool tail,
                                                           const NumericalScalar precision) const
      {
        throw NotYetImplementedException(HERE);
        // 2.094395102393195492308429 = 2 * Pi / 3
        if (tail) return 2.0 * cos(0.3333333333333333333333333 * acos(2.0 * prob - 1.0) - 2.094395102393195492308429);
        return 2.0 * cos(0.3333333333333333333333333 * acos(1.0 - 2.0 * prob) - 2.094395102393195492308429);
      }

      /* Get the roughness, i.e. the L2-norm of the PDF */
      NumericalScalar TracyWidomGUE::getRoughness() const
      {
        throw NotYetImplementedException(HERE);
        return 0.6;
      }

      /* Compute the mean of the distribution */
      void TracyWidomGUE::computeMean() const
      {
        // RMT matlab toolbox computation
        mean_ = NumericalPoint(1, -1.771086807411);
        isAlreadyComputedMean_ = true;
      }

      /* Get the standard deviation of the distribution */
      TracyWidomGUE::NumericalPoint TracyWidomGUE::getStandardDeviation() const /* throw(NotDefinedException) */
      {
        // RMT matlab toolbox computation
        return NumericalPoint(1, 0.813194792832);
      }

      /* Get the skewness of the distribution */
      TracyWidomGUE::NumericalPoint TracyWidomGUE::getSkewness() const /* throw(NotDefinedException) */
      {
        // RMT matlab toolbox computation
        return NumericalPoint(1, 0.224084203610);
      }

      /* Get the kurtosis of the distribution */
      TracyWidomGUE::NumericalPoint TracyWidomGUE::getKurtosis() const /* throw(NotDefinedException) */
      {
        // RMT matlab toolbox computation
        return NumericalPoint(1, 0.0934480876);
      }

      /* Compute the covariance of the distribution */
      void TracyWidomGUE::computeCovariance() const
      {
        covariance_ = CovarianceMatrix(1);
        const NumericalScalar sigma(getStandardDeviation()[0]);
        covariance_(0, 0) = sigma * sigma;
        isAlreadyComputedCovariance_ = true;
      }

      /* Parameters value and description accessor */
      TracyWidomGUE::NumericalPointWithDescriptionCollection TracyWidomGUE::getParametersCollection() const
      {
        // No parameter, return a collection with an empty NumericalPointWithDescription
        return NumericalPointWithDescriptionCollection(1, NumericalPointWithDescription(0));
      }

      /* Method save() stores the object through the StorageManager */
      void TracyWidomGUE::save(StorageManager::Advocate & adv) const
      {
        NonEllipticalDistribution::save(adv);
      }

      /* Method load() reloads the object from the StorageManager */
      void TracyWidomGUE::load(StorageManager::Advocate & adv)
      {
        NonEllipticalDistribution::load(adv);
      }

    } /* namespace Distribution */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
