//                                               -*- C++ -*-
/**
 *  @file  MarginalTransformationGradient.hxx
 *  @brief Class for the Nataf transformationGradient evaluation for elliptical
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: souchaud $
 *  @date:   $LastChangedDate: 2011-07-01 10:34:36 +0200 (Fri, 01 Jul 2011) $
 *  Id:      $Id: MarginalTransformationGradient.hxx 1981 2011-07-01 08:34:36Z souchaud $
 */
#ifndef OPENTURNS_MARGINALTRANSFORMATIONGRADIENT_HXX
#define OPENTURNS_MARGINALTRANSFORMATIONGRADIENT_HXX

#include "OTprivate.hxx"
#include "NumericalMathGradientImplementation.hxx"
#include "MarginalTransformationEvaluation.hxx"
#include "Matrix.hxx"
#include "NumericalPoint.hxx"
#include "Exception.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Algorithm {


      /**
       * @class MarginalTransformationGradient
       *
       * This class offers an interface for the Nataf function for elliptical distributions
       */
      class MarginalTransformationGradient
        : public Base::Func::NumericalMathGradientImplementation
      {
        CLASSNAME;
      public:

        typedef Base::Func::NumericalMathGradientImplementation NumericalMathGradientImplementation; // Required by SWIG
        typedef Base::Type::Matrix                              Matrix;
        typedef Base::Type::NumericalPoint                      NumericalPoint;
        typedef Model::Distribution                             Distribution;
        typedef Base::Type::Collection<Distribution>            DistributionCollection;
        typedef Base::Common::InternalException                 InternalException;
        typedef Base::Common::InvalidArgumentException          InvalidArgumentException;
        typedef Base::Common::StorageManager                    StorageManager;

        /** Default constructor */
        MarginalTransformationGradient();

        /** Parameter constructor */
        MarginalTransformationGradient(const MarginalTransformationEvaluation & evaluation);


        /** Virtual constructor */
        virtual MarginalTransformationGradient * clone() const;

        /** Gradient */
        Matrix gradient(const NumericalPoint & inP) const
          /* throw (InvalidArgumentException, InternalException) */;

        /** Accessor for input point dimension */
        virtual UnsignedLong getInputDimension() const
          /* throw(InternalException) */;

        /** Accessor for output point dimension */
        virtual UnsignedLong getOutputDimension() const
          /* throw(InternalException) */;

        /** String converter */
        virtual String __repr__() const;
        virtual String __str__(const String & offset = "") const;

        /** Method save() stores the object through the StorageManager */
        void save(StorageManager::Advocate & adv) const;

        /** Method load() reloads the object from the StorageManager */
        void load(StorageManager::Advocate & adv);

      protected:


      private:
        // The evaluation class associated with the gradient
        MarginalTransformationEvaluation evaluation_;

      }; /* MarginalTransformationGradient */


    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_MARGINALTRANSFORMATIONGRADIENT_HXX */
