//                                               -*- C++ -*-
/**
 *  @file  BootstrapExperiment.cxx
 *  @brief Abstract top-level view of an bootstrapExperiment plane
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu, 26 jun 2008) $
 *  Id:      $Id: BootstrapExperiment.cxx 862 2008-06-26 11:50:17Z dutka $
 */
#include "BootstrapExperiment.hxx"
#include "UserDefined.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Algorithm {

      CLASSNAMEINIT(BootstrapExperiment);

      typedef Distribution::UserDefined UserDefined;

      /* Default constructor */
      BootstrapExperiment::BootstrapExperiment(const String & name):
        WeightedExperiment(name)
      {
        // Nothing to do
      }

      /* Constructor with parameters */
      BootstrapExperiment::BootstrapExperiment(const NumericalSample & sample,
                                               const String & name):
        WeightedExperiment(UserDefined(sample), sample.getSize(), name)
      {
        // Nothing to do
      }

      /* Virtual constructor */
      BootstrapExperiment * BootstrapExperiment::clone() const
      {
        return new BootstrapExperiment(*this);
      }

      /* String converter */
      String BootstrapExperiment::__repr__() const
      {
        OSS oss;
        oss << "class=" << GetClassName()
            << " name=" << getName()
            << " distribution=" << distribution_
            << " size=" << size_;
        return oss;
      }

      /* Sample generation */
      BootstrapExperiment::NumericalSample BootstrapExperiment::generate()
      {
        return distribution_.getNumericalSample(size_);
      }

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
