//                                               -*- C++ -*-
/**
 *  @file  Description.hxx
 *  @brief Description is a collection of string for human usage
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: souchaud $
 *  @date:   $LastChangedDate: 2011-07-19 11:05:55 +0200 (Tue, 19 Jul 2011) $
 *  Id:      $Id: Description.hxx 2028 2011-07-19 09:05:55Z souchaud $
 */
#ifndef OPENTURNS_DESCRIPTION_HXX
#define OPENTURNS_DESCRIPTION_HXX

#include "TypedCollectionInterfaceObject.hxx"
#include "DescriptionImplementation.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Type
    {

      /**
       * @typedef Description
       *
       * Description is a collection of string for human usage
       */

      class Description :
        public Common::TypedCollectionInterfaceObject<DescriptionImplementation>
      {
        CLASSNAME;
      public:

        /** Default constructor */
        Description();

        /** Constructor with size */
        Description(const UnsignedLong size);

        /** Constructor with value */
        Description(const String & value);

        /** Constructor with size and default value */
        Description(const UnsignedLong size,
                    const String & value);

        /** Contructor from implementation */
        Description(const DescriptionImplementation & implementation);

        /** Destructor */ 
        virtual ~Description();

#ifdef SWIG
        /** @copydoc Object::__repr__() const */
        virtual String __repr__() const;

        /** @copydoc Object::__str__() const */
        virtual String __str__(const String & offset = "") const;
#endif

        void sort();
      }; /* class Description */


    } /* namespace Type */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_DESCRIPTION_HXX */
