//                                               -*- C++ -*-
/**
 *  @file  SobolIndicesResult.cxx
 *  @brief SobolIndicesResult permits to choose which indices to compute
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2008-05-05 08:50:15 +0200 (lun, 05 mai 2008) $
 *  Id:      $Id: SobolIndicesResult.cxx 805 2008-05-05 06:50:15Z schueller $
 */

#include "SobolIndicesResult.hxx"

namespace OpenTURNS
{
  namespace Base
  {
    namespace Stat
    {

      CLASSNAMEINIT(SobolIndicesResult);

      /* constructor with parameters */
      SobolIndicesResult::SobolIndicesResult() :
        PersistentObject()
      {
        // Nothing to do
      }


      /* Virtual constructor */
      SobolIndicesResult * SobolIndicesResult::clone() const
      {
        return new SobolIndicesResult(*this);
      }


      /* first order Sobol' indices accessor */
      SobolIndicesResult::NumericalPoint SobolIndicesResult::getFirstOrderIndice() const
      {
        return firstOrderIndice_;
      }

      void SobolIndicesResult::setFirstOrderIndice(NumericalPoint & firstOrderIndice)
      {
        firstOrderIndice_ = firstOrderIndice;
      }


      /* second order Sobol' indices accessor */
      SobolIndicesResult::SymmetricMatrix SobolIndicesResult::getSecondOrderIndice() const
      {
        return secondOrderIndice_;
      }

      void SobolIndicesResult::setSecondOrderIndice(const SymmetricMatrix & secondOrderIndice)
      {
        secondOrderIndice_ = secondOrderIndice;
      }


      /* third order Sobol' indices accessor */
      SobolIndicesResult::SymmetricTensor SobolIndicesResult::getThirdOrderIndice() const
      {
        return thirdOrderIndice_;
      }

      void SobolIndicesResult::setThirdOrderIndice(const SymmetricTensor & thirdOrderIndice)
      {
        thirdOrderIndice_ = thirdOrderIndice;
      }


      /* total order (order = dimension - 1) Sobol' indices accessor */
      SobolIndicesResult::NumericalPoint SobolIndicesResult::getTotalOrderIndice() const
      {
        return totalOrderIndice_;
      }

      void SobolIndicesResult::setTotalOrderIndice(const NumericalPoint & totalOrderIndice)
      {
        totalOrderIndice_ = totalOrderIndice;
      }


      /* String converter */
      String SobolIndicesResult::__repr__() const
      {
        OSS oss;
        oss << "class=" << SobolIndicesResult::GetClassName()
            << " firstOrderIndice=" << firstOrderIndice_
            << " secondOrderIndice=" << secondOrderIndice_
            << " thirdOrderIndice=" << thirdOrderIndice_
            << " totalOrderIndice=" << totalOrderIndice_;
        return oss;
      }

    } // namespace Stat
  } // namespace Base
} // namespace OpenTURNS
