//                                               -*- C++ -*-
/**
 *  @file  SQP.hxx
 *  @brief SQP is an actual implementation for
 *         NearestPointAlgorithm using the SQP algorithm.
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: SQP.hxx 1866 2011-04-11 10:32:27Z schueller $
 */
#ifndef OPENTURNS_SQP_HXX
#define OPENTURNS_SQP_HXX

#include "OTprivate.hxx"
#include "SQPSpecificParameters.hxx"
#include "NearestPointAlgorithmImplementation.hxx"
#include "NumericalPoint.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Optim
    {

      /**
       * @class SQP
       * SQP is an actual implementation for
       * NearestPointAlgorithm
       */

      class SQP :
        public NearestPointAlgorithmImplementation
      {
        CLASSNAME;

      public:

        typedef Base::Common::InvalidArgumentException                      InvalidArgumentException;
        typedef NearestPointAlgorithmImplementation::NumericalMathFunction  NumericalMathFunction;
        typedef NearestPointAlgorithmImplementation::InternalException      InternalException;
        typedef Type::NumericalPoint                                        NumericalPoint;
        typedef Type::SymmetricMatrix                                       SymmetricMatrix;
        typedef Type::IdentityMatrix                                        IdentityMatrix;
        typedef Type::MatrixImplementation                                  MatrixImplementation;
        typedef Type::SquareMatrix                                          SquareMatrix;
        typedef Base::Optim::SQPSpecificParameters                          SQPSpecificParameters;

        /** Default constructor */
        SQP();

        /** Constructor with parameters */
        SQP(const SQPSpecificParameters & specificParameters,
            const NumericalMathFunction & levelFunction,
            const Bool verbose = false);


        /** Virtual constructor */
        virtual SQP * clone() const;

        /** Performs the actual computation. Must be overloaded by the actual optimisation algorithm */
        void run()
          /* throw(InternalException) */;

        /** Specific parameters accessor */
        SQPSpecificParameters getSpecificParameters() const;

        /** Specific parameters accessor */
        void setSpecificParameters(const SQPSpecificParameters & specificParameters);

        /** String converter */
        String __repr__() const;

        /** Method save() stores the object through the StorageManager */
        void save(StorageManager::Advocate & adv) const;

        /** Method load() reloads the object from the StorageManager */
        void load(StorageManager::Advocate & adv);


      private:

        /** Perform a line search in the given direction */
        NumericalScalar computeLineSearch();

        /** SQP specific parameters */
        SQPSpecificParameters specificParameters_;

        /** SQP current penalization factor */
        NumericalScalar currentSigma_;

        /** SQP current point */
        NumericalPoint currentPoint_;

        /** SQP current direction */
        NumericalPoint currentDirection_;

        /** SQP current level value */
        NumericalScalar currentLevelValue_;

        /** SQP current gradient as a column vector */
        NumericalPoint currentGradient_;

        /** SQP current hessian as a symmetric tensor */
        SymmetricMatrix currentHessian_;

        /** SQP current system matrix as a symmetric matrix */
        SymmetricMatrix currentSystemMatrix_;

        /** SQP current system second member as a column vector */
        NumericalPoint currentSecondMember_;

        /** SQP current Lagrange multiplier */
        NumericalScalar currentLambda_;

      }; /* class SQP */

    } /* namespace Optim */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_SQP_HXX */
