//                                               -*- C++ -*-
/**
 *  @file  Cobyla.hxx
 *  @brief Cobyla is an actual implementation for
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-05-24 19:30:41 +0200 (Tue, 24 May 2011) $
 *  Id:      $Id: Cobyla.hxx 1910 2011-05-24 17:30:41Z schueller $
 */
#ifndef OPENTURNS_COBYLA_HXX
#define OPENTURNS_COBYLA_HXX

#include "CobylaSpecificParameters.hxx"
#include "OTprivate.hxx"
#include "NearestPointAlgorithmImplementation.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Optim
    {

      /**
       * @class cobyla
       * cobyla is an actual implementation for
       * NearestPointAlgorithm using the cobyla library
       */
      class Cobyla :
        public NearestPointAlgorithmImplementation
      {
        CLASSNAME;
      public:

        typedef NearestPointAlgorithmImplementation::NumericalMathFunction NumericalMathFunction;
        typedef NearestPointAlgorithmImplementation::InternalException     InternalException;
        typedef Base::Optim::CobylaSpecificParameters                       CobylaSpecificParameters;

        /** Default constructor */
        Cobyla();

        /** Constructor with parameters */
        Cobyla(const NumericalMathFunction & levelFunction,
               const Bool verbose = false);


        /** Constructor with parameters */
        Cobyla(const CobylaSpecificParameters & specificParameters,
               const NumericalMathFunction & levelFunction,
               const Bool verbose = false);


        /** Virtual constructor */
        virtual Cobyla * clone() const;

        /** Performs the actual computation. Must be overloaded by the actual optimisation algorithm */
        void run()
          /* throw(InternalException) */;

        /** Specific parameters accessor */
        CobylaSpecificParameters getSpecificParameters() const;

        /** Specific parameters accessor */
        void setSpecificParameters(const CobylaSpecificParameters & specificParameters);
        /** String converter */
        String __repr__() const;

      private:

        /**
         * Function that computes half of the squared of a Vector. It will
         * become the objective function of the minimisation problem
         */
        static int ComputeObjectiveAndConstraint(int n,
                                                 int m,
                                                 double *x,
                                                 double *f,
                                                 double *con,
                                                 void *state);
        CobylaSpecificParameters specificParameters_;
      }; /* class Cobyla */

    } /* namespace Optim */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_COBYLA_HXX */
