//                                               -*- C++ -*-
/**
 *  @file  TBB.cxx
 *  @brief This file supplies support for multithreading
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2010-01-27 14:00:03 +0100 (Wed, 27 Jan 2010) $
 *  Id:      $Id: IdFactory.cxx 1452 2010-01-27 13:00:03Z dutka $
 */

#include <iostream>
#include <cassert>
#include <cstdlib>
#include <errno.h>

#include "OTconfig.hxx"
#include "OTthread.hxx"
#include "TBB.hxx"
#include "ResourceMap.hxx"
#include "MutexLock.hxx"
#include "Log.hxx"

namespace OpenTURNS {

  const UnsignedLong TBB::GrainSize_ = Base::Common::ResourceMap::GetAsUnsignedLong( "parallel-execution-grainsize" );

  static pthread_mutex_t TBB_InstanceMutex_;
  static TBB * TBB_P_instance_ = 0;
  static pthread_once_t TBB_InstanceMutex_once = PTHREAD_ONCE_INIT;

#ifdef HAVE_TBB
  tbb::task_scheduler_init * TBB_P_scheduler_ = 0;
#endif /* HAVE_TBB */


  TBB_init::TBB_init()
  {
    int rc = pthread_once( &TBB_InstanceMutex_once, TBB::Initialization );
    if (rc != 0) { perror("TBB_init::TBB_init once Initialization failed"); exit(1); }
  }


  void TBB::Initialization()
  {
    pthread_mutexattr_t attr;
    pthread_mutexattr_init( &attr );
    //pthread_mutexattr_settype( &attr, PTHREAD_MUTEX_NORMAL );
    pthread_mutexattr_settype( &attr, PTHREAD_MUTEX_ERRORCHECK );
    //pthread_mutexattr_settype( &attr, PTHREAD_MUTEX_RECURSIVE );
    int rc = pthread_mutex_init( &TBB_InstanceMutex_, &attr );
    if (rc != 0) { perror("TBB::Initialization mutex initialization failed"); exit(1); }
    TBB_P_instance_ = new TBB;
#ifdef HAVE_TBB
    UnsignedLong nbThreads = Base::Common::ResourceMap::GetAsUnsignedLong( "parallel-threads" );
    TBB_P_scheduler_ = new tbb::task_scheduler_init( nbThreads );
#endif /* HAVE_TBB */
    // std::atexit( TBB::Release );
  }


  void TBB::Release()
  {
    delete TBB_P_instance_;
    TBB_P_instance_ = 0;
#ifdef HAVE_TBB
    delete TBB_P_scheduler_;
    TBB_P_scheduler_ = 0;
#endif /* HAVE_TBB */
  }


} // end namespace OpenTURNS
