//                                               -*- C++ -*-
/**
 *  @file  LeastSquaresMetaModelSelection.hxx
 *  @brief Basis selection algorithm
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2010-11-09 13:44:00 +0100 (Tue, 09 Nov 2010) $
 *  Id:      $Id: LeastSquaresMetaModelSelection.hxx 1649 2010-11-09 12:44:00Z schueller $
 */
#ifndef OPENTURNS_LEASTSQUARESMETAMODELSELECTION_HXX
#define OPENTURNS_LEASTSQUARESMETAMODELSELECTION_HXX

#include "ApproximationAlgorithmImplementation.hxx"
#include "FittingAlgorithm.hxx"
#include "BasisSequenceFactory.hxx"
#include "CorrectedLeaveOneOut.hxx"
#include "LAR.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Algo {

      /**
       * @class LeastSquaresMetaModelSelection
       *
       * Basis selection algorithm
       */
      class LeastSquaresMetaModelSelection
        : public ApproximationAlgorithmImplementation
      {
        CLASSNAME;

      public:

        typedef Base::Type::NumericalPoint       NumericalPoint;
        typedef Base::Stat::NumericalSample      NumericalSample;
        typedef Base::Func::Basis                Basis;
        typedef Base::Func::BasisSequenceFactory BasisSequenceFactory;
        typedef Base::Func::LAR                  LAR;
        typedef Base::Common::StorageManager     StorageManager;
        typedef Base::Algo::FittingAlgorithm     FittingAlgorithm;

        /** Default constructor */
        LeastSquaresMetaModelSelection(const NumericalSample & x,
                                       const NumericalSample & y,
                                       const Basis & psi,
                                       const BasisSequenceFactory & basisSequenceFactory = LAR(),
                                       const FittingAlgorithm & fittingAlgorithm = CorrectedLeaveOneOut());

        /** Default constructor */
        LeastSquaresMetaModelSelection(const NumericalSample & x,
                                       const NumericalSample & y,
                                       const NumericalPoint & weight,
                                       const Basis & psi,
                                       const BasisSequenceFactory & basisSequenceFactory = LAR(),
                                       const FittingAlgorithm & fittingAlgorithm = CorrectedLeaveOneOut());

        /** Virtual constructor */
        virtual LeastSquaresMetaModelSelection * clone() const;

        /** String converter */
        virtual String __repr__() const;

        /** BasisSequenceFactory accessor */
        void setBasisSequenceFactory(const BasisSequenceFactory & basisSequenceFactory);
        BasisSequenceFactory getBasisSequenceFactory() const;

        /** FittingAlgorithm accessor */
        void setFittingAlgorithm(const FittingAlgorithm & fittingAlgorithm);
        FittingAlgorithm getFittingAlgorithm() const;

        /** Perform the selection */
        virtual void run();

        /** Method save() stores the object through the StorageManager */
        virtual void save(StorageManager::Advocate & adv) const;

        /** Method load() reloads the object from the StorageManager */
        virtual void load(StorageManager::Advocate & adv);

     protected:
       friend class Base::Common::Factory<LeastSquaresMetaModelSelection>;

       /** Default constructor */
       LeastSquaresMetaModelSelection();

       /** Algorithm that builds the BasisSequence */
       BasisSequenceFactory basisSequenceFactory_;

       /** Basis selection algorithm */
       FittingAlgorithm fittingAlgorithm_;


     }; /* class LeastSquaresMetaModelSelection */

    } /* namespace Algo */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_LEASTSQUARESMETAMODELSELECTION_HXX */
