//                                               -*- C++ -*-
/**
 *  @file  Lasso.hxx
 *  @brief L1-regularized least-squares regression
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2010-11-09 13:44:00 +0100 (Tue, 09 Nov 2010) $
 *  Id:      $Id: Lasso.hxx 1649 2010-11-09 12:44:00Z dutka $
 */
#ifndef OPENTURNS_LASSO_HXX
#define OPENTURNS_LASSO_HXX

#include "ApproximationAlgorithmImplementation.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Algo {

      /**
       * @class Lasso
       *
       * L1-regularized least-squares regression
       */
      class Lasso
        : public ApproximationAlgorithmImplementation
      {
        CLASSNAME;

      public:

        typedef Type::NumericalPoint   NumericalPoint;
        typedef Stat::NumericalSample  NumericalSample;
        typedef Func::Basis            Basis;
        typedef Common::StorageManager StorageManager;

        /** Default constructor */
        Lasso(const NumericalSample & x,
              const NumericalSample & y,
              const Basis & psi);

        /** Default constructor */
        Lasso(const NumericalSample & x,
              const NumericalSample & y,
              const NumericalPoint & weight,
              const Basis & psi);

        /** Virtual constructor */
        virtual Lasso * clone() const;

        /** String converter */
        virtual String __repr__() const;

        /** Perform approximation */
        virtual void run();

        /** Method save() stores the object through the StorageManager */
        virtual void save(StorageManager::Advocate & adv) const;

        /** Method load() reloads the object from the StorageManager */
        void load(StorageManager::Advocate & adv);

      }; /* class Lasso */



    } /* namespace Algo */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_LASSO_HXX */
