//                                               -*- C++ -*-
/**
 *  @file  t_Graph_export.cxx
 *  @brief The test file of Graph class for EDF case number 1
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: t_Graph_export.cxx 1473 2010-02-04 15:44:49Z dutka $
 */
#include <iostream>
#include <cmath>

#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "NumericalPoint.hxx"
#include "NumericalSample.hxx"
#include "Graph.hxx"
#include "Curve.hxx"


using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Stat;
using namespace OT::Base::Graph;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try {
    UnsignedLong maxPoint(101);
    NumericalScalar xMin(-2.0 * M_PI);
    NumericalScalar xMax(2.0 * M_PI);
    NumericalSample data(maxPoint, 2);
    for (UnsignedLong i = 0; i < maxPoint; ++i)
      {
	NumericalScalar x(xMin + (xMax - xMin) * i / (maxPoint - 1.0));
	data[i][0] = x;
	data[i][1] = sin(x);
      }
    Graph sinGraph("Sin function", "x", "y", true, "topright");
    sinGraph.addDrawable(Curve(data, "red", "solid", 2, "sin"));
    // Test export to all formats
    sinGraph.draw("sinGraph_ALL", 640, 480, GraphImplementation::ALL);
    fullprint << "sinGraph (ALL)=" << sinGraph.getBitmap() << ", " << sinGraph.getPostscript() << ", " << sinGraph.getVectorial() << std::endl;
    // Test export to PNG format
    sinGraph.draw("sinGraph_PNG", 640, 480, GraphImplementation::PNG);
    fullprint << "sinGraph (PNG)=" << sinGraph.getBitmap() << std::endl;
    // Test export to EPS format
    sinGraph.draw("sinGraph_EPS", 640, 480, GraphImplementation::EPS);
    fullprint << "sinGraph (EPS)=" << sinGraph.getPostscript() << std::endl;
    // Test export to FIG format
    sinGraph.draw("sinGraph_FIG", 640, 480, GraphImplementation::FIG);
    fullprint << "sinGraph (FIG)=" << sinGraph.getVectorial() << std::endl;
  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
