//                                               -*- C++ -*-
/**
 *  @file  OrthonormalizationAlgorithmImplementation.hxx
 *  @brief Top level class for the orthonormalization algorithms
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-09-14 14:39:35 +0200 (lun. 14 sept. 2009) $
 *  Id:      $Id: OrthonormalizationAlgorithmImplementation.hxx 1331 2009-09-14 12:39:35Z dutka $
 */
#ifndef OPENTURNS_ORTHONORMALIZATIONALGORITHMIMPLEMENTATION_HXX
#define OPENTURNS_ORTHONORMALIZATIONALGORITHMIMPLEMENTATION_HXX

#include "PersistentObject.hxx"
#include "Distribution.hxx"
#include "OrthogonalUniVariatePolynomial.hxx" // for the definition of Coefficients

namespace OpenTURNS
{

  namespace Uncertainty
  {

    namespace Algorithm
    {

      /**
       * @class OrthonormalizationAlgorithmImplementation
       */

      class OrthonormalizationAlgorithmImplementation
        : public Base::Common::PersistentObject
      {
        CLASSNAME;
      public:

        typedef Model::Distribution                          Distribution;
	typedef OrthogonalUniVariatePolynomial::Coefficients Coefficients;

        /** Default constructor with Brent solver */
        explicit OrthonormalizationAlgorithmImplementation();

        /** Constructor with parameters */
        OrthonormalizationAlgorithmImplementation(const Distribution & measure);

        /** Virtual constructor */
        virtual OrthonormalizationAlgorithmImplementation * clone() const;

        /** Calculate the coefficients of recurrence a0, a1, a2 such that
            Pn(x) = (a0 * x + a1) * Pn-1(x) + a2 * Pn-2(x) */
        virtual Coefficients getRecurrenceCoefficients(const UnsignedLong n) const;

        /** String converter */
        virtual String __repr__() const;

	/** Measure accessor */
	Distribution getMeasure() const;
	void setMeasure(const Distribution & measure);

      protected:

        Distribution measure_;

      private:

      } ; /* class OrthonormalizationAlgorithmImplementation */

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_ORTHONORMALIZATIONALGORITHMIMPLEMENTATION_HXX */
