'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_207_.inc,v $
'*
'*  $Revision: 1.5 $
'*
'*  last change: $Author: hde $ $Date: 2007/10/16 04:34:14 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : Testing Number and Bullets
'*
'\***********************************************************************

sub w_207_

    Call tToolsNumbering12
    Call tToolsNumbering13


end sub


testcase tToolsNumbering12
    printlog "Import / Export Regression Test"
    '/// Import / Export Regression-Test    
    Dim DocFileList( 30 ) as String, sCurrentFilter as string
    Dim sSourcePath as String, sCurrentFilterExt as string
    Dim i, j, k, x as Integer, ExportFileName as string

    For j = 1 to 2
        ReDim DocFileList( 30 ) as String    
        Select Case j
            Case 1
                '/// load all documents from  "sun_writer\\level1\\input\\number\\"
                sSourcePath = ConvertPath ( gTesttoolPath + "sun_writer\level1\input\number\" )
                GetFileList ( sSourcePath, "*.*", DocFileList() )
            Case 2
                '/// load all documents from  "sun_writer\\level1\\input\\number\\"
                sSourcePath = ConvertPath ( gTesttoolPath + "writer\level1\input\number\regression\" )
                GetFileList ( sSourcePath, "*.*", DocFileList() )
        end select

        x = ListCount ( DocFileList() )
        for i = 1 to x
            printlog " - (" & i & "/" & x & "): " & DocFileList(i)
			For k = 1 to 3
				Select Case k
					Case 3
						sCurrentFilter = "StarWriter 5.0 (.sdw)"
						sCurrentFilterExt = "sdw"
					Case 2
						sCurrentFilter = hGetUIFiltername("StarOffice XML (Writer)") & " (.sxw)"
						sCurrentFilterExt = "sxw"
					Case 1
						sCurrentFilterExt = WriterFilterExtension(0)    
						sCurrentFilter = gWriterFilter
				end select

				'/// Open a new writer document
				Call hNewDocument
				'/// open file
				sleep 2
				Call hDateiOeffnen ( DocFileList(i) )            
				
				Kontext "Filterauswahl"
				if Filterauswahl.Exists then
					Warnlog "  - Filter Selection dialog is up !"
					Filterauswahl.Cancel
					Call hCloseDocument
				endif
				Sleep 5
				Kontext "AsciiFilterOptionen"
				if AsciiFilterOptionen.Exists then AsciiFilterOptionen.Ok            
				sleep (5)        
				' Check for macro alert
				Kontext "SecurityWarning"
				if SecurityWarning.Exists then
					SecurityWarning.Cancel
				endif
	
				'/// check if loaded
				if GetDocumentCount >= 1 then
					ExportFileName = ConvertPath ( gOfficePath + "user\work\" + DateiOhneExt(DateiExtract ( DocFileList(i)  ) ) &  "." & sCurrentFilterExt )
					printlog "  - export as: " & ExportFileName
					Call hSpeichernUnterMitFilterKill ( ExportFileName, sCurrentFilter )
					Sleep (2)				
					Call hCloseDocument
					printlog "  - load previous saved document"
					Call hDateiOeffnen ( ExportFileName )
					Sleep (2)
					printlog "  - close document"
					Call hCloseDocument
				else
                	Warnlog "  - Doc probably didn't get loaded !!!"
				end if
			next k				
            Sleep 2
        next i
    next j
    
endcase


testcase tToolsNumbering13
    
    Dim i as integer, iCounter as integer
    '/// #i73790 Regression testing 
    '/// This testcase loads a Worddocument that lost all formattings 
    printlog "#i73790 regression testing"
    '/// Load document 'writer\\level1\\input\\number\\regression\\73790.doc'
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\number\regression\73790.doc" )
    '/// Document has Heading1-Heading3 formatted, be sure it is
    Call wDokSchreiben ("<Mod1 Home>")
    '/// Point cursor to top of document with <STRG HOME>
    Select Case iSprache
		case 01 : iCounter = 2
		case 03 : iCounter = 1
		case 07 : iCounter = 2
		case 31 : iCounter = 1
		case 33 : iCounter = 3
		case 34 : iCounter = 2
		case 36 : iCounter = 2
		case 39 : iCounter = 2
		case 45 : iCounter = 1
		case 46 : iCounter = 2
		case 48 : iCounter = 2
		case 49 : iCounter = 3
		case 55 : iCounter = 3
		case 81 : iCounter = 3
		case 82 : iCounter = 1
		case 86 : iCounter = 1
		case 88 : iCounter = 3
		case else : iCounter = 2
	end select
	For i = 1 to 3
        Call wDokSchreiben ("<Shift End>")
        '/// Select first to third entry and check it i formatted with 'Heading1','Heading2','Heading3'
        Kontext "Textobjectbar"
        if Vorlage.GetSelIndex <> ( i + iCounter ) then
            Warnlog "Heading " & i & " not " & ( i + iCounter ) & " but " & Vorlage.GetSelIndex
        endif
        Call wDokSchreiben ( "<Home>" )
        Call wDokSchreiben ( "<Down>" )
    next i
    
    Call hCloseDocument

endcase
