'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: c_getpivotdata.inc,v $
'*
'*  $Revision: 1.1 $
'*
'*  last change: $Author: oc $ $Date: 2007/07/26 13:29:40 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/***********************************************************************
'*
'* owner : oliver.craemer@sun.com
'*
'* short description : level 2 test for the getpivotdata function
'*
'************************************************************************
'*
' #1 tgetpivotdata_function_wizard     ' Testcase for manually input of the function
' #1 tgetpivotdata_xls_filter     ' Testcase for import/export of the function
'*
'\***********************************************************************

testcase tgetpivotdata_function_wizard

    dim stestdocument as string
    dim slocalfile as string
    dim sfunctionstring as string
    dim sfunctionname as string
    dim sfunctionwithparameter as string
    
    stestdocument = Convertpath (gTesttoolPath + "spreadsheet\level2\input\datapilot.ods" )
    slocalfile = Convertpath ( gOfficePath + "user\work\datapilot.ods" )
    setclipboard = ""
    
    '/// Get localised string for function GETPIVOTDATA by fFunctionname
    printlog "Get localised string for function GETPIVOTDATA by fFunctionname" 
    sfunctionname = fFunctionname("GETPIVOTDATA")
        
    '/// Load testdocument <i>gTestToolPath</i>/spreadsheet/level2/input/datapilot.ods
    printlog "Load testdocument datapilot.ods"
    call hDateiOeffnen ( stestdocument )
    sleep (2)
    '/// If the file is not editable, click the edit button on standardbar
    printlog "If the file is not editable, click the edit button on standardbar"
    sMakeReadOnlyDocumentEditable()
        
    '/// Select cell I8 and open function wizard by INSERT FUNCTION
    printlog "Select cell I8 and open function wizard by INSERT FUNCTION"
    call fGotoCell ( "I8" )
    InsertFunction
    kontext ( "FunktionsAutoPilot" )
    '/// Select category SPREADSHEET (11th category in listbox)
    printlog "Select category SPREADSHEET (11th category in listbox)"
    Kategorie.select 11
    '/// Select the function GETPIVOTDATA in the now filtered function list
    printlog "Select the function GETPIVOTDATA in the now filtered function list"
    try 
        Funktion.select sfunctionname
        printlog "  Function " & sfunctionname & " selected in category SPREADSHEET"
    catch
        warnlog "The function is not available under category SPREADSHEET"
    endcatch
    Kategorie.select 2
    try
        Funktion.select sfunctionname
    catch
        warnlog "The function is generally not available"
        FunktionsAutoPilot.OK
        call hCloseDocument
        goto endsub
    endcatch
    '/// Press NEXT button
    printlog "Press NEXT button"
    weiter.click
    '/// Enter 2000 for parameter Data Field
    printlog "Enter 2000 for parameter Data Field"
    kontext "FunktionsAutoPilot"
    Editfeld1.settext "2000"
    '/// Enter C29 for parameter DataPilot
    printlog "Enter C29 for parameter DataPilot"
    Editfeld2.settext "C29"
    '/// Enter C3 for parameter Field Name / Item 1
    printlog "Enter C3 for parameter Field Name / Item 1"
    Editfeld3.settext "C3"
    '/// Enter C16 for parameter Field Name / Item 2
    printlog "Enter C16 for parameter Field Name / Item 2"
    Editfeld4.settext "C16"
    '/// Scroll down to enable the next field
    printlog "Scroll down to enable the next field"
    Editfeld4.TypeKeys "<DOWN>"
    '/// Enter C26 for parameter Field Name / Item 3
    printlog "Enter C26 for parameter Field Name / Item 3"
    Editfeld4.settext "C26"
    '/// Scroll down to enable the next field
    printlog "Scroll down to enable the next field"
    Editfeld4.TypeKeys "<DOWN>"
    '/// Enter F27 for parameter Field Name / Item 4
    printlog "Enter F27 for parameter Field Name / Item 4"
    Editfeld4.settext "F27"
    '/// Close functionwizard by pressing OK button
    printlog "Close functionwizard by pressing OK button"
    FunktionsAutoPilot.OK
    '/// Memorize cellcontent
    kontext ( "RechenleisteCalc" ) 
    EingabeZeileCalc.TypeKeys ("<f2><mod1 a>")
    editcopy
    sfunctionwithparameter = GetClipboardText ()
    '/// Press twice <ESCAPE> to leave the cell
    printlog "Press twice <ESCAPE> to leave the cell"
    kontext ( "DocumentCalc" )
    DocumentCalc.TypeKeys "<ESCAPE>" , 2
    '/// Verify that the function result is 100000
    printlog "Verify that the function result is 100000"
    call fCalcCompareCellValue ( "I8",100000 )
    '/// Save the document again
    printlog "Save the document again"
    if NOT hSpeichernUnterKill (slocalfile) then
        warnlog "Saving test document localy failed -> Aborting"
        call hCloseDocument
        goto endsub
    else
        printlog "  File saved successfully."
    endif    
    '/// Close the file with File/close
    printlog "Close the file with File/close"
    call hCloseDocument
    sleep(3)
    '/// Load localy saved document
    printlog "Load localy saved document"
    call hDateiOeffnen ( slocalfile )
    '/// Verify that cell I8 still shows 100000
    printlog "Verify that cell I8 still shows 100000"
    call fCalcCompareCellValue ( "I8",100000 )
    '/// Verify that the function in cell I8 is still =GETPIVOTDATA("2000";C29;C3;C16;C26;F27)
    printlog "Verify that the function in cell I8 is still " & sfunctionwithparameter
    kontext ( "RechenleisteCalc" ) 
    EingabeZeileCalc.TypeKeys ("<f2><mod1 a>")
    editcopy
    if GetClipboardText () = sfunctionwithparameter then
        printlog "  The function was successfully saved and reloaded"
    else warnlog "The function is not " & sfunctionwithparameter & ", it is " & GetClipboardText ()
    endif
    '/// Press twice <ESCAPE> to leave the cell
    printlog "Press twice <ESCAPE> to leave the chart object"
    kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<ESCAPE>" , 2
    '/// Close document
    printlog "Close document"
    call hCloseDocument
    sleep(3)
'///
endcase
'
'---------------------------------------------------------------------------
'
testcase tgetpivotdata_xls_filter

    dim stestdocument as string
    dim slocalfile as string
    dim sfunctionparameter as string
    dim sfunctionname as string
    dim sfunctionwithparameter as string
    dim sdecimalseperator as string
    
    stestdocument = Convertpath (gTesttoolPath + "spreadsheet\level2\input\getpivotdata2.xls" )
    'stestdocument = Convertpath ( gOfficePath + "user\work\test.ods" )
    slocalfile = Convertpath ( gOfficePath + "user\work\getpivotdata2.xls" )
    sdecimalseperator = GetDecimalSeperator
    setclipboard = ""
    sfunctionname = fFunctionname("GETPIVOTDATA")
    
    '/// Load testdocument <i>gTestToolPath</i>/spreadsheet/level2/input/getpivotdata2.xls
    printlog "Load testdocument getpivotdata2.xls"
    call hDateiOeffnen ( stestdocument )
    sleep (2)
    '/// If the file is not editable, click the edit button on standardbar
    printlog "If the file is not editable, click the edit button on standardbar"
    call sMakeReadOnlyDocumentEditable    
    '/// Verify that Cell G12 shows 2.5
    printlog "Verify that Cell G12 shows 2" & sdecimalseperator & "5"
    call fCalcCompareCellValue ("G12","2" & sdecimalseperator & "5")
    '/// Verify that the function is =GETPIVOTDATA("val";$F$5;"col1";"a";"col2";"x")
    printlog "Verify that the function is =GETPIVOTDATA(""val"";$F$5;""col1"";""a"";""col2"";""x"")"
    kontext ( "RechenleisteCalc" ) 
    EingabeZeileCalc.TypeKeys ("<f2><mod1 a>")
    editcopy
    sfunctionwithparameter = GetClipboardText ()
    '/// Press twice <ESCAPE> to leave the cell
    'printlog "Press twice <ESCAPE> to leave the cell"
    kontext ( "DocumentCalc" )
    DocumentCalc.TypeKeys "<ESCAPE>" , 2
    if sfunctionwithparameter = "=" & sfunctionname & "(""val"";$F$5;""col1"";""a"";""col2"";""x"")" then
        printlog "  The function is correct"
    else
        warnlog "The function is " & sfunctionwithparameter & " instead of =GETPIVOTDATA(""val"";$F$5;""col1"";""a"";""col2"";""x"")"
    endif

    '/// Verify that Cell G27 shows 0.05
    printlog "Verify that Cell G27 shows 0" & sdecimalseperator & "05"
    call fCalcCompareCellValue ("G27","0" & sdecimalseperator & "05")
    '/// Verify that the function is =GETPIVOTDATA("val";$F$19;"col1";"a";"col2";"y")
    printlog "Verify that the function is =GETPIVOTDATA(""val"";$F$19;""col1"";""a"";""col2"";""y"")"
    kontext ( "RechenleisteCalc" ) 
    EingabeZeileCalc.TypeKeys ("<f2><mod1 a>")
    editcopy
    sfunctionwithparameter = GetClipboardText ()
    '/// Press twice <ESCAPE> to leave the cell
    'printlog "Press twice <ESCAPE> to leave the cell"
    kontext ( "DocumentCalc" )
    DocumentCalc.TypeKeys "<ESCAPE>" , 2
    if sfunctionwithparameter = "=" & sfunctionname & "(""val"";$F$19;""col1"";""a"";""col2"";""y"")" then
        printlog "  The function is correct"
    else
        warnlog "The function is " & sfunctionwithparameter & " instead of =GETPIVOTDATA(""val"";$F$19;""col1"";""a"";""col2"";""y"")"
    endif
    
    '/// Verify that Cell G43 shows 3
    printlog "Verify that Cell G43 shows 3"
    call fCalcCompareCellValue ("G43","3")
    '/// Verify that the function is =GETPIVOTDATA("val";$F$33;"col1";"a";"col2";"z";"col3";"p"))
    printlog "Verify that the function is =GETPIVOTDATA(""val"";$F$33;""col1"";""a"";""col2"";""z"";""col3"";""p"")"
    kontext ( "RechenleisteCalc" ) 
    EingabeZeileCalc.TypeKeys ("<f2><mod1 a>")
    editcopy
    sfunctionwithparameter = GetClipboardText ()
    '/// Press twice <ESCAPE> to leave the cell
    'printlog "Press twice <ESCAPE> to leave the cell"
    kontext ( "DocumentCalc" )
    DocumentCalc.TypeKeys "<ESCAPE>" , 2
    if sfunctionwithparameter = "=" & sfunctionname & "(""val"";$F$33;""col1"";""a"";""col2"";""z"";""col3"";""p"")" then
        printlog "  The function is correct"
    else
        warnlog "The function is " & sfunctionwithparameter & " instead of =GETPIVOTDATA(""val"";$F$33;""col1"";""a"";""col2"";""z"";""col3"";""p"")"
    endif
    
    '/// Save document back to xls locally
    printlog "Save document back to xls locally"
    call hSpeichernUnterKill ( slocalfile )
    
    '/// Close document
    printlog "Close document"
    call hCloseDocument

    '/// Load Document
    printlog "Load Document"
    call hDateiOeffnen ( slocalfile )
    sleep (2)
    
'/// Verify that Cell G12 shows 2.5
    printlog "Verify that Cell G12 shows 2" & sdecimalseperator & "5"
    call fCalcCompareCellValue ("G12","2" & sdecimalseperator & "5")
    '/// Verify that the function is =GETPIVOTDATA("val";$F$5;"col1";"a";"col2";"x")
    printlog "Verify that the function is =GETPIVOTDATA(""val"";$F$5;""col1"";""a"";""col2"";""x"")"
    kontext ( "RechenleisteCalc" ) 
    EingabeZeileCalc.TypeKeys ("<f2><mod1 a>")
    editcopy
    sfunctionwithparameter = GetClipboardText ()
    '/// Press twice <ESCAPE> to leave the cell
    'printlog " Press twice <ESCAPE> to leave the cell"
    kontext ( "DocumentCalc" )
    DocumentCalc.TypeKeys "<ESCAPE>" , 2
    if sfunctionwithparameter = "=" & sfunctionname & "(""val"";$F$5;""col1"";""a"";""col2"";""x"")" then
        printlog "  The function is correct"
    else
        warnlog "The function is " & sfunctionwithparameter & " instead of =GETPIVOTDATA(""val"";$F$5;""col1"";""a"";""col2"";""x"")"
    endif

    '/// Verify that Cell G27 shows 0.05
    printlog "Verify that Cell G27 shows 0" & sdecimalseperator & "05"
    call fCalcCompareCellValue ("G27","0" & sdecimalseperator & "05")
    '/// Verify that the function is =GETPIVOTDATA("val";$F$19;"col1";"a";"col2";"y")
    printlog "Verify that the function is =GETPIVOTDATA(""val"";$F$19;""col1"";""a"";""col2"";""y"")"
    kontext ( "RechenleisteCalc" ) 
    EingabeZeileCalc.TypeKeys ("<f2><mod1 a>")
    editcopy
    sfunctionwithparameter = GetClipboardText ()
    '/// Press twice <ESCAPE> to leave the cell
    'printlog " Press twice <ESCAPE> to leave the cell"
    kontext ( "DocumentCalc" )
    DocumentCalc.TypeKeys "<ESCAPE>" , 2
    if sfunctionwithparameter = "=" & sfunctionname & "(""val"";$F$19;""col1"";""a"";""col2"";""y"")" then
        printlog "  The function is correct"
    else
        warnlog "The function is " & sfunctionwithparameter & " instead of =GETPIVOTDATA(""val"";$F$19;""col1"";""a"";""col2"";""y"")"
    endif
    
    '/// Verify that Cell G43 shows 3
    printlog "Verify that Cell G43 shows 3"
    call fCalcCompareCellValue ("G43","3")
    '/// Verify that the function is =GETPIVOTDATA("val";$F$33;"col1";"a";"col2";"z";"col3";"p"))
    printlog "Verify that the function is =GETPIVOTDATA(""val"";$F$33;""col1"";""a"";""col2"";""z"";""col3"";""p"")"
    kontext ( "RechenleisteCalc" ) 
    EingabeZeileCalc.TypeKeys ("<f2><mod1 a>")
    editcopy
    sfunctionwithparameter = GetClipboardText ()
    '/// Press twice <ESCAPE> to leave the cell
    'printlog " Press twice <ESCAPE> to leave the cell"
    kontext ( "DocumentCalc" )
    DocumentCalc.TypeKeys "<ESCAPE>" , 2
    if sfunctionwithparameter = "=" & sfunctionname & "(""val"";$F$33;""col1"";""a"";""col2"";""z"";""col3"";""p"")" then
        printlog "The function is correct"
    else
        warnlog "The function is " & sfunctionwithparameter & " instead of =GETPIVOTDATA(""val"";$F$33;""col1"";""a"";""col2"";""z"";""col3"";""p"")"
    endif
    
    '/// Close document
    printlog "Close document"
    call hCloseDocument
    sleep(3)
endcase
