'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: t_doc1.inc,v $
'*
'*  $Revision: 1.20 $
'*
'*  last change: $Author: jsi $ $Date: 2007/08/24 12:33:40 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : thorsten.bosbach@sun.com
'*
'* short description : Global Routines for Document Handling
'*
'***************************************************************************************
' #1 hCloseAndLooseDocument 'wrn:0|err:0 'Closes a document and accepts the loose of content.
' #1 hOpenFileAndIgnoreMacroWarning
' #1 hCreateLabels
' #1 hCreateBusinessCards
' #1 hNewDocument
' #1 hNeuesDokument
' #1 hCloseDocument
' #1 hCloseAndLooseDocument
' #1 hDokumentSchliessen
' #1 gMouseClick
' #1 gMouseDoubleClick
' #1 gMouseMove
' #1 gMouseDown
' #1 gMouseMove2
' #1 gMouseUp
' #1 hTypeKeys
'\*************************************************************************************

sub hNewDocument ( optional bANewDoc )
'/// hNewDocument : open a new document dependent on 'gApplication' ///'
   dim sTemp as string
   gApplication = Ucase ( gApplication )

   if IsMissing ( bANewDoc ) <> TRUE then
      if bANewDoc = TRUE then
         gNoNewDoc = FALSE
      else
         gNoNewDoc = TRUE
      end if
   end if

   select case gApplication
      case "WRITER",  "TEXTDOKUMENT"    : Kontext "DocumentWriter"
                                          if gNoNewDoc = TRUE then
                                             FileOpen "FileName", "private:factory/swriter", "SynchronMode", TRUE
                                          else
                                             FileOpen "FileName", "private:factory/swriter", "FrameName", "_default", "SynchronMode", TRUE
                                          end if
      case "CALC", "TABELLENDOKUMENT"   : Kontext "DocumentCalc"
                                          if gNoNewDoc = TRUE then
                                             FileOpen "FileName", "private:factory/scalc", "SynchronMode", TRUE
                                          else
                                             FileOpen "FileName", "private:factory/scalc", "FrameName", "_default", "SynchronMode", TRUE
                                          end if
      case "IMPRESS", "PRAESENTATION"   : Kontext "DocumentImpress"
                                          if gNoNewDoc = TRUE then
                                             FileOpen "FileName", "private:factory/simpress", "SynchronMode", TRUE
                                          else
                                             FileOpen "FileName", "private:factory/simpress", "FrameName", "_default", "SynchronMode", TRUE
                                             Kontext "AutoPilotPraesentation1"
                                             if AutoPilotPraesentation1.Exists (2) then
                                                Printlog "------------------------------The Impress-Autopilot was active------------------"
                                                Startwithwizard.Check             ' opposite of the checkboxs' title
                                                AutoPilotPraesentation1.OK
                                                Sleep 2
                                                Kontext "SeitenLayout"
                                                SeitenLayout.Cancel
                                             end if
                                             Kontext "DocumentImpress"
                                             Sleep 2
                                          end if
      case "DRAW", "ZEICHNUNG"          : Kontext "DocumentDraw"
                                          if gNoNewDoc = TRUE then
                                             FileOpen "FileName", "private:factory/sdraw", "SynchronMode", TRUE
                                          else
                                             FileOpen "FileName", "private:factory/sdraw", "FrameName", "_default", "SynchronMode", TRUE
                                          end if
      case "MASTERDOC", "GLOBALDOKUMENT", "GLOBALDOC" :
                                          Kontext "DocumentMasterDoc"
                                          if gNoNewDoc = TRUE then
                                             FileOpen "FileName", "private:factory/swriter/GlobalDocument", "SynchronMode", TRUE
                                          else
                                             FileOpen "FileName", "private:factory/swriter/GlobalDocument", "FrameName", "_default", "SynchronMode", TRUE
                                          end if
                                          Kontext "Navigator"
                                          sleep (1)
                                          if Navigator.Exists(5) then Navigator.Close
                                          Kontext "DocumentMasterDoc"
      case "MATH", "FORMEL"             : Kontext "DocumentMath"
                                          if gNoNewDoc = TRUE then
                                             FileOpen "FileName", "private:factory/smath", "SynchronMode", TRUE
                                          else
'                                             FileOpen "FileName", "private:factory/smath", "FrameName", "_blank"
                                             FileOpen "FileName", "private:factory/smath", "FrameName", "_default", "SynchronMode", TRUE
                                          end if
                                          Kontext "DocumentMath"
      case "HTML", "HTMLDOKUMENT"       : Kontext "DocumentWriterWeb"
                                          if gNoNewDoc = TRUE then
                                             FileOpen "FileName", "private:factory/swriter/web", "SynchronMode", TRUE
                                          else
                                             FileOpen "FileName", "private:factory/swriter/web", "FrameName", "_default", "SynchronMode", TRUE
                                          end if
                                          Kontext "DocumentWriterWeb"
      case "BASE", "INSIGHT"            : FileOpen "FileName", "private:factory/sdatabase?Interactive", "FrameName", "_default", "SynchronMode", TRUE
                                          Kontext "DatabaseWizard"
                                          if DatabaseWizard.exists(5) then
                                              FinishBtn.click
                                              kontext "SpeichernDlg"
                                              if SpeichernDlg.exists(5) then
                                                  if (Dateiname.getSelText = "") then
                                                      sTemp = convertPath(gOfficePath + "user/work/hNewDocument.odb")
                                                      if fileExists(sTemp) then
                                                          app.kill(sTemp)
                                                      endif
                                                      qaErrorlog "## lost default filename"
                                                      Dateiname.setText "hNewDocument"
                                                  endif
                                                  Speichern.click
                                                  Kontext "Insight"
                                              else
                                                  warnlog "t_doc1.inc::hNewDocument():: Can't create Database Document 2"
                                              endif
                                          else
                                              warnlog "t_doc1.inc::hNewDocument():: Can't create Database Document 1"
                                          endif
      case "BASIC"                      : ToolsMacroMacro
                                          kontext "makro"
					  if makro.exists(5) then
                                              MakroAus.typeKeys "<home>"
                                              sTemp = ""
                                              while (NOT bearbeiten.isEnabled) AND (sTemp <> MakroAus.getSelText)
                                                  sTemp = MakroAus.getSelText
                                                  MakroAus.typeKeys "<down>+"
                                              wend
                                              if (bearbeiten.isEnabled) then
                                                  bearbeiten.click
                                              else
                                                  qaErrorlog "Can't edit document."
                                              endif
                                          else
					      warnlog "Can't open Basic IDE."
					  endif
     case else             : WarnLog "hNewDocument: No Applikation named '" + gApplication + "' exists in this routine!"
   end select
   Sleep 2
end sub

sub hNeuesDokument ( optional bv )
'///  DEPRACTED: hNeuesDokument == hNewDocument ///'
      Call hNewDocument ( bv )
end sub

function hCreateLabels() as Boolean
'/// hCreateLabels : open the tab-dialog for making a new lable (file/new/lable) ///'
    FileOpen "FileName", "private:factory/swriter?slot=21051", "FrameName", "_default", "SynchronMode", TRUE
    Sleep (2)
   Kontext
    Active.Setpage TabEtiketten
    Kontext "TabEtiketten"
   if Not TabEtiketten.Exists then
    Warnlog "Dialog for Labels is not up!"
    hCreateLabels = False
   else
    hCreateLabels = True
   endif
   Sleep (2)
end function

function hCreateBusinessCards() as Boolean
'/// hCreateBusinessCards : open the tab-dialog for making a new business card (file/new/business cards) ///'
   FileOpen "FileName", "private:factory/swriter?slot=21052", "FrameName", "_default", "SynchronMode", TRUE   
   Sleep (2)
   Kontext
    Active.Setpage TabEtikettenMedium
    Kontext "TabEtikettenMedium"
   if Not TabEtikettenMedium.Exists then
    Warnlog "Dialog for BusinessCards is not up!"
    hCreateBusinessCards = False
   else
    hCreateBusinessCards = True
   endif
   Sleep (2)
end function

sub hCloseDocument ( optional bANewDoc )
'/// hCloseDocument : close a document without saving ///'
'///+ all documents will be closed without saving ///'
   Dim sFehler$

   if IsMissing ( bANewDoc ) <> TRUE then
      if bANewDoc = TRUE then
         gNoNewDoc = FALSE
      else
         gNoNewDoc = TRUE
      end if
   end if

   ' if no new document was created, it isn't closed
   if gNoNewDoc = TRUE then
      exit sub        
   end if

   Sleep 3
   try
      FileClose
   catch
      Exceptlog
      exit sub
   endcatch

   Sleep 1
   Kontext "Active"
   if Active.Exists(2) then
      try
         Active.No
      catch
         Active.Click ( 202 )
      endcatch
   end if
   Sleep (2)
end sub

sub hCloseAndLooseDocument
'/// <i>hCloseAndLooseDocument</i>
'///+ Closes a (modified) document and the verify dialog will be answered
'///+ with yes. That means you want to loose format information or you want
'///+ to loose the document!
   Dim sFehler$

   try
      FileClose
    catch
      Exceptlog
      exit sub
   endcatch
   sleep (2)
   Kontext
   if Active.Exists(2) then Active.Yes
end sub

sub hDokumentSchliessen ( optional bv )
'/// DEPRACTED: hDokumentSchliessen == hCloseDocument ///'
      Call hCloseDocument ( bv )
end sub

sub gMouseClick ( X%, Y%, optional mb% )
    '/// gMouseClick ( x_Position, y-Position ) : make a mouseclick on the document (dependent on 'gApplication') ///'
    '/// default left mousebutton will be used otherwise you can optionally give the mousebutton to press
    '/// 1 = left mouse button
    '/// 2 = left mouse button
    '/// 3 = left mouse button

    gApplication = UCase ( gApplication )

    if IsMissing(mb%) then mb% = 1
        
   select case gApplication
      case "DESKTOP" :
              Kontext "Desktop"
              autoexecute = false
              Desktop.MouseDown ( X%, Y%, mb% )
              Desktop.MouseUp ( X%, Y%, mb% )
              autoexecute = true
      case "CALC" :
              Kontext "DocumentCalc"
              autoexecute = false
              DocumentCalc.MouseDown ( X%, Y%, mb% )
              DocumentCalc.MouseUp ( X%, Y%, mb% )
              autoexecute = true
      case "DRAW" :
              Kontext "DocumentDraw"
              autoexecute=false
              DocumentDraw.MouseDown ( X%, Y%, mb% )
              DocumentDraw.MouseUp ( X%, Y%, mb% )
              autoexecute=true
      case "WRITER" :
              Kontext "DocumentWriter"
              autoexecute=false
              DocumentWriter.MouseDown ( X%, Y%, mb% )
              DocumentWriter.MouseUp ( X%, Y%, mb% )
              autoexecute=true
      case "HTMLDOKUMENT" :
              Kontext "DocumentWriterWeb"
              autoexecute=false
              DocumentWriterWeb.MouseDown ( X%, Y%, mb% )
              DocumentWriterWeb.MouseUp ( X%, Y%, mb% )
              autoexecute=true
      case "MASTERDOC" :
              Kontext "DocumentMasterDoc"
              autoexecute=false
              DocumentMasterDoc.MouseDown ( X%, Y%, mb% )
              DocumentMasterDoc.MouseUp ( X%, Y%, mb% )
              autoexecute=true
      case "IMPRESS" :
              Kontext "DocumentImpress"
              autoexecute=false
              DocumentImpress.MouseDown ( X%, Y%, mb% )
              DocumentImpress.MouseUp ( X%, Y%, mb% )
              autoexecute=true
      case "MATH" :
              Kontext "DocumentMath"
              autoexecute=false
              DocumentMath.MouseDown ( X%, Y%, mb% )
              DocumentMath.MouseDown ( X%, Y%, mb% )
              autoexecute=true
      case "CHART" :
              Kontext "DocumentChart"
              autoexecute=false
              DocumentChart.MouseDown ( X%, Y%, mb% )
              DocumentChart.MouseUp ( X%, Y%, mb% )
              autoexecute=true
   end select
   sleep (2)
end sub

sub gMouseDoubleClick ( X%, Y% )
'/// gMouseDoubleClick ( x_Position, y-Position ) : make a mouse-doubleclick on the document ( dependent on 'gApplication' ) ///'
   gApplication = UCase ( gApplication )

   select case gApplication
      case "CALC" :
              Kontext "DocumentCalc"
              DocumentCalc.MouseDoubleClick ( X%, Y% )
      case "DRAW" :
              Kontext "DocumentDraw"
              DocumentDraw.MouseDoubleClick ( X%, Y% )
      case "DESKTOP" :
              Kontext "Desktop"
              Desktop.MouseDoubleClick ( X%, Y% )
      case "WRITER" :
              Kontext "DocumentWriter"
              DocumentWriter.MouseDoubleClick ( X%, Y% )
      case "HTMLDOKUMENT" :
              Kontext "DocumentWriterWeb"
              DocumentWriterWeb.MouseDoubleClick ( X%, Y% )
      case "MASTERDOC" :
              Kontext "DocumentMasterDoc"
              DocumentMasterDoc.MouseDoubleClick ( X%, Y% )
      case "IMPRESS" :
              Kontext "DocumentImpress"
              DocumentImpress.MouseDoubleClick ( X%, Y% )
      case "MATH" :
              Kontext "DocumentMath"
              DocumentMath.MouseDoubleClick ( X%, Y% )
   end select
   Sleep (2)
end sub

sub gMouseMove ( BeginX%, BeginY%, EndX%, EndY% )
'/// gMouseMove ( BeginX, BeginY, EndX, EndY ) : make a mousemove trom Bx,By to Ex,Ey on the document ( dependent on 'gApplication' ) ///'
   gApplication = UCase ( gApplication )

   select case gApplication
      case "CALC" :
              Kontext "DocumentCalc"
              DocumentCalc.MouseDown ( BeginX%, BeginY% )
              DocumentCalc.MouseMove ( EndX%, EndY%)
              DocumentCalc.MouseUp ( EndX%, EndY% )
      case "DRAW" :
              Kontext "DocumentDraw"
              DocumentDraw.MouseDown ( BeginX%, BeginY% )
              DocumentDraw.MouseMove ( EndX%, EndY% )
              DocumentDraw.MouseUp ( EndX%, EndY% )
      case "WRITER" :
              Kontext "DocumentWriter"
              DocumentWriter.MouseDown ( BeginX%, BeginY% )
              DocumentWriter.MouseMove ( EndX%, EndY%)
              DocumentWriter.MouseUp ( EndX%, EndY% )
      case "HTMLDOKUMENT" :
              Kontext "DocumentWriterWeb"
              DocumentWriterWeb.MouseDown ( BeginX%, BeginY% )
              DocumentWriterWeb.MouseMove ( EndX%, EndY%)
              DocumentWriterWeb.MouseUp ( EndX%, EndY% )
      case "MASTERDOC" :
              Kontext "DocumentMasterDoc"
              DocumentMasterDoc.MouseDown ( BeginX%, BeginY% )
              DocumentMasterDoc.MouseMove ( EndX%, EndY%)
              DocumentMasterDoc.MouseUp ( EndX%, EndY% )
      case "IMPRESS" :
              Kontext "DocumentImpress"
              DocumentImpress.MouseDown ( BeginX%, BeginY% )
              DocumentImpress.MouseMove ( EndX%, EndY%)
              DocumentImpress.MouseUp ( EndX%, EndY% )
      case "MATH" :
              Kontext "DocumentMath"
              DocumentMath.MouseDown ( BeginX%, BeginY% )
              DocumentMath.MouseMove ( EndX%, EndY%)
              DocumentMath.MouseDown ( EndX%, EndY% )
   end select
   Sleep (2)
end sub

sub gMouseDown ( BeginX%, BeginY% )
'/// gMouseDown ( x_Position, y-Position ) : make a mousedown on the document (dependent on 'gApplication') ///'
'///+ DON'T FORGETT to call gMouseUp !  ///'
   gApplication = UCase ( gApplication )

   select case gApplication
      case "CALC" :
              Kontext "DocumentCalc"
              DocumentCalc.MouseDown ( BeginX%, BeginY% )
      case "DRAW" :
              Kontext "DocumentDraw"
              DocumentDraw.MouseDown ( BeginX%, BeginY% )
      case "WRITER" :
              Kontext "DocumentWriter"
              DocumentWriter.MouseDown ( BeginX%, BeginY% )
      case "HTMLDOKUMENT" :
              Kontext "DocumentWriterWeb"
              DocumentWriterWeb.MouseDown ( BeginX%, BeginY% )
      case "MASTERDOC" :
              Kontext "DocumentMasterDoc"
              DocumentMasterDoc.MouseDown ( BeginX%, BeginY% )
      case "IMPRESS" :
              Kontext "DocumentImpress"
              DocumentImpress.MouseDown ( BeginX%, BeginY% )
      case "MATH" :
              Kontext "DocumentMath"
              DocumentMath.MouseDown ( BeginX%, BeginY% )
   end select
   Sleep (2)
end sub

sub gMouseMove2 ( EndX%, EndY% )
'/// gMouseMove2 ( x_Position, y-Position ) : move the pointer to position on the document (dependent on 'gApplication') ///'
   gApplication = UCase ( gApplication )

   select case gApplication
      case "CALC" :
              Kontext "DocumentCalc"
              DocumentCalc.MouseMove ( EndX%, EndY%)
      case "DRAW" :
              Kontext "DocumentDraw"
              DocumentDraw.MouseMove ( EndX%, EndY% )
      case "WRITER" :
              Kontext "DocumentWriter"
              DocumentWriter.MouseMove ( EndX%, EndY%)
      case "HTMLDOKUMENT" :
              Kontext "DocumentWriterWeb"
              DocumentWriterWeb.MouseMove ( EndX%, EndY%)
      case "MASTERDOC" :
              Kontext "DocumentMasterDoc"
              DocumentMasterDoc.MouseMove ( EndX%, EndY%)
      case "IMPRESS" :
              Kontext "DocumentImpress"
              DocumentImpress.MouseMove ( EndX%, EndY%)
      case "MATH" :
              Kontext "DocumentMath"
              DocumentMath.MouseMove ( EndX%, EndY%)
   end select
   Sleep (2)
end sub

sub gMouseUp ( EndX%, EndY% )
'/// gMouseUp ( x_Position, y-Position ) : make a release button on the document (dependent on 'gApplication') ///'
   gApplication = UCase ( gApplication )

   select case gApplication
      case "CALC" :
              Kontext "DocumentCalc"
              DocumentCalc.MouseUp ( EndX%, EndY% )
      case "DRAW" :
              Kontext "DocumentDraw"
              DocumentDraw.MouseUp ( EndX%, EndY% )
      case "WRITER" :
              Kontext "DocumentWriter"
              DocumentWriter.MouseUp ( EndX%, EndY% )
      case "HTMLDOKUMENT" :
              Kontext "DocumentWriterWeb"
              DocumentWriterWeb.MouseUp ( EndX%, EndY% )
      case "MASTERDOC" :
              Kontext "DocumentMasterDoc"
              DocumentMasterDoc.MouseUp ( EndX%, EndY% )
      case "IMPRESS" :
              Kontext "DocumentImpress"
              DocumentImpress.MouseUp ( EndX%, EndY% )
      case "MATH" :
              Kontext "DocumentMath"
              DocumentMath.MouseUp ( EndX%, EndY% )
   end select
   Sleep (2)
end sub



sub hTypeKeys ( OutputText , optional iLoop as Integer )
'/// hTypeKeys  ( OutputText , optional iLoop as Integer ): type the keys in 'outputtext' 'iLoop' times ///'
   Dim i as integer
   
   If IsMissing(iLoop) = True then iLoop = 1
   For i = 1 to iLoop
       Select Case Ucase(gApplication)
          Case "WRITER"
            Kontext "DocumentWriter"
            DocumentWriter.TypeKeys OutputText
          Case "MASTERDOC"
            Kontext "DocumentMasterDoc"
            DocumentMasterDoc.TypeKeys OutputText
          Case "HTMLDOKUMENT"
            Kontext "DocumentWriterWeb"
            DocumentWriterWeb.TypeKeys OutputText
          case "CALC" :
            Kontext "DocumentCalc"
            DocumentCalc.TypeKeys OutputText
          case "DRAW"
            Kontext "DocumentDraw"
            DocumentDraw.TypeKeys OutputText
          case "IMPRESS"
            Kontext "DocumentImpress"
            DocumentImpress.TypeKeys OutputText
          case "MATH" :
            Kontext "DocumentMath"
            DocumentMath.TypeKeys OutputText
       end select
       wait 500
   next i
end sub

'-------------------------------------------------------------------------

function hOpenFileAndIgnoreMacroWarning (sDocName as string, optional IgnoreW) as Boolean
'/// Loading a (known) document with macro security warning.
'/// If the OPTIONAL parameter is used a PRINTLOG will be written into the result file otherwise a wrning.
    Dim i as integer

    'ConvertPath: Be sure that the path seperators has been set correctly (/ or \).
    sDocName = ConvertPath(sDocName)
    
    hOpenFileAndIgnoreMacroWarning = FALSE
    
    if hFileExists(sDocName) = FALSE then
        warnlog "global::tools::inc::t_doc1.inc::hOpenFileAndIgnoreMacroWarning: '" & sDocName & "' does not exists!"
        'Setting the function to FALSE because file has not been found.        
        exit function
    else
        FileOpen
        sleep (1)
        Kontext "OeffnenDlg"
        Dateiname.SetText sDocName
        sleep (3)
        Oeffnen.Click
        sleep(2)
        for i = 1 to 2
            ' Since SRC680m?? we have TWO Security Warnings for
            ' StarBasic and JavaScript; So this routine needs to
            ' run twice.
            Kontext "SecurityWarning"
            if SecurityWarning.Exists(2) then
                if IsMissing(IgnoreW) = FALSE then
                    printLog "global::tools::inc::t_doc1.inc::hOpenFileAndIgnoreMacroWarning: Securitywarning dialog is visible."
                else
                    warnlog "global::tools::inc::t_doc1.inc::hOpenFileAndIgnoreMacroWarning: Securitywarning dialog is visible"
                end if
                SecurityWarning.OK
            else
                if i <> 2 then
                    QAErrorLog "global::tools::inc::t_doc1.inc::hOpenFileAndIgnoreMacroWarning: No Security warning dialog occured! Document loading aborted."
                    hOpenFileAndIgnoreMacroWarning = FALSE
                    exit function
                end if
            end if
        next i
        Kontext "OeffnenDlg"
        if OeffnenDlg.Exists(1) then
            OeffnenDlg.Cancel
            warnlog "global::tools::inc::t_doc1.inc::hOpenFileAndIgnoreMacroWarning: The 'FileOpen'-Dialog is open!"
        else
            ' After the external routine IsItLoaded has been run the return value of this function should be set to TRUE.
            if IsItLoaded = TRUE then
                hOpenFileAndIgnoreMacroWarning = TRUE
            end if
        end if
    end if
end function

