'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: slotscfg.inc,v $
'*
'*  $Revision: 1.8 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:08:38 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* Owner : joerg.skottke@sun.com
'*
'* short description :
'*
'********************************************************************
'*
' #1 tSlotsCfg
' #1 tCommandsXML
' #1 tWriteUserShareLayer
'*
'\*******************************************************************

testcase tSlotsCfg
'/// inspiration from BugID: 97712 ///'
'///+ responsible engineer: kay koll ///'

   dim sTemp as string
   dim sTemp2 as string
   dim fCommonXml as string
   dim fCommonUserXml as string
   dim fSlotPath as string
   dim fUserConfig as string
   dim fShareConfig as string
   dim sValue as string
   dim bWriteAccess as boolean
   dim bAdmin as boolean
   dim fTestPath as string
   dim bCrash as boolean

   bAdmin = FALSE

   if gNetzInst then
      fCommonXml  = ConvertPath (gNetzOfficePath + "share\registry\data\org\openoffice\Office\Common.xcu")
      fUserConfig = ConvertPath (gNetzOfficePath + "share/config/slots.cfg")
      fTestPath   = ConvertPath (gNetzOfficePath + "share\registry\data\org\openoffice\Office\")
   else
      fCommonXml  = ConvertPath (gOfficePath + "share\registry\data\org\openoffice\Office\Common.xcu")
      fUserConfig = ConvertPath (gOfficePath + "share/config/slots.cfg")
      fTestPath   = ConvertPath (gOfficePath + "share\registry\data\org\openoffice\Office\")
   endif
   fSlotPath    = ConvertPath (gTestToolPath + "framework/level2/slotscfg/input/")
   fShareConfig = ConvertPath (gOfficePath + "user/config/slots.cfg")
   fCommonUserXml=ConvertPath (gOfficePath + "user\registry\data\org\openoffice\Office\Common.xcu")

   if (fisPathWritable(fTestPath) <> TRUE) then
      warnlog "test needs more access rights; change it and run again!"
      goto endsub
   endif

Printlog ("'///  define function_a as File->Open FileOpen Open SID_OPENDOC 5501 ///'")
Printlog ("'///+ define function_b as Edit->SearchAndReplace EditSearchAndReplace SearchDialog SID_SEARCH_DLG 5961 ///'")

'/// start office -> no aktive available! ///'
'///+ .. check if function a and b are available! ///'
   printlog ""
   Printlog ("0. Check Presuppositions, if we have default values")
   if function_A then
      Printlog "     function_A available :-)"
   else
      warnlog "      function_A NOT available :-("
   endif
   if function_B then
      Printlog "     function_B available :-)"
   else
      warnlog "      function_B NOT available :-("
   endif

   '/// check configuration files ///'
   Printlog ("    Look for the entries in the configuration files : Entry: '" + "Common;Internal;Slot")
   sTemp  = hGetSlotValueFromFile (fCommonUserXml, "Common;Internal;Slot")
   sTemp2 = hGetSlotValueFromFile (fCommonXml    , "Common;Internal;Slot")
   Printlog ("       User tree : '" + fCommonUserXml + "': '" + sTemp + "'" )
   Printlog ("       Share tree: '" + fCommonXml + "': '" + sTemp2 + "'" )

   '/// close the office ///'
   hEndOffice ()
   sleep 20

   printlog ""
   Printlog "'/// 1. only enable common.xcu entry (share-tree) -> Error Message has to come up ///'"

   '///+ start the office ///'
   Start sAppExe, sOfficeParameters
   sleep 20

   sTemp = hSetConfigurationValue ("/org.openoffice.Office.Common/Internal","Slot","True",bAdmin)
   Printlog ("    Changed to: '" + sTemp + "'")
   if (sTemp <> "True") then
      Warnlog ("  Value not set to 'True': '" + sTemp + "'")
   endif

   '/// check configuration files ///'
   sleep 5
   Printlog ("    Look for the entries in the configuration files : Entry: '" + "Common;Internal;Slot")
   sTemp  = hGetSlotValueFromFile (fCommonUserXml, "Common;Internal;Slot")
   sTemp2 = hGetSlotValueFromFile (fCommonXml    , "Common;Internal;Slot")
   Printlog ("       User tree : '" + fCommonUserXml + "': '" + sTemp + "'" )
   Printlog ("       Share tree: '" + fCommonXml + "': '" + sTemp2 + "'" )
   if ((sTemp = "") AND (sTemp2 = "")) then
      Warnlog ("              Entry not available in both files -> BUG: Configuration not written! :-(")
   else
      if (lCase(sTemp) <> "true" AND sTemp <> "") then
         Warnlog ("Value not set to 'true': '" + lCase(sTemp) + "'")
      endif
      if (lCase(sTemp2) <> "true" AND sTemp2 <> "") then
         Warnlog ("Value not set to 'true': '" + lCase(sTemp2) + "'")
      endif
   endif

'/// close the office ///'
   hEndOffice ()
   sleep 20

   '///+ start the office ///'
   hStartOffice ()
   sleep 20
   '///+ Message about wrong configuration has to come up and office quites   ///'
   kontext
   if active.exists (10) then
      Printlog "  active on office start: '" + active.GetText +"'"
      try
         active.ok
         bCrash = FALSE
      catch
         bCrash = TRUE
      endcatch
   else
      warnlog "Message missing 'An error has occurred in the special configuration.Please contact your administrator.'"
   endif
   if NOT bCrash then
   if active.exists (10) then
      qaErrorLog "  active after confirming, that the configuration is wrong: '" + active.GetText +"'"
      try
         active.no
      catch
         sleep 1
      endcatch
   endif
   endif
   sleep 60

   printlog ""
 Printlog "'/// 2. copy a slots_a.cfg into user/registry -> OK, check disbled function_a ///'"
 '///+ .. {from \\testtool\\framework\\level2\\slotscfg\\input\\slots_a.cfg to (workstation or FAToffice path)/user/config/slots.cfg} ///'
   FileCopy (fSlotPath + "slots_a.cfg", fUserConfig)
   '///+ start the office ///'
   hStartOffice ()
   sleep 20
   kontext   ' there has to be no message !
   if active.exists (10) then
      warnlog "   2. active on office start: '" + active.GetText +"'"
      try
         active.ok
         bCrash = FALSE
      catch
         bCrash = TRUE
      endcatch
   endif
   if NOT bCrash then
   if active.exists (10) then
      qaErrorLog "  active after confirming, that the configuration is wrong: '" + active.GetText +"'"
      try
         active.no
      catch
         sleep 1
      endcatch
   endif
   endif

   '///+ check if function is not available !    ///'
   if (function_a = TRUE) then
      warnlog "   function A is available :-("
   else
      printlog "   function A is not available :-)"
   endif

   '///+ close the office ///'
   hEndOffice ()
   sleep 20

   printlog ""
 Printlog "'/// 3. copy a slots_b.cfg into share/config -> OK, check disbled function_b & _a, _a has to work! ///'"
 '///+ .. {from \\testtool\\framework\\level2\\slotscfg\\input\\slots_b.cfg to (office[NET]path)/share/config/slots.cfg} ///'
   FileCopy (fSlotPath + "slots_b.cfg", fShareConfig)
   '///+ start the office ///'
   hStartOffice ()
   sleep 20
   kontext   ' there has to be no message !
   if active.exists (10) then
      warnlog "   3. active on office start: '" + active.GetText +"'"
      try
         active.ok
         bCrash = FALSE
      catch
         bCrash = TRUE
      endcatch
   endif
   if NOT bCrash then
   if active.exists (10) then
      qaErrorLog "  active after confirming, that the configuration is wrong: '" + active.GetText +"'"
      try
         active.no
      catch
         sleep 1
      endcatch
   endif
   endif

   '///+ check if function_b is not available !    ///'
   if (function_b = TRUE) then
      warnlog "      function_b is available :-("
   else
      printlog "     function_b is not available :-)"
   endif
   '///+ check if function_a _is_ available !    ///'
   if (function_a = FALSE) then
      warnlog "      function_a is not available :-("
   else
      printlog "     function_a is available :-)"
   endif

   '///+ close the office ///'
   hEndOffice ()
   sleep 20

   printlog ""
 Printlog "'/// 4. remove slots_a.cfg into user/config -> OK, check disbled function_b ///'"
   Kill (fUserConfig)
   sleep 3
   '///+ start the office ///'
   hStartOffice ()
   sleep 20
   kontext   ' there has to be no message !
   if active.exists (10) then
      warnlog "   4. active on office start: '" + active.GetText +"'"
      try
         active.ok
         bCrash = FALSE
      catch
         bCrash = TRUE
      endcatch
   endif
   if NOT bCrash then
   if active.exists (10) then
      qaErrorLog "  active after confirming, that the configuration is wrong: '" + active.GetText +"'"
      try
         active.no
      catch
         sleep 1
      endcatch
   endif
   endif

   '///+ check if function is not available !    ///'
   if (function_b = TRUE) then
      warnlog "      function B is available :-("
   else
      printlog "     function B is not available :-)"
   endif

   '///+ close the office ///'
   hEndOffice ()
   sleep 20

   printlog ""
 Printlog "'/// 5. disable common.xcu entry -> Error Message has to come up ///'"
   Start sAppExe, sOfficeParameters
   sleep 20

   sTemp = hSetConfigurationValue ("/org.openoffice.Office.Common/Internal","Slot","False",bAdmin)
   Printlog ("    Changed to: '" + sTemp + "'")
   if (lCase(sTemp) <> "false") then
      Warnlog ("  Value not set to 'false': '" + lCase(sTemp) + "'")
   endif

   '/// check configuration files ///'
   sleep 5
   Printlog ("    Look for the entries in the configuration files : Entry: '" + "Common;Internal;Slot")
   sTemp  = hGetSlotValueFromFile (fCommonUserXml, "Common;Internal;Slot")
   sTemp2 = hGetSlotValueFromFile (fCommonXml    , "Common;Internal;Slot")
   Printlog ("       User tree : '" + fCommonUserXml + "': '" + sTemp + "'" )
   Printlog ("       Share tree: '" + fCommonXml + "': '" + sTemp2 + "'" )
   if ((sTemp = "") AND (sTemp2 = "")) then
      Warnlog ("              Entry not available in both files -> BUG: Configuration not written! :-(")
   else
      if (lCase(sTemp) <> "false" AND sTemp <> "") then
         Warnlog ("Value not set to 'false': '" + lCase(sTemp) + "'")
      endif
      if (lCase(sTemp2) <> "false" AND sTemp2 <> "") then
         Warnlog ("Value not set to 'false': '" + lCase(sTemp2) + "'")
      endif
   endif

'/// close the office ///'
   hEndOffice ()
   sleep 20

   '///+ start the office ///'
   hStartOffice ()
   sleep 20

   '///+ Message about wrong configuration has to come up and office quites   ///'
   kontext
   if active.exists (10) then
      Printlog "  active on office start: '" + active.GetText +"'"
      try
         active.ok
         bCrash = FALSE
      catch
         bCrash = TRUE
      endcatch
   else
      warnlog "Message missing 'An error has occurred in the special configuration.Please contact your administrator.'"
   endif
   if NOT bCrash then
   if active.exists (10) then
      qaErrorLog "  active after confirming, that the configuration is wrong: '" + active.GetText +"'"
      try
         active.no
      catch
         sleep 1
      endcatch
   endif
   endif

   sleep 60

    printlog ""
Printlog "'/// 6. copy a slots_a.cfg into user/config, remove from share/config -> Error Message has to come up ///'"
   FileCopy (fSlotPath + "slots_a.cfg", fUserConfig)
   Kill (fShareConfig)

   '///+ start the office ///'
   hStartOffice ()
   sleep 20

   '///+ Message about wrong configuration has to come up and office quites   ///'
   kontext
   if active.exists (10) then
      Printlog "  active on office start: '" + active.GetText +"'"
      try
         active.ok
         bCrash = FALSE
      catch
         bCrash = TRUE
      endcatch
   else
      warnlog "Message missing 'An error has occurred in the special configuration.Please contact your administrator.'"
   endif
   if NOT bCrash then
   if active.exists (10) then
      qaErrorLog "  active after confirming, that the configuration is wrong: '" + active.GetText +"'"
      try
         active.no
      catch
         sleep 1
      endcatch
   endif
   endif

   sleep 60

' C NET installation performs the same checks as the FAT one with some additions (share and user path are different ! ) ///'
' make user installation from a slots.cfg configured user/config NET installation ///'
'+ is it copied to user istallation ? ///'

   printlog ""
 Printlog "'/// Clean up///'"
'///+ remove slots.cfg from user/config and everything has to be ok now :-) ///'
   Kill (fUserConfig)

   '/// start the office to satisfy the TestTool on test exit :-) ///'
   hStartOffice ()
   sleep 20
endcase

sub hEndOffice
   try
      FileExit "SynchronMode", TRUE
      Kontext "Active"
      if Active.Exists then
         if Active.GetRT = 304 then
            try
               Active.No
            catch
      sleep 1
            endcatch
         endif
      endif
   catch
      sleep 1
   endcatch
end sub

sub hStartOffice
   Start sAppExe, sOfficeParameters
end sub

function hGetSlotValueFromFile (sFile as string, sElementLine as string, optional bSilent as boolean) as string
   dim sTemp as string
   dim sXMLFile as String
   dim i as integer
   dim bError as boolean
   dim bSilentLocal as boolean

   if isMissing(bSilent) then
      bSilentLocal = True
   else
      bSilentLocal = bSilent
   endif

   sXMLFile = ConvertPath ( sFile )
   hGetSlotValueFromFile = ""
   try
      if (dir(sXMLFile)<>"") then
         SAXReadFile ( sXMLFile ) ' open SAX Parser
      else
         exit function
      endif
   catch
      if (bSilentLocal = False) then
         warnlog "file doesn't exists: '" + sXMLFile + "'"
      endif
      exit function   ' exit if Opening file fails !
   endcatch

   if (hXMLGotoElement(sElementLine, bSilentLocal) = FALSE) then
      exit function
   endif

   for i = 1 to 2
      if (SAXGetNodeType <> NodeTypeCharacter) then
         if (SAXGetChildCount > 0) then
            SAXSeekElement(1)
         endif
      endif
   next i

   if (SAXGetNodeType = NodeTypeCharacter) then
      sTemp = SAXGetChars
   else
      sTemp = ""
'      bError = True
'      Printlog ("hkjh: " + SAXGetElementName)
'      Printlog ("hkjh: " + SAXGetAttributeCount)
'      Printlog ("hkjh: " + SAXGetAttributeValue(1))
'      Printlog ("hkjh: " + SAXGetAttributeName(1))
'      Printlog ("hkjh: " + SAXGetAttributeValue(2))
'      Printlog ("hkjh: " + SAXGetAttributeName(2))
   endif

   SAXRelease
   hGetSlotValueFromFile = sTemp
end function

function function_A () as boolean
   function_A = False
   try
      'FileOpen ' function_a
      FileOpen_uno
      sleep 1
'     printlog "function_A:: Available"
      kontext "GeneralFileDialog"
      if GeneralFileDialog.exists (5) then
         if (Dateityp.GetSelText = "") then
'            warnlog "function_A::Error no file type selcted"
         endif
      else
'         printlog "function_A::no file-open-dialog"
      endif
      sleep 1
      GeneralFileDialog.Cancel
      function_A = True
   catch
'      printlog "function_A:: Not available"
   endcatch
   sleep 1
end function

function function_B () as boolean
   function_B = False
   try
'      EditSearchAndReplace ' function_b
      EditSearchAndReplace_uno
'     printlog "function_B:: Available"
      sleep 1
      kontext "FindAndReplace"
      if FindAndReplace.exists (5) then
         printlog "1"
         try
             RegularExpressions.UnCheck
         catch
             More.Click
             sleep (3)
             printlog RegularExpressions.IsChecked
             printlog RegularExpressions.IsEnabled
             printlog RegularExpressions.IsVisible
             RegularExpressions.UnCheck
         endcatch
         printlog "2"
         if WholeWordsOnly.IsEnabled then
            printlog "3"
            RegularExpressions.Check
            printlog "4"
            function_B = TRUE
            sleep 1
            RegularExpressions.UnCheck
         endif
      else
         printlog "5"
'         printlog "function_B::no search&replace-dialog"
      endif
      FindAndReplace.Cancel
   catch
         printlog "6"
'      printlog "function_B:: Not available"
   endcatch
   sleep 1
end function

testcase tCommandsXML
'/// since srx 642 w/e (1.round) there is also the possibility to disable functions with a xml file ///'
'///+ feature mail from 22.04.2002, framework, carsten driesner "Support for disabling commands" ///'
'///+ to test  the feature with testtool you HAVE to use the UNO-URLs! (serach for '.uno:' stuff) ///'
'///+ so i created 2 examples just for this test, since we usually use the slots-urls ///'
'///+ docuemnt is on OOo: http://framework.openoffice.org/servlets/ProjectDocumentList?dcID=1042&action=download ///'
'///+ Developer for API questions: Joerg Barfurth see DevelopersGuide http://api.openoffice.org/unbranded-source/browse/~checkout~/api/devmanual/DevelopersGuide/Config/Config.xml ///'

   dim sTemp as string
   dim sTemp2 as string
   dim fCommonXml as string
   dim fCommonUserXml as string
'   dim fCacheXml as string
   dim sValue as string
   dim bWriteAccess as boolean
   dim fTestPath as string
   dim bAdmin as boolean

   bAdmin = true 'write to share-tree; only if not writable in that tree fall back to 'false'

   if gNetzInst then
      fCommonXml  = ConvertPath (gNetzOfficePath + "share\registry\data\org\openoffice\Office\Commands.xcu")
'      fCacheXml   = ConvertPath (gNetzOfficePath + "share\registry\cache\data\org\openoffice\Office\Commands.dat")
      fTestPath   = ConvertPath (gNetzOfficePath + "share\registry\data\org\openoffice\Office\")
   else
      fCommonXml  = ConvertPath (gOfficePath + "share\registry\data\org\openoffice\Office\Commands.xcu")
'      fCacheXml   = ConvertPath (gOfficePath + "share\registry\cache\data\org\openoffice\Office\Commands.dat")
   endif
   fCommonUserXml = ConvertPath (gOfficePath + "user\registry\data\org\openoffice\Office\Commands.xcu")

   if (gNetzInst) then ' there are 2 paths' for configurations
      bWriteAccess = fisPathWritable(fTestPath)
      if (bWriteAccess = FALSE) then ' ... and only one is writeable
      '/// if NET and (SHARE not writeable), redefine paths' ///'
         qaErrorLog "You are testing a Networkinstallation and you don't have writing access to the Network installation!"
         qaErrorLog "To give this test a greater value, please run the test again with writing access to: '" + fCommonXml + "'"
         fCommonXml  = ConvertPath (gOfficePath + "user\registry\data\org\openoffice\Office\Commands.xcu")
'         fCacheXml   = ConvertPath (gNetzOfficePath + "user\registry\cache\data\org\openoffice\Office\Commands.dat")
         bAdmin = false ' FALLBACK :-(
      endif
   endif

   printlog ""
 Printlog ("'/// 0. Check Presuppositions, if we have default values ///'")
   '/// define function_a as File->Open FileOpen SID_OPENDOC 5501 <b>Open</b> ///'
   '///+ define function_b as Edit->SearchAndReplace EditSearchAndReplace SID_SEARCH_DLG 5961 <b>SearchDialog</b> ///'

   '/// check if function a and b are available! ///'
   if function_A then
      Printlog " function_A available :-)"
   else
      warnlog " function_A NOT available :-( - presupposition failed"
   endif
   if function_B then
      Printlog " function_B available :-)"
   else
      warnlog " function_B NOT available :-( - presupposition failed"
   endif

   '/// check configuration files ///'
   sleep 5
   Printlog ("    Look for the entries in the configuration FILES: '" + fCommonXml + "' Entry: '" + "Commands;Execute;Disabled;foo|bar")
   sTemp  = hGetSlotValueFromFile (fCommonXml, "Commands;Execute;Disabled;foo;Command", True)
   sTemp2 = hGetSlotValueFromFile (fCommonXml, "Commands;Execute;Disabled;bar;Command", True)
   Printlog ("       foo: '" + sTemp + "'" )
   Printlog ("       bar: '" + sTemp2 + "'" )
   if ((sTemp = "") AND (sTemp2 = "")) then
      printlog ("              Both Entries not available. :-)")
   else
      if (sTemp <> "") then
         Warnlog ("Value not set to '': '" + lCase(sTemp) + "' - presupposition failed")
      endif
      if (sTemp2 <> "") then
         Warnlog ("Value not set to '': '" + lCase(sTemp2) + "' - presupposition failed")
      endif
   endif

'/// close the office ///'
   hEndOffice ()
   sleep 20
   Printlog ("")
 Printlog "'/// 1. Disable function_a via API ConfigurationManager -> OK, check disbled function_a ///'"
   ' '/// kill cache file to force reareading of xcu file (workstation or FAToffice path)share\registry\cache\data\org\openoffice\Office\Commands.dat} ///'
   '   if (dir(fCacheXml) <> "" ) then Kill (fCacheXml)
   '   sleep 1
   if (dir(fCommonUserXml) <> "") then
       kill(fCommonUserXml)
    endif

   '///+ start the office ///'
   Start sAppExe, sOfficeParameters
   sleep 20

   '///+ Disable function ///'
   sTemp = hSetConfigurationValue2 ("/org.openoffice.Office.Commands/Execute/Disabled","Command","Open",bAdmin, "foo", True)
   Printlog ("    Changed to: '" + sTemp + "'")

'/// close the office ///'
   hEndOffice ()
   sleep 20

   '///+ start the office ///'
   Start sAppExe, sOfficeParameters
   sleep 20

   '/// check configuration files ///'
   Printlog ("    Look for the entries in the configuration FILES: '" + fCommonXml + "' Entry: '" + "Commands;Execute;Disabled;foo|bar")
   sTemp  = hGetSlotValueFromFile (fCommonXml, "Commands;Execute;Disabled;foo;Command", True)
   Printlog ("       foo: '" + sTemp + "'" )
   if (lCase(sTemp) <> "open") then
      Warnlog ("     Value not set to 'open': '" + lCase(sTemp) + "' - configuration wasn't written to FILE!")
   endif

   '///+ check if function is not available !    ///'
   if (function_a = TRUE) then
      warnlog "function A is available :-("
   endif

   Printlog ("")
 Printlog "'/// 2. Disable function_b via API ConfigurationManager -> OK, check disbled function_b ///'"
   sTemp = hSetConfigurationValue2 ("/org.openoffice.Office.Commands/Execute/Disabled","Command","SearchDialog",bAdmin, "bar", True)
   Printlog ("    Changed to: '" + sTemp + "'")
'///+ close the office ///'
   hEndOffice ()
   sleep 20

   '///+ start the office ///'
   Start sAppExe, sOfficeParameters
   sleep 20
   '/// check configuration files ///'
   Printlog ("    Look for the entries in the configuration FILES: '" + fCommonXml + "' Entry: '" + "Commands;Execute;Disabled;foo|bar")
   sTemp = hGetSlotValueFromFile (fCommonXml, "Commands;Execute;Disabled;bar;Command", True)
   Printlog ("       bar: '" + sTemp + "'" )
   if (lCase(sTemp) <> "searchdialog") then
      Warnlog ("     Value not set to 'searchdialog': '" + lCase(sTemp) + "'")
   endif

   '///+ check if function is not available !    ///'
   if (function_b = TRUE) then
      warnlog "function B is available :-("
   endif

   Printlog ("")
 Printlog "'/// Clean up ///'"
   '///  Enable function_a and function_b via API ConfigurationManager ///'
   sTemp = hSetConfigurationValue2 ("/org.openoffice.Office.Commands/Execute/Disabled","Command","",bAdmin, "foo", True)
   Printlog ("    Changed to: '" + sTemp + "'")
   sTemp = hSetConfigurationValue2 ("/org.openoffice.Office.Commands/Execute/Disabled","Command","",bAdmin, "bar", True)
   Printlog ("    Changed to: '" + sTemp + "'")
   '///+ close the office ///'
   hEndOffice ()
   sleep 20

' '/// kill cache file to force reareading of xcu file ///'
'   if (dir(fCacheXml) <> "" ) then Kill (fCacheXml)

'/// start the office to satisfy the TestTool on test exit :-) ///'
   hStartOffice ()
   sleep 20
   '/// check configuration files ///'
   Printlog ("    Look for the entries in the configuration FILES: '" + fCommonXml + "' Entry: '" + "Commands;Execute;Disabled;foo|bar")
   sTemp  = hGetSlotValueFromFile (fCommonXml, "Commands;Execute;Disabled;foo;Command", True)
   sTemp2 = hGetSlotValueFromFile (fCommonXml, "Commands;Execute;Disabled;bar;Command", True)
   Printlog ("       foo: '" + sTemp + "'" )
   Printlog ("       bar: '" + sTemp2 + "'" )
   if ((sTemp = "") AND (sTemp2 = "")) then
      printlog ("              Both Entries not available. :-)")
   else
      if (sTemp = "") then
         Warnlog ("Value not set to '': '" + lCase(sTemp) + "'")
      endif
      if (sTemp2 = "") then
         Warnlog ("Value not set to '': '" + lCase(sTemp2) + "'")
      endif
   endif

'///+ .. check if function a and b are available! ///'
   if function_A then
      Printlog " function_A available :-)"
   else
      warnlog " function_A NOT available :-("
   endif
   if function_B then
      Printlog " function_B available :-)"
   else
      warnlog " function_B NOT available :-("
   endif
endcase

function fisPathWritable (fTestPath as string) as boolean
   '/// workaround for try/catch problem not parsing file :-( ///'
   '/// try to create a directory in the share configuration part of the installation to see if we have some rights ///'
   try
      mkdir (fTestPath + "x")
      rmdir (fTestPath + "x")
      fisPathWritable = TRUE
   catch
      fisPathWritable = FALSE
      qaErrorLog "you have no write rights in the global configuration directory -> this feature is not tested :-("
      qaErrorLog "please make the directory '" + left(fTestPath,instr(fTestPath,"share")+5) + "' RECURSIV writable for all!"
   endcatch
end function

function hSetConfigurationValue(sPath as string, sProperty as string, sValue as string, bAdmin as boolean) as string
   dim oUno as object
   dim aConfigProvider as object
   dim sView as string
   dim aParams(1) As new com.sun.star.beans.PropertyValue
   dim aTest(0) As new com.sun.star.beans.PropertyValue
   dim xViewRoot as object
   dim sTemp as string
   dim sProvider as string
   dim iEntries, i as integer

   if bAdmin then
      sProvider = "com.sun.star.configuration.AdministrationProvider"
'      printlog "        hSetConfigurationValue2:: Admin"
   else
      sProvider = "com.sun.star.configuration.ConfigurationProvider"
'      printlog "        hSetConfigurationValue2:: User"
   endif
   try
      oUno = GetUnoApp
   catch
      warnlog "hSetConfigurationValue2:: Can't connect to the Office UNO port :-("
   endcatch
   aConfigProvider = oUno.createInstance( sProvider )
   sView = "com.sun.star.configuration.ConfigurationUpdateAccess"
   aParams(0).Name = "nodepath"
   aParams(0).Value = sPath
   aParams(1).Name = "lazywrite"
   aParams(1).Value = False
'   aParams(1).Value = true
   xViewRoot = aConfigProvider.createInstanceWithArguments(sView, aParams())

'   Printlog ("--------------")
'   printlog xViewRoot.dbg_Methods
'   Printlog ("--------------")
'   printlog xViewRoot.dbg_SupportedInterfaces
'   Printlog ("--------------")
'   printlog xViewRoot.dbg_Properties
'   Printlog ("--------------")
'   printlog xViewRoot.ElementTemplateName
'   Printlog ("--------------")

'   sTemp = xViewRoot.GetByName(sProperty)
'   Printlog ("Current Value of " + sPath + "::" + sProperty + " '" + sTemp + "'")

   if (xViewRoot.hasByName(sProperty) AND (sValue="")) then
      ' delete item
      xViewRoot.removeByName(sProperty)
      sTemp = ""
   else
      xViewRoot.setPropertyValue(sProperty, sValue)
   endif
   try
      xViewRoot.commitChanges()
   catch
      warnlog "hSetConfigurationValue:: you don't have write access to the configuration :-("
      exit function
   endcatch
   if xViewRoot.hasPendingChanges then
      warnlog "Changes still pending :-("
   endif
   sTemp = xViewRoot.GetByName(sProperty)
'   Printlog ("Changed Value of " + sPath + "::" + sProperty + " '" + sTemp + "'")
   xViewRoot.dispose()
   hSetConfigurationValue = sTemp
end function

function hSetConfigurationValue2(sPath as string, sProperty as string, sValue as string, bAdmin as boolean, sCommandType as string, optional bSilent as boolean) as string
   dim oUno as object
   dim oUno2 as object
   dim aConfigProvider as object
   dim sView as string
   dim aParams(1) As new com.sun.star.beans.PropertyValue
   dim xViewRoot as object
   dim xViewUpdate as object
   dim sTemp as string
   dim sElementF()
   dim sProvider as string
   dim iEntries, i as integer
   dim bSilentLocal as boolean

   if isMissing(bSilent) then
      bSilentLocal = True
   else
      bSilentLocal = bSilent
   endif

   if bAdmin then
      sProvider = "com.sun.star.configuration.AdministrationProvider"
'      printlog "        hSetConfigurationValue2:: Admin"
   else
      sProvider = "com.sun.star.configuration.ConfigurationProvider"
'      printlog "        hSetConfigurationValue2:: User"
   endif
   try
      oUno = GetUnoApp
   catch
      warnlog "hSetConfigurationValue2:: Can't connect to the Office UNO port :-("
   endcatch
   aConfigProvider = oUno.createInstance( sProvider )
   sView = "com.sun.star.configuration.ConfigurationUpdateAccess"
   aParams(0).Name = "nodepath"
   aParams(0).Value = sPath
   aParams(1).Name = "lazywrite"
   aParams(1).Value = False ' syncron write
'   aParams(1).Value = true  ' asyncron write
   xViewRoot = aConfigProvider.createInstanceWithArguments(sView, aParams())
'   Printlog ("--------------")
'   printlog xViewRoot.dbg_Methods
'   Printlog ("--------------")
'   printlog xViewRoot.dbg_SupportedInterfaces
'   Printlog ("--------------")
'   printlog xViewRoot.dbg_Properties
'   Printlog ("--------------")
'   printlog xViewRoot.ElementTemplateName

   if (bSilentLocal = False) then
      sElementF() = xViewRoot.ElementNames
      iEntries = UBound(sElementF())
      if iEntries > -1 then
         Printlog ("--------------")
         warnlog "there are entries! " + (iEntries+1)
      endif
      for i = 0 to iEntries
         oUno2 = xViewRoot.getByName(sElementF(i))
         sTemp = oUno2.GetByName(sProperty)
         warnlog " - " + i + ": '" + sElementF(i) + "' :: '" + sTemp + "'"
      next i
      if iEntries > -1 then
         Printlog ("--------------")
      endif
   endif

   if xViewRoot.hasByName(sCommandType) then
      ' delete item
      xViewRoot.removeByName(sCommandType)
      sTemp = ""
   else
   endif
   if (sValue <> "") then 'create the entry
      xViewUpdate = xViewRoot.createInstance()
      xViewUpdate.setPropertyValue(sProperty, sValue)
      xViewRoot.insertByName (sCommandType, xViewUpdate)
      oUno2 = xViewRoot.getByName(sCommandType)
      sTemp = oUno2.GetByName(sProperty)
   endif

' debugging of informations
'   sElementF() = xViewRoot.ElementNames
'   iEntries = UBound(sElementF())
'   for i = 0 to iEntries
'      printlog " - " + i + ": " + sElementF(i)
'   next i

   try
      printlog "before commit"
      xViewRoot.commitChanges()
      printlog "after commit"
   catch
      warnlog "hSetConfigurationValue2:: you don't have write access to the configuration :-("
      exit function
   endcatch
   if xViewRoot.hasPendingChanges then
      warnlog "Changes still pending :-("
   ' for displaying pending changes
      sElementF() = xViewRoot.PendingChanges
      iEntries = UBound(sElementF())
      for i = 0 to iEntries
         printlog " - " + i + ": " + sElementF(i).Accessor
      next i
   endif
 '  xViewRoot.dispose()
   hSetConfigurationValue2 = sTemp
   if (bAdmin) then   ' only if bAdmin! else whole configuration manager will be shut down!!
    '  aConfigProvider.dispose()
   endif
end function

testcase tWriteUserShareLayer
'/// idea from #107047#; if API is used, nobody checked WHERE the API writes the files to ///'
   dim fCommonXml as string
   dim fCommonUserXml as string
   dim fTestPath as string
   dim bWriteAccess as boolean
   dim sTemp as string

   if gNetzInst then
      fCommonXml  = ConvertPath (gNetzOfficePath + "share\registry\data\org\openoffice\Office\Commands.xcu")
      fTestPath   = ConvertPath (gNetzOfficePath + "share\registry\data\org\openoffice\Office\")
   else
      fCommonXml  = ConvertPath (gOfficePath + "share\registry\data\org\openoffice\Office\Commands.xcu")
   endif
   fCommonUserXml = ConvertPath (gOfficePath + "user\registry\data\org\openoffice\Office\Commands.xcu")

   if (gNetzInst) then ' there are 2 paths' for configurations
      bWriteAccess = fisPathWritable(fTestPath)
      if (bWriteAccess = FALSE) then ' ... and only one is writeable
      '/// if NET and (SHARE not writeable), exit this test ' ///'
         qaErrorLog "You are testing a Networkinstallation and you don't have writing access to the Network installation!"
         qaErrorLog "Please run the test again with writing access to: '" + fCommonXml + "'"
         goto endsub
      endif
  endif

   hEndOffice ()
   sleep 20
   hStartOffice ()
   sleep 20

   sTemp  = hGetSlotValueFromFile (fCommonXml, "Commands;Execute;Disabled;SHARE;Command", True)
   Printlog ("    Rescent   : '" + sTemp + "'")
   sTemp  = hGetSlotValueFromFile (fCommonUserXml, "Commands;Execute;Disabled;USER;Command", True)
   Printlog ("    Rescent   : '" + sTemp + "'")

   sTemp = hSetConfigurationValue2 ("/org.openoffice.Office.Commands/Execute/Disabled","Command","test",TRUE, "SHARE", True)
   Printlog ("    Changed to: '" + sTemp + "'")
   sTemp = hSetConfigurationValue2 ("/org.openoffice.Office.Commands/Execute/Disabled","Command","test",FALSE, "USER", True)
   Printlog ("    Changed to: '" + sTemp + "'")

   hEndOffice ()
   sleep 20
   hStartOffice ()
   sleep 20

   sTemp  = hGetSlotValueFromFile (fCommonXml, "Commands;Execute;Disabled;SHARE;Command", True)
   Printlog ("    Changed to: '" + sTemp + "'")
   sTemp  = hGetSlotValueFromFile (fCommonUserXml, "Commands;Execute;Disabled;USER;Command", True)
   Printlog ("    Changed to: '" + sTemp + "'")

   sTemp = hSetConfigurationValue2 ("/org.openoffice.Office.Commands/Execute/Disabled","Command","",TRUE, "SHARE", True)
   Printlog ("    Changed to: '" + sTemp + "'")
   sTemp = hSetConfigurationValue2 ("/org.openoffice.Office.Commands/Execute/Disabled","Command","",FALSE, "USER", True)
   Printlog ("    Changed to: '" + sTemp + "'")

   hEndOffice ()
   sleep 20
   hStartOffice ()
   sleep 20

   sTemp  = hGetSlotValueFromFile (fCommonXml, "Commands;Execute;Disabled;SHARE;Command", True)
   Printlog ("    Rescent   : '" + sTemp + "'")
   sTemp  = hGetSlotValueFromFile (fCommonUserXml, "Commands;Execute;Disabled;USER;Command", True)
   Printlog ("    Rescent   : '" + sTemp + "'")
endcase

