'encoding UTF-8  Do not remove or change this line!
'*******************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_basic_extension_identifiers.inc,v $
'*
'*  $Revision: 1.5.4.1 $
'*
'*  last change: $Author: jsk $ $Date: 2008/02/21 13:04:06 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2006 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/******************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Use unique identifiers instead of filenames for extensions
'*
'*******************************************************************************
'**
' #1 tExtensionIdentifiers ' Use unique identifiers instead of filenames for extensions
'**
'\******************************************************************************

testcase tExtensionIdentifiers

    '///<h3>Use unique identifiers instead of filenames to distinguish extensions</h3>
    '///<i>Spec: http://specs.openoffice.org/appwide/packagemanager/extensionidentifiers.odt</i><br>
    '///<i>This test also verifies the presence of an extension shipped with the
    '///+ product and installed via unopkg during setup. This extension is not
    '///+ present in all brands of the product (means: StarOffice/StarSuite only,
    '///+ build &ge; 9181). We do not test the extension itself but merely count
    '///+ the items in the list as a bonus feature to this test case.</i><br>
    '///<ul>
    
    qaerrorlog( "#i86304# - deadlock when deleting extension" )
    goto skiptest
    
    dim cExtensionPath( 2 ) as string
    dim cCommonPath as string
    dim iExtensionCount as integer
    dim iCurrentItem as integer
    dim irc as integer
    dim iExtCountMax as integer
    
    dim iExtensionCountInitial as integer
    
    const FILE_NAME = "identifier.oxt"
    const EXT_CLASS = "t.rdb"
    const EXT_COUNT_BUFFER = 4
    const EXT_COUNT_MAX    = 200
    
    dim cExtensionList( EXT_COUNT_MAX ) as string
    
    
    ' paths to the extensions - the have identical names but different identifiers
    cCommonPath = gTesttoolPath & "framework\basic\input\extensions\identifier\"
    cExtensionPath( 1 ) = convertpath( cCommonPath & "legacy\"   & FILE_NAME )
    cExtensionPath( 2 ) = convertpath( cCommonPath & "explicit\" & FILE_NAME )
    
    ' The number of nodes in the treelist depends on the build. Beginning with 9181
    ' there are 18 by default for StarOffice, 2 for OpenOffice.org
    
    printlog( "Setting up environment / prerequisites" )
    
    iExtCountMax = iExtensionCountInitial + EXT_COUNT_BUFFER
   
    '///+<li>Get the list of items listed in extensions list, count number of items</li>
    iExtensionCountInitial = hExtensionGetItemList( cExtensionList() )
    
    printlog( "" )
    printlog( "Test enter" )
    
    '///+<li>Add the first extension, we do not expect a license text</li>
    printlog( "" )
    printlog( "Add first extension" )
    irc = hExtensionAddGUI( cExtensionPath( 1 ) , false )
    if ( irc <> 0 ) then
        warnlog( "Adding extension failed with rc = " & irc & ", aborting test" )
        goto endsub
    endif
    
    '///+<li>Verify number items in the extension list again</li>
    iExtensionCount = hExtensionGetItemList( cExtensionList() )
    if ( iExtensionCount <> iExtensionCountInitial + 2 ) then
        warnlog( "Adding extension failed." )
        goto endsub
    endif
    
    '///+<li>Add the second extension, we do not expect a license text</li>
    printlog( "" )
    printlog( "Add second extension" )
    irc = hExtensionAddGUI( cExtensionPath( 2 ) , false )
    if ( irc <> 0 ) then
        warnlog( "Adding extension failed with rc = " & irc & ", aborting test" )
        goto endsub
    endif
    
    '///+<li>Verify number items in the extension list again</li>
    iExtensionCount = hExtensionGetItemList( cExtensionList() )
    if ( iExtensionCount <> iExtensionCountInitial + 4 ) then
        warnlog( "Adding extension failed." )
        goto endsub
    endif   
    
    '///+<li>Verify the names and the order of the installed extensions</li> 
    '///<ul>
    '///+<li>File-/Extensionname at position 2 and 4 (absolute)</li>
    if ( cExtensionList( 2 ) <> FILE_NAME ) then
        warnlog( "Extension filename not at expected position 2" )
    else
        printlog( "Extension filename at position 2. Good." )
    endif

    if ( cExtensionList( 4 ) <> FILE_NAME ) then
        warnlog( "Extension filename not at expected position 4" )
    else
        printlog( "Extension filename at position 4. Good." )
    endif
    
    '///+<li>Extension class name at position 3 and 5 (absolute)</li>
    if ( cExtensionList( 3 ) <> EXT_CLASS ) then
        warnlog( "Extension class not at expected position 3" )
    else
        printlog( "Extension class at position 3. Good." )
    endif

    if ( cExtensionList( 5 ) <> EXT_CLASS ) then
        warnlog( "Extension class not at expected position 3" )
    else
        printlog( "Extension class at position 3. Good." )
    endif
    '///</ul>

    '///+<li>Cleanup: Remove extensions and close document</li>
    printlog( "Test exit, cleanup" )
    hExtensionRemoveGUI( FILE_NAME )
    hExtensionRemoveGUI( FILE_NAME )
    hDestroyDocument()
    '///</ul>
    
    skiptest:

endcase

