'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: ch2_menu.inc,v $
'*
'*  $Revision: 1.7 $
'*
'*  last change: $Author: jsi $ $Date: 2007/12/17 11:32:50 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@sun.com
'*
'* short description : Resource Test for chart2 main menus
'*
'**************************************************************************************************
'*
' #1 tMainMenu          'Checking the count of menu entries in each menu
'*
'\*************************************************************************************************

testcase tMainMenu
    dim iCount as integer ' the numbers of the items in the menu.

    '/// Close all document windows (File / Close)
    Do Until GetDocumentCount = 0
        Call hCloseDocument
    Loop    
    
    '/// File / New / Spreadsheet
    printlog "open a new spreadsheet"
    call hNewDocument
    
    '/// Insert a Chart Object
    printlog "insert a Chart Object"
    if fInsertOLE = FALSE then
        warnlog "It was not possible to insert a chart as OLE."
        Call hCloseDocument
    else
        Kontext "DocumentCalc"
        DocumentCalc.UseMenu
        '/// check if there are 21 items in the FILE menu.
        printlog "check if there are 21 items in the FILE menu."
        hMenuSelectNr(1) ' FILE        
        iCount = hMenuItemGetCount()        
        if (iCount <> 21 ) then
            warnlog "There should be 21 items in the file menu but there are " + iCount + " items."
        end if        
        call hMenuClose() ' close the FILE menu
        
        '/// check if there are 12 items in the FILE/NEW menu.
        printlog "check if there are 12 items in the FILE/NEW menu."
        DocumentCalc.UseMenu
        hMenuSelectNr(1) ' FILE
        hMenuSelectNr(1) ' NEW        
        iCount = hMenuItemGetCount()        
        if (iCount <> 12) then
            warnlog "There should 12 items in the FILE/NEW menu but there are " + iCount + " items."
        end if        
        call hMenuClose() ' close the FILE menu
        
        '/// check if there are 8 items in the FILE/AUTOPILOT menu.
        printlog "check if there are 8 items in the FILE/AUTOPILOT menu."        
        DocumentCalc.UseMenu        
        hMenuSelectNr(1) ' FILE
        hMenuSelectNr(4) ' AUTOPILOT        
        iCount = hMenuItemGetCount()
        if (gOOO) then   
            if (iCount <> 10) then
                warnlog "There should 10 items in the FILE/AUTOPILOTS menu but there are " + iCount + " items."
            end if
        else
            if (iCount <> 8) then
                warnlog "There should 8 items in the FILE/AUTOPILOTS menu but there are " + iCount + " items."
            end if
        endif
        call hMenuClose()
        
        '/// check if there are 5 items in the EDIT menu.
        printlog "check if there are 5 items in the EDIT menu."
        DocumentCalc.UseMenu 
        hMenuSelectNr(2)        
        iCount = hMenuItemGetCount()
        if (iCount <> 5) then
            warnlog "There should 5 items in the edit menu but there are " + iCount + " items."
        end if
        call hMenuClose()

        '/// check if there are 4 items in the VIEW menu.
        printlog "check if there are 4 items in the VIEW menu."
        DocumentCalc.UseMenu 
        hMenuSelectNr(3)        
        iCount = hMenuItemGetCount()
        if (iCount <> 4) then
            warnlog "There should 4 items in the view menu but there are " + iCount + " items."
        end if
        call hMenuClose()
       
        '/// check if there are 4 items in the VIEW/TOOLBAR menu.        
        printlog "check if there are 4 items in the VIEW/TOOLBAR menu."        
        DocumentCalc.UseMenu 
        hMenuSelectNr(3) ' VIEW        
        hMenuSelectNr(1) ' TOOLBAR
        iCount = hMenuItemGetCount()
        if (iCount <> 4) then
            warnlog "There should 4 items in the VIEW/TOOLBAR menu but there are " + iCount + " items."
        end if
        call hMenuClose()
        
        '/// check if there are 7 items in the INSERT menu.
        printlog "check if there are 7 items in the INSERT menu."
        DocumentCalc.UseMenu 
        hMenuSelectNr(4)       
        iCount = hMenuItemGetCount()
        if (iCount <> 7) then
            warnlog "There should 7 items in the INSERT menu but there are " + iCount + " items."
        end if
        call hMenuClose()
 
        
        '/// check if there are 13 items in the FORMAT menu.
        printlog "check if there are 13 items in the FORMAT menu."
        DocumentCalc.UseMenu
        hMenuSelectNr(5) ' FORMAT        
        iCount = hMenuItemGetCount()        
        if (iCount <> 13) then
            warnlog "There should 13 items in the FORMAT menu but there are " + iCount + " items."
        end if

        '/// check if there are 2 items in the FORMAT/ARRANGEMENT menu.
        printlog "check if there are 2 items in the FORMAT/ARRANGEMENT menu."
        DocumentCalc.UseMenu
        hMenuSelectNr(5) ' FORMAT
        hMenuSelectNr(3) ' AXIS        
        iCount = hMenuItemGetCount()        
        if (iCount <> 2) then
            warnlog "There should 2 items in the FORMAT/ARRANGEMENT menu but there are " + iCount + " items."
        end if
        
        '/// check if there are 6 items in the FORMAT/AXIS menu.
        printlog "check if there are 6 items in the FORMAT/AXIS menu."
        DocumentCalc.UseMenu
        hMenuSelectNr(5) ' FORMAT
        hMenuSelectNr(5) ' AXIS        
        iCount = hMenuItemGetCount()        
        if (iCount <> 6) then
            warnlog "There should 6 items in the FORMAT/AXIS menu but there are " + iCount + " items."
        end if

        '/// check if there are 7 items in the FORMAT/GRID menu.
        printlog "check if there are 7 items in the FORMAT/GRID menu."
        DocumentCalc.UseMenu
        hMenuSelectNr(5) ' FORMAT
        hMenuSelectNr(6) ' GRID        
        iCount = hMenuItemGetCount()        
        if (iCount <> 7) then
            warnlog "There should 7 items in the FORMAT/GRID menu but there are " + iCount + " items."
        end if
        
        '/// check if there are 6 items in the FORMAT/TITLE menu.
        printlog "check if there are 6 items in the FORMAT/Title menu."
        DocumentCalc.UseMenu
        hMenuSelectNr(5) ' FORMAT
        hMenuSelectNr(4) ' TITLE        
        iCount = hMenuItemGetCount()        
        if (iCount <> 6) then
            warnlog "There should 6 items in the FORMAT/Title menu but there are " + iCount + " items."
        end if


        '/// check if there are 13 items in the TOOLS menu.
        printlog "check if there are 13 items in the TOOLS menu."        
        DocumentCalc.UseMenu 
        hMenuSelectNr(5)        
        iCount = hMenuItemGetCount()
        if (iCount <> 13) then
            warnlog "There should 13 items in the tools menu but there are " + iCount + " items."
        end if
        call hMenuClose()
        
        '/// check if there are 4 items in the TOOLS/MACRO menu.
        printlog "check if there are 4 items in the TOOLS/MACRO menu."        
        DocumentCalc.UseMenu 
        hMenuSelectNr(6)
        hMenuSelectNr(1)        
        iCount = hMenuItemGetCount()
        if (iCount <> 4) then
            warnlog "There should 4 items in the TOOLS/MACRO menu but there are " + iCount + " items."
        end if
        call hMenuClose()
        
        '/// check if there are 5 items in the WINDOW menu.
        printlog "check if there are 5 items in the WINDOW menu."        
        DocumentCalc.UseMenu 
        hMenuSelectNr(7)        
        iCount = hMenuItemGetCount()
        if (iCount <> 5) then
            warnlog "There should 5 items in the WINDOW menu but there are " + iCount + " items."
        end if
        call hMenuClose()
 
        '/// check if there are 5 or 6 items in the HELP menu. Depends on if it's a patched version
        printlog "check if there are 5 or 6 items in the HELP menu. Depends on if it's a patched version"        
        DocumentCalc.UseMenu 
        hMenuSelectNr(8)        
        iCount = hMenuItemGetCount()
        if (iCount <> 6 AND iCount <> 5 ) then
            warnlog "There should 5 OR 6 items in the HELP menu but there are " + iCount + " items."
        end if
        call hMenuClose()        
        call hCloseDocument
    end if
endcase


