'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: c_ooo2x_fixes.inc,v $
'*
'*  $Revision: 1.5 $
'*
'*  last change: $Author: jsi $ $Date: 2007/11/12 17:00:44 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'**
'** owner : joerg.sievers@Sun.COM
'**
'** short description :  Test bug fixes made for StarOffice 8/OpenOffice.org 2.x updates 
'**
'************************************************************************
' **
' #1 i54404_Inseting_TXT_file     'Inserting files with extension TXT in OOo 2.0/SO 8 Calc not possible
' **
'\***********************************************************************

testcase i54404_Inseting_TXT_file
    Dim sTestcasedoc as string
    Dim sCharacterSet as string
    Dim cExpect1 as string
    Dim sNowInA1 as string
    Dim iRound as integer
    Dim iRoundMax as integer
    
    cExpect1 = "This"
    sTestcasedoc = convertpath(gTesttoolpath & "calc\special\input\simpletext_withuppercharext.TXT")
    
    '/// Create a new spreadsheet document
    Call hNewDocument
    '/// Insert / Sheet / FromFile
    InsertSheetFromFile
    Kontext "OeffnenDlg"
    call DialogTest (OeffnenDlg)
    '/// Select <i>gTesttoolpath/calc/special/input/simpletext_withuppercharext.TXT</i>
    Dateiname.SetText sTestcasedoc
    sleep (3)
    '/// Click on INSERT button
    Oeffnen.Click
    sleep (3)
    '/// Text Import dialog occours
    Kontext "TextImport"    
    call DialogTest (TextImport)
    '/// Select in the <i>character set</i> list box to select <b>Unicode UTF-8</b>
    iRoundMax = Zeichensatz.GetItemCount
    for iRound = 1 to iRoundMax
        Zeichensatz.Select(iRound)    
        sCharacterSet = Zeichensatz.GetSelText
        if InStr(sCharacterSet , "UTF-8") > 0 then        
            printlog "Character set has been correctly set to UTF-8 after selecting " & iRound & " entry."
            exit for
        end if
        if iRound = iRoundMax then
            warnlog "The UTF-8 character has not been found after trying all " & iRound & "entries."
            Kontext "TextImport"
            TextImport.Cancel
            sleep(1)
            Kontext "TabelleEinfuegenCalc"
            TabelleEinfuegenCalc.Cancel
            call hCloseDocument
            goto endsub
        end if
    next iRound
    '/// Typing <i>TAB</i>-key on the <i>character set</i> list box to leave the list box
    Zeichensatz.TypeKeys "<TAB>"
    sleep(1)    
    '/// In section fields the <i>column type</i> isn't enabled by default.
    if Typ.IsEnabled = FALSE then
        '/// Typing <i>cursor right</i> in the <i>preview</i> enables the <i>column type</i> list box
        Vorschau.TypeKeys "<RIGHT>" , TRUE
    else
        warnlog "The column type-list box should not be enabled by default but it is."
    end if
    '/// Selecting the second entry for import
    Typ.Select(2)
    '/// Setting <i>spaces</i> as seperator
    Leerzeichen.Check
    '/// Leaving the dialog with OK.    
    TextImport.OK
    '/// Table Insert dialog occours
    Kontext "TabelleEinfuegenCalc"
    Call Dialogtest(TabelleEinfuegenCalc)
    '/// Verify that <i>Before current sheet</i> radio button is checked. If not, check it.
    if Vor.IsChecked = FALSE then
        warnlog "Before current sheet-radio button should be enabled but is not!"
        Vor.Check
    end if    
    '/// Verify that the selected file has 1 sheet for import
    if Auswahl.getItemCount <> 1 then
        warnlog "At least 1 sheet has to be in the document and also in the 'From file' selection box."
    else
        printlog "1 detected sheet in slected file is correct."
    end if
    '/// If The OK-button is enabled, press it. Otherwise could be an issue which should have been fixed sind OOo 2.0.1.
    if TabelleEinfuegenCalc.IsEnabled then
        TabelleEinfuegenCalc.OK
    else
        warnlog " It isn't possible to insert the test document (" & sTestcasedoc & ") into the spreadsheet!"
        TabelleEinfuegenCalc.Cancel
    end if        
    Kontext "DocumentCalc"
    '/// Verify that the first cell (A1) is really only the word 'This'
    sNowInA1 = cZellwert("A1")        
    if sNowInA1 <> cExpect1 then
        warnlog "The first cell in the spreadsheet should be the word 'This' but it is '" & sNowInA1 & "'."
    else
        printlog "The cell value of the call A1 is '" & sNowInA1 & "' as it was expected." 
    end if            
    '/// Close document        
    Call hCloseDocument
endcase
