// $Id: TTFFont.hh 11071 2009-12-30 11:57:08Z m9710797 $

#ifndef TTFFONT_HH
#define TTFFONT_HH

#include "SDLSurfacePtr.hh"
#include "openmsx.hh"
#include <string>

namespace openmsx {

class TTFFont
{
public:
	/** Construct new TTFFont object.
	  * @param font Filename of font (.fft file, possibly (g)zipped).
	  * @param ptSize Point size (based on 72DPI) to load font as.
	  */
	TTFFont(const std::string& font, int ptSize);
	~TTFFont();

	/** Render the given text to a new SDL_Surface.
	  * The text must be UTF-8 encoded.
	  * The result is a 32bpp RGBA SDL_Surface.
	  */
	SDLSurfacePtr render(const std::string& text, byte r, byte g, byte b);

	/** Return the height of the font.
	  * This is the recommended number of pixels between two text lines.
	  */
	unsigned getHeight();

	/** Return the width of the font.
	  * This is the recommended number of pixels between two characters.
	  * This number only makes sense for fixed-width fonts.
	  */
	unsigned getWidth();

private:
	void* font;  // TTF_Font*
};

} // namespace openmsx

#endif
