/*
 * Copyright (c) 1997, 2011, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * (C) Copyright Taligent, Inc. 1996, 1997 - All Rights Reserved
 * (C) Copyright IBM Corp. 1996 - 1998 - All Rights Reserved
 *
 * The original version of this source code and documentation
 * is copyrighted and owned by Taligent, Inc., a wholly-owned
 * subsidiary of IBM. These materials are provided under terms
 * of a License Agreement between Taligent and Sun. This technology
 * is protected by multiple US and International patents.
 *
 * This notice and attribution to Taligent may not be removed.
 * Taligent is a registered trademark of Taligent, Inc.
 *
 */

package sun.util.resources;

public final class TimeZoneNames_ja extends TimeZoneNamesBundle {

    protected final Object[][] getContents() {
        String ACT[] = new String[] {"\u30a2\u30af\u30ec\u6642\u9593", "ACT",
                                     "\u30a2\u30af\u30ec\u590f\u6642\u9593", "ACST"};
        String ADELAIDE[] = new String[] {"\u4e2d\u90e8\u6a19\u6e96\u6642 (\u5357\u30aa\u30fc\u30b9\u30c8\u30e9\u30ea\u30a2)", "CST",
                                          "\u4e2d\u90e8\u590f\u6642\u9593 (\u5357\u30aa\u30fc\u30b9\u30c8\u30e9\u30ea\u30a2)", "CST"};
        String AGT[] = new String[] {"\u30a2\u30eb\u30bc\u30f3\u30c1\u30f3\u6642\u9593", "ART",
                                     "\u30a2\u30eb\u30bc\u30f3\u30c1\u30f3\u590f\u6642\u9593", "ARST"};
        String AKST[] = new String[] {"\u30a2\u30e9\u30b9\u30ab\u6a19\u6e96\u6642", "AKST",
                                      "\u30a2\u30e9\u30b9\u30ab\u590f\u6642\u9593", "AKDT"};
        String AMT[] = new String[] {"\u30a2\u30de\u30be\u30f3\u6642\u9593", "AMT",
                                     "\u30a2\u30de\u30be\u30f3\u590f\u6642\u9593", "AMST"};
        String ARAST[] = new String[] {"\u30a2\u30e9\u30d3\u30a2\u6a19\u6e96\u6642", "AST",
                                       "\u30a2\u30e9\u30d3\u30a2\u590f\u6642\u9593", "ADT"};
        String ARMT[] = new String[] {"\u30a2\u30eb\u30e1\u30cb\u30a2\u6642\u9593", "AMT",
                                      "\u30a2\u30eb\u30e1\u30cb\u30a2\u590f\u6642\u9593", "AMST"};
        String AST[] = new String[] {"\u5927\u897f\u6d0b\u6a19\u6e96\u6642", "AST",
                                     "\u5927\u897f\u6d0b\u590f\u6642\u9593", "ADT"};
        String BDT[] = new String[] {"\u30d0\u30f3\u30b0\u30e9\u30c7\u30b7\u30e5\u6642\u9593", "BDT",
                                     "\u30d0\u30f3\u30b0\u30e9\u30c7\u30b7\u30e5\u590f\u6642\u9593", "BDST"};
        String BRISBANE[] = new String[] {"\u6771\u90e8\u6a19\u6e96\u6642 (\u30af\u30a4\u30fc\u30f3\u30ba\u30e9\u30f3\u30c9)", "EST",
                                          "\u6771\u90e8\u590f\u6642\u9593 (\u30af\u30a4\u30fc\u30f3\u30ba\u30e9\u30f3\u30c9)", "EST"};
        String BROKEN_HILL[] = new String[] {"\u4e2d\u90e8\u6a19\u6e96\u6642 (\u5357\u30aa\u30fc\u30b9\u30c8\u30e9\u30ea\u30a2/\u30cb\u30e5\u30fc\u30b5\u30a6\u30b9\u30a6\u30a7\u30fc\u30eb\u30ba)", "CST",
                                             "\u4e2d\u90e8\u590f\u6642\u9593 (\u5357\u30aa\u30fc\u30b9\u30c8\u30e9\u30ea\u30a2/\u30cb\u30e5\u30fc\u30b5\u30a6\u30b9\u30a6\u30a7\u30fc\u30eb\u30ba)", "CST"};
        String BRT[] = new String[] {"\u30d6\u30e9\u30b8\u30eb\u6642\u9593", "BRT",
                                     "\u30d6\u30e9\u30b8\u30eb\u590f\u6642\u9593", "BRST"};
        String BTT[] = new String[] {"\u30d6\u30fc\u30bf\u30f3\u6642\u9593", "BTT",
                                     "\u30d6\u30fc\u30bf\u30f3\u590f\u6642\u9593", "BTST"};
        String CAT[] = new String[] {"\u4e2d\u90e8\u30a2\u30d5\u30ea\u30ab\u6642\u9593", "CAT",
                                     "\u4e2d\u90e8\u30a2\u30d5\u30ea\u30ab\u590f\u6642\u9593", "CAST"};
        String CET[] = new String[] {"\u4e2d\u90e8\u30e8\u30fc\u30ed\u30c3\u30d1\u6642\u9593", "CET",
                                     "\u4e2d\u90e8\u30e8\u30fc\u30ed\u30c3\u30d1\u590f\u6642\u9593", "CEST"};
        String CHAST[] = new String[] {"\u30c1\u30e3\u30bf\u30e0\u6a19\u6e96\u6642", "CHAST",
                                       "\u30c1\u30e3\u30bf\u30e0\u590f\u6642\u9593", "CHADT"};
        String CHUT[] = new String[] {"Chuuk Time", "CHUT",
                                      "Chuuk Summer Time", "CHUST"};
        String CIT[] = new String[] {"\u4e2d\u592e\u30a4\u30f3\u30c9\u30cd\u30b7\u30a2\u6642\u9593", "CIT",
                                     "\u4e2d\u592e\u30a4\u30f3\u30c9\u30cd\u30b7\u30a2\u590f\u6642\u9593", "CIST"};
        String CLT[] = new String[] {"\u30c1\u30ea\u6642\u9593", "CLT",
                                     "\u30c1\u30ea\u590f\u6642\u9593", "CLST"};
        String CST[] = new String[] {"\u4e2d\u90e8\u6a19\u6e96\u6642", "CST",
                                     "\u4e2d\u90e8\u590f\u6642\u9593", "CDT"};
        String CTT[] = new String[] {"\u4e2d\u56fd\u6a19\u6e96\u6642", "CST",
                                     "\u4e2d\u56fd\u590f\u6642\u9593", "CDT"};
        String CUBA[] = new String[] {"\u30ad\u30e5\u30fc\u30d0\u6a19\u6e96\u6642", "CST",
                                      "\u30ad\u30e5\u30fc\u30d0\u590f\u6642\u9593", "CDT"};
        String DARWIN[] = new String[] {"\u4e2d\u90e8\u6a19\u6e96\u6642 (\u30ce\u30fc\u30b6\u30f3\u30c6\u30ea\u30c8\u30ea\u30fc)", "CST",
                                        "\u4e2d\u90e8\u590f\u6642\u9593 (\u30ce\u30fc\u30b6\u30f3\u30c6\u30ea\u30c8\u30ea\u30fc)", "CST"};
        String DUBLIN[] = new String[] {"\u30b0\u30ea\u30cb\u30c3\u30b8\u6a19\u6e96\u6642", "GMT",
                                        "\u30a2\u30a4\u30eb\u30e9\u30f3\u30c9\u590f\u6642\u9593", "IST"};
        String EAT[] = new String[] {"\u6771\u30a2\u30d5\u30ea\u30ab\u6642\u9593", "EAT",
                                     "\u6771\u30a2\u30d5\u30ea\u30ab\u590f\u6642\u9593", "EAST"};
        String EASTER[] = new String[] {"\u30a4\u30fc\u30b9\u30bf\u30fc\u5cf6\u6642\u9593", "EAST",
                                        "\u30a4\u30fc\u30b9\u30bf\u30fc\u5cf6\u590f\u6642\u9593", "EASST"};
        String EET[] = new String[] {"\u6771\u30e8\u30fc\u30ed\u30c3\u30d1\u6642\u9593", "EET",
                                     "\u6771\u30e8\u30fc\u30ed\u30c3\u30d1\u590f\u6642\u9593", "EEST"};
        String EGT[] = new String[] {"\u6771\u30b0\u30ea\u30fc\u30f3\u30e9\u30f3\u30c9\u6642\u9593", "EGT",
                                     "\u6771\u30b0\u30ea\u30fc\u30f3\u30e9\u30f3\u30c9\u590f\u6642\u9593", "EGST"};
        String EST[] = new String[] {"\u6771\u90e8\u6a19\u6e96\u6642", "EST",
                                     "\u6771\u90e8\u590f\u6642\u9593", "EDT"};
        String EST_NSW[] = new String[] {"\u6771\u90e8\u6a19\u6e96\u6642 (\u30cb\u30e5\u30fc\u30b5\u30a6\u30b9\u30a6\u30a7\u30fc\u30eb\u30ba)", "EST",
                                         "\u6771\u90e8\u590f\u6642\u9593 (\u30cb\u30e5\u30fc\u30b5\u30a6\u30b9\u30a6\u30a7\u30fc\u30eb\u30ba)", "EST"};
        String FET[] = new String[] {"Further-eastern European Time", "FET",
                                     "Further-eastern European Summer Time", "FEST"};
        String GHMT[] = new String[] {"\u30ac\u30fc\u30ca\u6a19\u6e96\u6642", "GMT",
                                     "\u30ac\u30fc\u30ca\u590f\u6642\u9593", "GHST"};
        String GAMBIER[] =  new String[] {"\u30ac\u30f3\u30d3\u30a2\u6642\u9593", "GAMT",
                                          "\u30ac\u30f3\u30d3\u30a2\u590f\u6642\u9593", "GAMST"};
        String GMT[] = new String[] {"\u30b0\u30ea\u30cb\u30c3\u30b8\u6a19\u6e96\u6642", "GMT",
                                     "\u30b0\u30ea\u30cb\u30c3\u30b8\u6a19\u6e96\u6642", "GMT"};
        String GMTBST[] = new String[] {"\u30b0\u30ea\u30cb\u30c3\u30b8\u6a19\u6e96\u6642", "GMT",
                                        "\u82f1\u56fd\u590f\u6642\u9593", "BST"};
        String GST[] = new String[] {"\u6e7e\u5cb8\u6a19\u6e96\u6642", "GST",
                                     "\u6e7e\u5cb8\u590f\u6642\u9593", "GDT"};
        String HAST[] = new String[] {"\u30cf\u30ef\u30a4 - \u30a2\u30ea\u30e5\u30fc\u30b7\u30e3\u30f3\u6a19\u6e96\u6642", "HAST",
                                      "\u30cf\u30ef\u30a4 - \u30a2\u30ea\u30e5\u30fc\u30b7\u30e3\u30f3\u590f\u6642\u9593", "HADT"};
        String HKT[] =  new String[] {"\u9999\u6e2f\u6642\u9593", "HKT",
                                      "\u9999\u6e2f\u590f\u6642\u9593", "HKST"};
        String HST[] = new String[] {"\u30cf\u30ef\u30a4\u6a19\u6e96\u6642", "HST",
                                     "\u30cf\u30ef\u30a4\u590f\u6642\u9593", "HDT"};
        String ICT[] = new String[] {"\u30a4\u30f3\u30c9\u30b7\u30ca\u6642\u9593", "ICT",
                                     "\u30a4\u30f3\u30c9\u30b7\u30ca\u590f\u6642\u9593", "ICST"};
        String IRT[] = new String[] {"\u30a4\u30e9\u30f3\u6a19\u6e96\u6642", "IRST",
                                     "\u30a4\u30e9\u30f3\u590f\u6642\u9593", "IRDT"};
        String ISRAEL[] = new String[] {"\u30a4\u30b9\u30e9\u30a8\u30eb\u6a19\u6e96\u6642", "IST",
                                        "\u30a4\u30b9\u30e9\u30a8\u30eb\u590f\u6642\u9593", "IDT"};
        String IST[] = new String[] {"\u30a4\u30f3\u30c9\u6a19\u6e96\u6642", "IST",
                                     "\u30a4\u30f3\u30c9\u590f\u6642\u9593", "IDT"};
        String JST[] = new String[] {"\u65e5\u672c\u6a19\u6e96\u6642", "JST",
                                     "\u65e5\u672c\u590f\u6642\u9593", "JDT"};
        String KST[] = new String[] {"\u97d3\u56fd\u6a19\u6e96\u6642", "KST",
                                     "\u97d3\u56fd\u590f\u6642\u9593", "KDT"};
        String LORD_HOWE[] = new String[] {"\u30ed\u30fc\u30c9\u30cf\u30a6\u5cf6\u6a19\u6e96\u6642", "LHST",
                                           "\u30ed\u30fc\u30c9\u30cf\u30a6\u5cf6\u590f\u6642\u9593", "LHST"};
        String MHT[] = new String[] {"\u30de\u30fc\u30b7\u30e3\u30eb\u5cf6\u6642\u9593", "MHT",
                                     "\u30de\u30fc\u30b7\u30e3\u30eb\u5cf6\u590f\u6642\u9593", "MHST"};
        String MSK[] = new String[] {"\u30e2\u30b9\u30af\u30ef\u6a19\u6e96\u6642", "MSK",
                                     "\u30e2\u30b9\u30af\u30ef\u590f\u6642\u9593", "MSD"};
        String MST[] = new String[] {"\u5c71\u5730\u6a19\u6e96\u6642", "MST",
                                     "\u5c71\u5730\u590f\u6642\u9593", "MDT"};
        String MYT[] = new String[] {"\u30de\u30ec\u30fc\u30b7\u30a2\u6642\u9593", "MYT",
                                     "\u30de\u30ec\u30fc\u30b7\u30a2\u590f\u6642\u9593", "MYST"};
        String NORONHA[] = new String[] {"\u30d5\u30a7\u30eb\u30ca\u30f3\u30c9\u30fb\u30c7\u30fb\u30ce\u30ed\u30fc\u30cb\u30e3\u6642\u9593", "FNT",
                                         "\u30d5\u30a7\u30eb\u30ca\u30f3\u30c9\u30fb\u30c7\u30fb\u30ce\u30ed\u30fc\u30cb\u30e3\u590f\u6642\u9593", "FNST"};
        String NOVT[] = new String[] {"\u30ce\u30dc\u30b7\u30d3\u30eb\u30b9\u30af\u6642\u9593", "NOVT",
                                      "\u30ce\u30dc\u30b7\u30d3\u30eb\u30b9\u30af\u590f\u6642\u9593", "NOVST"};
        String NPT[] = new String[] {"\u30cd\u30d1\u30fc\u30eb\u6642\u9593", "NPT",
                                      "\u30cd\u30d1\u30fc\u30eb\u590f\u6642\u9593", "NPST"};
        String NST[] = new String[] {"\u30cb\u30e5\u30fc\u30d5\u30a1\u30f3\u30c9\u30e9\u30f3\u30c9\u6a19\u6e96\u6642", "NST",
                                     "\u30cb\u30e5\u30fc\u30d5\u30a1\u30f3\u30c9\u30e9\u30f3\u30c9\u590f\u6642\u9593", "NDT"};
        String NZST[] = new String[] {"\u30cb\u30e5\u30fc\u30b8\u30fc\u30e9\u30f3\u30c9\u6a19\u6e96\u6642", "NZST",
                                      "\u30cb\u30e5\u30fc\u30b8\u30fc\u30e9\u30f3\u30c9\u590f\u6642\u9593", "NZDT"};
        String PITCAIRN[] = new String[] {"\u30d4\u30c8\u30b1\u30eb\u30f3\u5cf6\u6a19\u6e96\u6642", "PST",
                                          "\u30d4\u30c8\u30b1\u30eb\u30f3\u5cf6\u590f\u6642\u9593", "PDT"};
        String PKT[] = new String[] {"\u30d1\u30ad\u30b9\u30bf\u30f3\u6642\u9593", "PKT",
                                     "\u30d1\u30ad\u30b9\u30bf\u30f3\u590f\u6642\u9593", "PKST"};
        String PONT[] = new String[] {"Pohnpei Time", "PONT",
                                      "Pohnpei Summer Time", "PONST"};
        String PST[] = new String[] {"\u592a\u5e73\u6d0b\u6a19\u6e96\u6642", "PST",
                                     "\u592a\u5e73\u6d0b\u590f\u6642\u9593", "PDT"};
        String SAST[] = new String[] {"\u5357\u30a2\u30d5\u30ea\u30ab\u6a19\u6e96\u6642", "SAST",
                                      "\u5357\u30a2\u30d5\u30ea\u30ab\u590f\u6642\u9593", "SAST"};
        String SBT[] = new String[] {"\u30bd\u30ed\u30e2\u30f3\u8af8\u5cf6\u6642\u9593", "SBT",
                                     "\u30bd\u30ed\u30e2\u30f3\u8af8\u5cf6\u590f\u6642\u9593", "SBST"};
        String SGT[] = new String[] {"\u30b7\u30f3\u30ac\u30dd\u30fc\u30eb\u6642\u9593", "SGT",
                                     "\u30b7\u30f3\u30ac\u30dd\u30fc\u30eb\u590f\u6642\u9593", "SGST"};
        String SLST[] = new String[] {"\u30b0\u30ea\u30cb\u30c3\u30b8\u6a19\u6e96\u6642", "GMT",
                                      "\u30b7\u30a8\u30e9\u30ec\u30aa\u30cd\u590f\u6642\u9593", "SLST"};
        String TASMANIA[] = new String[] {"\u6771\u90e8\u6a19\u6e96\u6642 (\u30bf\u30b9\u30de\u30cb\u30a2)", "EST",
                                          "\u6771\u90e8\u590f\u6642\u9593 (\u30bf\u30b9\u30de\u30cb\u30a2)", "EST"};
        String TMT[] = new String[] {"\u30c8\u30eb\u30af\u30e1\u30cb\u30b9\u30bf\u30f3\u6642\u9593", "TMT",
                                     "\u30c8\u30eb\u30af\u30e1\u30cb\u30b9\u30bf\u30f3\u590f\u6642\u9593", "TMST"};
        String ULAT[]= new String[] {"\u30a6\u30e9\u30fc\u30f3\u30d0\u30fc\u30c8\u30eb\u6642\u9593", "ULAT",
                                     "\u30a6\u30e9\u30fc\u30f3\u30d0\u30fc\u30c8\u30eb\u590f\u6642\u9593", "ULAST"};
        String WART[] = new String[] {"\u897f\u30a2\u30eb\u30bc\u30f3\u30c1\u30f3\u6642\u9593", "WART",
                                      "\u897f\u30a2\u30eb\u30bc\u30f3\u30c1\u30f3\u590f\u6642\u9593", "WARST"};
        String WAT[] = new String[] {"\u897f\u30a2\u30d5\u30ea\u30ab\u6642\u9593", "WAT",
                                     "\u897f\u30a2\u30d5\u30ea\u30ab\u590f\u6642\u9593", "WAST"};
        String WET[] = new String[] {"\u897f\u30e8\u30fc\u30ed\u30c3\u30d1\u6642\u9593", "WET",
                                     "\u897f\u30e8\u30fc\u30ed\u30c3\u30d1\u590f\u6642\u9593", "WEST"};
        String WIT[] = new String[] {"\u897f\u30a4\u30f3\u30c9\u30cd\u30b7\u30a2\u6642\u9593", "WIT",
                                     "\u897f\u30a4\u30f3\u30c9\u30cd\u30b7\u30a2\u590f\u6642\u9593", "WIST"};
        String WST_AUS[] = new String[] {"\u897f\u90e8\u6a19\u6e96\u6642 (\u30aa\u30fc\u30b9\u30c8\u30e9\u30ea\u30a2)", "WST",
                                         "\u897f\u90e8\u590f\u6642\u9593 (\u30aa\u30fc\u30b9\u30c8\u30e9\u30ea\u30a2)", "WST"};
        String SAMOA[] = new String[] {"\u30b5\u30e2\u30a2\u6a19\u6e96\u6642", "SST",
                                       "\u30b5\u30e2\u30a2\u590f\u6642\u9593", "SDT"};
        String WST_SAMOA[] = new String[] {"\u897f\u30b5\u30e2\u30a2\u6642\u9593", "WST",
                                           "\u897f\u30b5\u30e2\u30a2\u590f\u6642\u9593", "WSDT"};
        String ChST[] = new String[] {"\u30b0\u30a2\u30e0\u6a19\u6e96\u6642", "ChST",
                                      "\u30b0\u30a2\u30e0\u590f\u6642\u9593", "ChDT"};
        String VICTORIA[] = new String[] {"\u6771\u90e8\u6a19\u6e96\u6642 (\u30d3\u30af\u30c8\u30ea\u30a2)", "EST",
                                          "\u6771\u90e8\u590f\u6642\u9593 (\u30d3\u30af\u30c8\u30ea\u30a2)", "EST"};
        String UTC[] = new String[] {"\u5354\u5b9a\u4e16\u754c\u6642", "UTC",
                                     "\u5354\u5b9a\u4e16\u754c\u6642", "UTC"};
        String UZT[] = new String[] {"\u30a6\u30ba\u30d9\u30ad\u30b9\u30bf\u30f3\u6642\u9593", "UZT",
                                     "\u30a6\u30ba\u30d9\u30ad\u30b9\u30bf\u30f3\u590f\u6642\u9593", "UZST"};

        return new Object[][] {
            {"America/Los_Angeles", PST},
            {"PST", PST},
            {"America/Denver", MST},
            {"MST", MST},
            {"America/Phoenix", MST},
            {"PNT", MST},
            {"America/Chicago", CST},
            {"CST", CST},
            {"America/New_York", EST},
            {"EST", EST},
            {"America/Indianapolis", EST},
            {"IET", EST},
            {"Pacific/Honolulu", HST},
            {"HST", HST},
            {"America/Anchorage", AKST},
            {"AST", AKST},
            {"America/Halifax", AST},
            {"America/Sitka", AKST},
            {"America/St_Johns", NST},
            {"CNT", NST},
            {"Europe/Paris", CET},
            {"ECT", CET},
            {"GMT", GMT},
            {"Africa/Casablanca", WET},
            {"Asia/Jerusalem", ISRAEL},
            {"Asia/Tokyo", JST},
            {"JST", JST},
            {"Europe/Bucharest", EET},
            {"Asia/Shanghai", CTT},
            {"CTT", CTT},
            /* Don't change the order of the above zones
             * to keep compatibility with the previous version.
             */

            {"ACT", DARWIN},
            {"AET", EST_NSW},
            {"AGT", AGT},
            {"ART", EET},
            {"Africa/Abidjan", GMT},
            {"Africa/Accra", GHMT},
            {"Africa/Addis_Ababa", EAT},
            {"Africa/Algiers", CET},
            {"Africa/Asmara", EAT},
            {"Africa/Asmera", EAT},
            {"Africa/Bamako", GMT},
            {"Africa/Bangui", WAT},
            {"Africa/Banjul", GMT},
            {"Africa/Bissau", GMT},
            {"Africa/Blantyre", CAT},
            {"Africa/Brazzaville", WAT},
            {"Africa/Bujumbura", CAT},
            {"Africa/Cairo", EET},
            {"Africa/Ceuta", CET},
            {"Africa/Conakry", GMT},
            {"Africa/Dakar", GMT},
            {"Africa/Dar_es_Salaam", EAT},
            {"Africa/Djibouti", EAT},
            {"Africa/Douala", WAT},
            {"Africa/El_Aaiun", WET},
            {"Africa/Freetown", SLST},
            {"Africa/Gaborone", CAT},
            {"Africa/Harare", CAT},
            {"Africa/Johannesburg", SAST},
            {"Africa/Juba", EAT},
            {"Africa/Kampala", EAT},
            {"Africa/Khartoum", EAT},
            {"Africa/Kigali", CAT},
            {"Africa/Kinshasa", WAT},
            {"Africa/Lagos", WAT},
            {"Africa/Libreville", WAT},
            {"Africa/Lome", GMT},
            {"Africa/Luanda", WAT},
            {"Africa/Lubumbashi", CAT},
            {"Africa/Lusaka", CAT},
            {"Africa/Malabo", WAT},
            {"Africa/Maputo", CAT},
            {"Africa/Maseru", SAST},
            {"Africa/Mbabane", SAST},
            {"Africa/Mogadishu", EAT},
            {"Africa/Monrovia", GMT},
            {"Africa/Nairobi", EAT},
            {"Africa/Ndjamena", WAT},
            {"Africa/Niamey", WAT},
            {"Africa/Nouakchott", GMT},
            {"Africa/Ouagadougou", GMT},
            {"Africa/Porto-Novo", WAT},
            {"Africa/Sao_Tome", GMT},
            {"Africa/Timbuktu", GMT},
            {"Africa/Tripoli", EET},
            {"Africa/Tunis", CET},
            {"Africa/Windhoek", WAT},
            {"America/Adak", HAST},
            {"America/Anguilla", AST},
            {"America/Antigua", AST},
            {"America/Araguaina", BRT},
            {"America/Argentina/Buenos_Aires", AGT},
            {"America/Argentina/Catamarca", AGT},
            {"America/Argentina/ComodRivadavia", AGT},
            {"America/Argentina/Cordoba", AGT},
            {"America/Argentina/Jujuy", AGT},
            {"America/Argentina/La_Rioja", AGT},
            {"America/Argentina/Mendoza", AGT},
            {"America/Argentina/Rio_Gallegos", AGT},
            {"America/Argentina/Salta", AGT},
            {"America/Argentina/San_Juan", AGT},
            {"America/Argentina/San_Luis", WART},
            {"America/Argentina/Tucuman", AGT},
            {"America/Argentina/Ushuaia", AGT},
            {"America/Aruba", AST},
            {"America/Asuncion", new String[] {"\u30d1\u30e9\u30b0\u30a2\u30a4\u6642\u9593", "PYT",
                                               "\u30d1\u30e9\u30b0\u30a2\u30a4\u590f\u6642\u9593", "PYST"}},
            {"America/Atikokan", EST},
            {"America/Atka", HAST},
            {"America/Bahia", BRT},
            {"America/Bahia_Banderas", CST},
            {"America/Barbados", AST},
            {"America/Belem", BRT},
            {"America/Belize", CST},
            {"America/Blanc-Sablon", AST},
            {"America/Boa_Vista", AMT},
            {"America/Bogota", new String[] {"\u30b3\u30ed\u30f3\u30d3\u30a2\u6642\u9593", "COT",
                                             "\u30b3\u30ed\u30f3\u30d3\u30a2\u590f\u6642\u9593", "COST"}},
            {"America/Boise", MST},
            {"America/Buenos_Aires", AGT},
            {"America/Cambridge_Bay", MST},
            {"America/Campo_Grande", AMT},
            {"America/Cancun", CST},
            {"America/Caracas", new String[] {"\u30d9\u30cd\u30ba\u30a8\u30e9\u6642\u9593", "VET",
                                              "\u30d9\u30cd\u30ba\u30a8\u30e9\u590f\u6642\u9593", "VEST"}},
            {"America/Catamarca", AGT},
            {"America/Cayenne", new String[] {"\u4ecf\u9818\u30ae\u30a2\u30ca\u6642\u9593", "GFT",
                                              "\u4ecf\u9818\u30ae\u30a2\u30ca\u590f\u6642\u9593", "GFST"}},
            {"America/Cayman", EST},
            {"America/Chihuahua", MST},
            {"America/Coral_Harbour", EST},
            {"America/Cordoba", AGT},
            {"America/Costa_Rica", CST},
            {"America/Cuiaba", AMT},
            {"America/Curacao", AST},
            {"America/Danmarkshavn", GMT},
            {"America/Dawson", PST},
            {"America/Dawson_Creek", MST},
            {"America/Detroit", EST},
            {"America/Dominica", AST},
            {"America/Edmonton", MST},
            {"America/Eirunepe", AMT},
            {"America/El_Salvador", CST},
            {"America/Ensenada", PST},
            {"America/Fort_Wayne", EST},
            {"America/Fortaleza", BRT},
            {"America/Glace_Bay", AST},
            {"America/Godthab", new String[] {"\u897f\u30b0\u30ea\u30fc\u30f3\u30e9\u30f3\u30c9\u6642\u9593", "WGT",
                                              "\u897f\u30b0\u30ea\u30fc\u30f3\u30e9\u30f3\u30c9\u590f\u6642\u9593", "WGST"}},
            {"America/Goose_Bay", AST},
            {"America/Grand_Turk", EST},
            {"America/Grenada", AST},
            {"America/Guadeloupe", AST},
            {"America/Guatemala", CST},
            {"America/Guayaquil", new String[] {"\u30a8\u30af\u30a2\u30c9\u30eb\u6642\u9593", "ECT",
                                                "\u30a8\u30af\u30a2\u30c9\u30eb\u590f\u6642\u9593", "ECST"}},
            {"America/Guyana", new String[] {"\u30ac\u30a4\u30a2\u30ca\u6642\u9593", "GYT",
                                             "\u30ac\u30a4\u30a2\u30ca\u590f\u6642\u9593", "GYST"}},
            {"America/Havana", CUBA},
            {"America/Hermosillo", MST},
            {"America/Indiana/Indianapolis", EST},
            {"America/Indiana/Knox", CST},
            {"America/Indiana/Marengo", EST},
            {"America/Indiana/Petersburg", EST},
            {"America/Indiana/Tell_City", CST},
            {"America/Indiana/Vevay", EST},
            {"America/Indiana/Vincennes", EST},
            {"America/Indiana/Winamac", EST},
            {"America/Inuvik", MST},
            {"America/Iqaluit", EST},
            {"America/Jamaica", EST},
            {"America/Jujuy", AGT},
            {"America/Juneau", AKST},
            {"America/Kentucky/Louisville", EST},
            {"America/Kentucky/Monticello", EST},
            {"America/Knox_IN", CST},
            {"America/Kralendijk", AST},
            {"America/La_Paz", new String[] {"\u30dc\u30ea\u30d3\u30a2\u6642\u9593", "BOT",
                                             "\u30dc\u30ea\u30d3\u30a2\u590f\u6642\u9593", "BOST"}},
            {"America/Lima", new String[] {"\u30da\u30eb\u30fc\u6642\u9593", "PET",
                                           "\u30da\u30eb\u30fc\u590f\u6642\u9593", "PEST"}},
            {"America/Louisville", EST},
            {"America/Lower_Princes", AST},
            {"America/Maceio", BRT},
            {"America/Managua", CST},
            {"America/Manaus", AMT},
            {"America/Marigot", AST},
            {"America/Martinique", AST},
            {"America/Matamoros", CST},
            {"America/Mazatlan", MST},
            {"America/Mendoza", AGT},
            {"America/Menominee", CST},
            {"America/Merida", CST},
            {"America/Metlakatla", new String[] {"Metlakatla Standard Time", "MeST",
                                                 "Metlakatla Daylight Time", "MeDT"}},
            {"America/Mexico_City", CST},
            {"America/Miquelon", new String[] {"\u30b5\u30f3\u30d4\u30a8\u30fc\u30eb\u30fb\u30df\u30af\u30ed\u30f3\u8af8\u5cf6\u6a19\u6e96\u6642", "PMST",
                                               "\u30b5\u30f3\u30d4\u30a8\u30fc\u30eb\u30fb\u30df\u30af\u30ed\u30f3\u8af8\u5cf6\u590f\u6642\u9593", "PMDT"}},
            {"America/Moncton", AST},
            {"America/Montevideo", new String[] {"\u30a6\u30eb\u30b0\u30a2\u30a4\u6642\u9593", "UYT",
                                                 "\u30a6\u30eb\u30b0\u30a2\u30a4\u590f\u6642\u9593", "UYST"}},
            {"America/Monterrey", CST},
            {"America/Montreal", EST},
            {"America/Montserrat", AST},
            {"America/Nassau", EST},
            {"America/Nipigon", EST},
            {"America/Nome", AKST},
            {"America/Noronha", NORONHA},
            {"America/North_Dakota/Beulah", CST},
            {"America/North_Dakota/Center", CST},
            {"America/North_Dakota/New_Salem", CST},
            {"America/Ojinaga", MST},
            {"America/Panama", EST},
            {"America/Pangnirtung", EST},
            {"America/Paramaribo", new String[] {"\u30b9\u30ea\u30ca\u30e0\u6642\u9593", "SRT",
                                                 "\u30b9\u30ea\u30ca\u30e0\u590f\u6642\u9593", "SRST"}},
            {"America/Port-au-Prince", EST},
            {"America/Port_of_Spain", AST},
            {"America/Porto_Acre", AMT},
            {"America/Porto_Velho", AMT},
            {"America/Puerto_Rico", AST},
            {"America/Rainy_River", CST},
            {"America/Rankin_Inlet", CST},
            {"America/Recife", BRT},
            {"America/Regina", CST},
            {"America/Resolute", CST},
            {"America/Rio_Branco", AMT},
            {"America/Rosario", AGT},
            {"America/Santa_Isabel", PST},
            {"America/Santarem", BRT},
            {"America/Santiago", CLT},
            {"America/Santo_Domingo", AST},
            {"America/Sao_Paulo", BRT},
            {"America/Scoresbysund", EGT},
            {"America/Shiprock", MST},
            {"America/St_Barthelemy", AST},
            {"America/St_Kitts", AST},
            {"America/St_Lucia", AST},
            {"America/St_Thomas", AST},
            {"America/St_Vincent", AST},
            {"America/Swift_Current", CST},
            {"America/Tegucigalpa", CST},
            {"America/Thule", AST},
            {"America/Thunder_Bay", EST},
            {"America/Tijuana", PST},
            {"America/Toronto", EST},
            {"America/Tortola", AST},
            {"America/Vancouver", PST},
            {"America/Virgin", AST},
            {"America/Whitehorse", PST},
            {"America/Winnipeg", CST},
            {"America/Yakutat", AKST},
            {"America/Yellowknife", MST},
            {"Antarctica/Casey", WST_AUS},
            {"Antarctica/Davis", new String[] {"\u30c7\u30a4\u30d3\u30b9\u6642\u9593", "DAVT",
                                               "\u30c7\u30a4\u30d3\u30b9\u590f\u6642\u9593", "DAVST"}},
            {"Antarctica/DumontDUrville", new String[] {"\u30c7\u30e5\u30e2\u30f3\u30c7\u30e5\u30eb\u30f4\u30a3\u30eb\u6642\u9593", "DDUT",
                                                        "\u30c7\u30e5\u30e2\u30f3\u30c7\u30e5\u30eb\u30f4\u30a3\u30eb\u590f\u6642\u9593", "DDUST"}},
            {"Antarctica/Macquarie", new String[] {"Macquarie Island Time", "MIST",
                                                   "Macquarie Island Summer Time", "MIST"}},
            {"Antarctica/Mawson", new String[] {"\u30e2\u30fc\u30bd\u30f3\u6642\u9593", "MAWT",
                                                "\u30e2\u30fc\u30bd\u30f3\u590f\u6642\u9593", "MAWST"}},
            {"Antarctica/McMurdo", NZST},
            {"Antarctica/Palmer", CLT},
            {"Antarctica/Rothera", new String[] {"\u30ed\u30bc\u30e9\u6642\u9593", "ROTT",
                                                 "\u30ed\u30bc\u30e9\u590f\u6642\u9593", "ROTST"}},
            {"Antarctica/South_Pole", NZST},
            {"Antarctica/Syowa", new String[] {"\u662d\u548c\u57fa\u5730\u6642\u9593", "SYOT",
                                               "\u662d\u548c\u57fa\u5730\u590f\u6642\u9593", "SYOST"}},
            {"Antarctica/Vostok", new String[] {"\u30dc\u30b9\u30c8\u30fc\u30af\u57fa\u5730\u6642\u9593", "VOST",
                                                "\u30dc\u30b9\u30c8\u30fc\u30af\u57fa\u5730\u590f\u6642\u9593", "VOSST"}},
            {"Arctic/Longyearbyen", CET},
            {"Asia/Aden", ARAST},
            {"Asia/Almaty", new String[] {"\u30a2\u30eb\u30de\u30a2\u30bf\u6642\u9593", "ALMT",
                                          "\u30a2\u30eb\u30de\u30a2\u30bf\u590f\u6642\u9593", "ALMST"}},
            {"Asia/Amman", EET},
            {"Asia/Anadyr", new String[] {"\u30a2\u30ca\u30c9\u30a5\u30a4\u30ea\u6642\u9593", "ANAT",
                                          "\u30a2\u30ca\u30c9\u30a5\u30a4\u30ea\u590f\u6642\u9593", "ANAST"}},
            {"Asia/Aqtau", new String[] {"\u30a2\u30af\u30bf\u30a6\u6642\u9593", "AQTT",
                                         "\u30a2\u30af\u30bf\u30a6\u590f\u6642\u9593", "AQTST"}},
            {"Asia/Aqtobe", new String[] {"\u30a2\u30af\u30c8\u30d9\u6642\u9593", "AQTT",
                                          "\u30a2\u30af\u30c8\u30d9\u590f\u6642\u9593", "AQTST"}},
            {"Asia/Ashgabat", TMT},
            {"Asia/Ashkhabad", TMT},
            {"Asia/Baghdad", ARAST},
            {"Asia/Bahrain", ARAST},
            {"Asia/Baku", new String[] {"\u30a2\u30bc\u30eb\u30d0\u30a4\u30b8\u30e3\u30f3\u6642\u9593", "AZT",
                                        "\u30a2\u30bc\u30eb\u30d0\u30a4\u30b8\u30e3\u30f3\u590f\u6642\u9593", "AZST"}},
            {"Asia/Bangkok", ICT},
            {"Asia/Beirut", EET},
            {"Asia/Bishkek", new String[] {"\u30ad\u30eb\u30ae\u30b9\u30bf\u30f3\u6642\u9593", "KGT",
                                           "\u30ad\u30eb\u30ae\u30b9\u30bf\u30f3\u590f\u6642\u9593", "KGST"}},
            {"Asia/Brunei", new String[] {"\u30d6\u30eb\u30cd\u30a4\u6642\u9593", "BNT",
                                          "\u30d6\u30eb\u30cd\u30a4\u590f\u6642\u9593", "BNST"}},
            {"Asia/Calcutta", IST},
            {"Asia/Choibalsan", new String[] {"\u30c1\u30e7\u30a4\u30d0\u30eb\u30b5\u30f3\u6642\u9593", "CHOT",
                                              "\u30c1\u30e7\u30a4\u30d0\u30eb\u30b5\u30f3\u590f\u6642\u9593", "CHOST"}},
            {"Asia/Chongqing", CTT},
            {"Asia/Chungking", CTT},
            {"Asia/Colombo", IST},
            {"Asia/Dacca", BDT},
            {"Asia/Dhaka", BDT},
            {"Asia/Dili", new String[] {"\u6771\u30c6\u30a3\u30e2\u30fc\u30eb\u6642\u9593", "TLT",
                                        "\u6771\u30c6\u30a3\u30e2\u30fc\u30eb\u590f\u6642\u9593", "TLST"}},
            {"Asia/Damascus", EET},
            {"Asia/Dubai", GST},
            {"Asia/Dushanbe", new String[] {"\u30bf\u30b8\u30ad\u30b9\u30bf\u30f3\u6642\u9593", "TJT",
                                            "\u30bf\u30b8\u30ad\u30b9\u30bf\u30f3\u590f\u6642\u9593", "TJST"}},
            {"Asia/Gaza", EET},
            {"Asia/Harbin", CTT},
            {"Asia/Hebron", EET},
            {"Asia/Ho_Chi_Minh", ICT},
            {"Asia/Hong_Kong", HKT},
            {"Asia/Hovd", new String[] {"\u30db\u30d6\u30c9\u6642\u9593", "HOVT",
                                        "\u30db\u30d6\u30c9\u590f\u6642\u9593", "HOVST"}},
            {"Asia/Irkutsk", new String[] {"\u30a4\u30eb\u30af\u30fc\u30c4\u30af\u6642\u9593", "IRKT",
                                           "\u30a4\u30eb\u30af\u30fc\u30c4\u30af\u590f\u6642\u9593", "IRKST"}},
            {"Asia/Istanbul", EET},
            {"Asia/Jakarta", WIT},
            {"Asia/Jayapura", new String[] {"\u6771\u30a4\u30f3\u30c9\u30cd\u30b7\u30a2\u6642\u9593", "EIT",
                                            "\u6771\u30a4\u30f3\u30c9\u30cd\u30b7\u30a2\u590f\u6642\u9593", "EIST" }},
            {"Asia/Kabul", new String[] {"\u30a2\u30d5\u30ac\u30cb\u30b9\u30bf\u30f3\u6642\u9593", "AFT",
                                         "\u30a2\u30d5\u30ac\u30cb\u30b9\u30bf\u30f3\u590f\u6642\u9593", "AFST"}},
            {"Asia/Kamchatka", new String[] {"\u30da\u30c8\u30ed\u30d1\u30d6\u30ed\u30d5\u30b9\u30af\u30ab\u30e0\u30c1\u30e3\u30c4\u30ad\u30fc\u6642\u9593", "PETT",
                                             "\u30da\u30c8\u30ed\u30d1\u30d6\u30ed\u30d5\u30b9\u30af\u30ab\u30e0\u30c1\u30e3\u30c4\u30ad\u30fc\u590f\u6642\u9593", "PETST"}},
            {"Asia/Karachi", PKT},
            {"Asia/Kashgar", CTT},
            {"Asia/Kathmandu", NPT},
            {"Asia/Katmandu", NPT},
            {"Asia/Kolkata", IST},
            {"Asia/Krasnoyarsk", new String[] {"\u30af\u30e9\u30b9\u30ce\u30e4\u30eb\u30b9\u30af\u6642\u9593", "KRAT",
                                               "\u30af\u30e9\u30b9\u30ce\u30e4\u30eb\u30b9\u30af\u590f\u6642\u9593", "KRAST"}},
            {"Asia/Kuala_Lumpur", MYT},
            {"Asia/Kuching", MYT},
            {"Asia/Kuwait", ARAST},
            {"Asia/Macao", CTT},
            {"Asia/Macau", CTT},
            {"Asia/Magadan", new String[] {"\u30de\u30ac\u30c0\u30f3\u6642\u9593", "MAGT",
                                           "\u30de\u30ac\u30c0\u30f3\u590f\u6642\u9593", "MAGST"}},
            {"Asia/Makassar", CIT},
            {"Asia/Manila", new String[] {"\u30d5\u30a3\u30ea\u30d4\u30f3\u6642\u9593", "PHT",
                                          "\u30d5\u30a3\u30ea\u30d4\u30f3\u590f\u6642\u9593", "PHST"}},
            {"Asia/Muscat", GST},
            {"Asia/Nicosia", EET},
            {"Asia/Novokuznetsk", NOVT},
            {"Asia/Novosibirsk", NOVT},
            {"Asia/Oral", new String[] {"\u30aa\u30e9\u30eb\u6642\u9593", "ORAT",
                                        "\u30aa\u30e9\u30eb\u590f\u6642\u9593", "ORAST"}},
            {"Asia/Omsk", new String[] {"\u30aa\u30e0\u30b9\u30af\u6642\u9593", "OMST",
                                        "\u30aa\u30e0\u30b9\u30af\u590f\u6642\u9593", "OMSST"}},
            {"Asia/Phnom_Penh", ICT},
            {"Asia/Pontianak", WIT},
            {"Asia/Pyongyang", KST},
            {"Asia/Qatar", ARAST},
            {"Asia/Qyzylorda", new String[] {"\u30ad\u30b8\u30eb\u30aa\u30eb\u30c0\u6642\u9593", "QYZT",
                                             "\u30ad\u30b8\u30eb\u30aa\u30eb\u30c0\u590f\u6642\u9593", "QYZST"}},
            {"Asia/Rangoon", new String[] {"\u30df\u30e3\u30f3\u30de\u30fc\u6642\u9593", "MMT",
                                           "\u30df\u30e3\u30f3\u30de\u30fc\u590f\u6642\u9593", "MMST"}},
            {"Asia/Riyadh", ARAST},
            {"Asia/Saigon", ICT},
            {"Asia/Sakhalin", new String[] {"\u6a3a\u592a\u6642\u9593", "SAKT",
                                            "\u6a3a\u592a\u590f\u6642\u9593", "SAKST"}},
            {"Asia/Samarkand", UZT},
            {"Asia/Seoul", KST},
            {"Asia/Singapore", SGT},
            {"Asia/Taipei", CTT},
            {"Asia/Tel_Aviv", ISRAEL},
            {"Asia/Tashkent", UZT},
            {"Asia/Tbilisi", new String[] {"\u30b0\u30eb\u30b8\u30a2\u6642\u9593", "GET",
                                           "\u30b0\u30eb\u30b8\u30a2\u590f\u6642\u9593", "GEST"}},
            {"Asia/Tehran", IRT},
            {"Asia/Thimbu", BTT},
            {"Asia/Thimphu", BTT},
            {"Asia/Ujung_Pandang", CIT},
            {"Asia/Ulaanbaatar", ULAT},
            {"Asia/Ulan_Bator", ULAT},
            {"Asia/Urumqi", CTT},
            {"Asia/Vientiane", ICT},
            {"Asia/Vladivostok", new String[] {"\u30a6\u30e9\u30b8\u30aa\u30b9\u30c8\u30af\u6642\u9593", "VLAT",
                                               "\u30a6\u30e9\u30b8\u30aa\u30b9\u30c8\u30af\u590f\u6642\u9593", "VLAST"}},
            {"Asia/Yakutsk", new String[] {"\u30e4\u30af\u30fc\u30c4\u30af\u6642\u9593", "YAKT",
                                           "\u30e4\u30af\u30fc\u30c4\u30af\u590f\u6642\u9593", "YAKST"}},
            {"Asia/Yekaterinburg", new String[] {"\u30a8\u30ab\u30c6\u30ea\u30f3\u30d6\u30eb\u30b0\u6642\u9593", "YEKT",
                                                 "\u30a8\u30ab\u30c6\u30ea\u30f3\u30d6\u30eb\u30b0\u590f\u6642\u9593", "YEKST"}},
            {"Asia/Yerevan", ARMT},
            {"Atlantic/Azores", new String[] {"\u30a2\u30be\u30ec\u30b9\u6642\u9593", "AZOT",
                                              "\u30a2\u30be\u30ec\u30b9\u590f\u6642\u9593", "AZOST"}},
            {"Atlantic/Bermuda", AST},
            {"Atlantic/Canary", WET},
            {"Atlantic/Cape_Verde", new String[] {"\u30ab\u30fc\u30dc\u30d9\u30eb\u30c7\u6642\u9593", "CVT",
                                                  "\u30ab\u30fc\u30dc\u30d9\u30eb\u30c7\u590f\u6642\u9593", "CVST"}},
            {"Atlantic/Faeroe", WET},
            {"Atlantic/Faroe", WET},
            {"Atlantic/Jan_Mayen", CET},
            {"Atlantic/Madeira", WET},
            {"Atlantic/Reykjavik", GMT},
            {"Atlantic/South_Georgia", new String[] {"\u5357\u30b8\u30e7\u30fc\u30b8\u30a2\u5cf6\u6a19\u6e96\u6642", "GST",
                                                     "\u5357\u30b8\u30e7\u30fc\u30b8\u30a2\u5cf6\u590f\u6642\u9593", "GDT"}},
            {"Atlantic/St_Helena", GMT},
            {"Atlantic/Stanley", new String[] {"\u30d5\u30a9\u30fc\u30af\u30e9\u30f3\u30c9\u8af8\u5cf6\u6642\u9593", "FKT",
                                               "\u30d5\u30a9\u30fc\u30af\u30e9\u30f3\u30c9\u8af8\u5cf6\u590f\u6642\u9593", "FKST"}},
            {"Australia/ACT", EST_NSW},
            {"Australia/Adelaide", ADELAIDE},
            {"Australia/Brisbane", BRISBANE},
            {"Australia/Broken_Hill", BROKEN_HILL},
            {"Australia/Canberra", EST_NSW},
            {"Australia/Currie", EST_NSW},
            {"Australia/Darwin", DARWIN},
            {"Australia/Eucla", new String[] {"\u4e2d\u897f\u90e8\u6a19\u6e96\u6642 (\u30aa\u30fc\u30b9\u30c8\u30e9\u30ea\u30a2)", "CWST",
                                              "\u4e2d\u897f\u90e8\u590f\u6642\u9593 (\u30aa\u30fc\u30b9\u30c8\u30e9\u30ea\u30a2)", "CWST"}},
            {"Australia/Hobart", TASMANIA},
            {"Australia/LHI", LORD_HOWE},
            {"Australia/Lindeman", BRISBANE},
            {"Australia/Lord_Howe", LORD_HOWE},
            {"Australia/Melbourne", VICTORIA},
            {"Australia/North", DARWIN},
            {"Australia/NSW", EST_NSW},
            {"Australia/Perth", WST_AUS},
            {"Australia/Queensland", BRISBANE},
            {"Australia/South", ADELAIDE},
            {"Australia/Sydney", EST_NSW},
            {"Australia/Tasmania", TASMANIA},
            {"Australia/Victoria", VICTORIA},
            {"Australia/West", WST_AUS},
            {"Australia/Yancowinna", BROKEN_HILL},
            {"BET", BRT},
            {"BST", BDT},
            {"Brazil/Acre", AMT},
            {"Brazil/DeNoronha", NORONHA},
            {"Brazil/East", BRT},
            {"Brazil/West", AMT},
            {"Canada/Atlantic", AST},
            {"Canada/Central", CST},
            {"Canada/East-Saskatchewan", CST},
            {"Canada/Eastern", EST},
            {"Canada/Mountain", MST},
            {"Canada/Newfoundland", NST},
            {"Canada/Pacific", PST},
            {"Canada/Yukon", PST},
            {"Canada/Saskatchewan", CST},
            {"CAT", CAT},
            {"CET", CET},
            {"Chile/Continental", CLT},
            {"Chile/EasterIsland", EASTER},
            {"CST6CDT", CST},
            {"Cuba", CUBA},
            {"EAT", EAT},
            {"EET", EET},
            {"Egypt", EET},
            {"Eire", DUBLIN},
            {"EST5EDT", EST},
            {"Etc/Greenwich", GMT},
            {"Etc/UCT", UTC},
            {"Etc/Universal", UTC},
            {"Etc/UTC", UTC},
            {"Etc/Zulu", UTC},
            {"Europe/Amsterdam", CET},
            {"Europe/Andorra", CET},
            {"Europe/Athens", EET},
            {"Europe/Belfast", GMTBST},
            {"Europe/Belgrade", CET},
            {"Europe/Berlin", CET},
            {"Europe/Bratislava", CET},
            {"Europe/Brussels", CET},
            {"Europe/Budapest", CET},
            {"Europe/Chisinau", EET},
            {"Europe/Copenhagen", CET},
            {"Europe/Dublin", DUBLIN},
            {"Europe/Gibraltar", CET},
            {"Europe/Guernsey", GMTBST},
            {"Europe/Helsinki", EET},
            {"Europe/Isle_of_Man", GMTBST},
            {"Europe/Istanbul", EET},
            {"Europe/Jersey", GMTBST},
            {"Europe/Kaliningrad", FET},
            {"Europe/Kiev", FET},
            {"Europe/Lisbon", WET},
            {"Europe/Ljubljana", CET},
            {"Europe/London", GMTBST},
            {"Europe/Luxembourg", CET},
            {"Europe/Madrid", CET},
            {"Europe/Malta", CET},
            {"Europe/Mariehamn", EET},
            {"Europe/Minsk", FET},
            {"Europe/Monaco", CET},
            {"Europe/Moscow", MSK},
            {"Europe/Nicosia", EET},
            {"Europe/Oslo", CET},
            {"Europe/Podgorica", CET},
            {"Europe/Prague", CET},
            {"Europe/Riga", EET},
            {"Europe/Rome", CET},
            {"Europe/Samara", new String[] {"\u30b5\u30de\u30e9\u6642\u9593", "SAMT",
                                            "\u30b5\u30de\u30e9\u590f\u6642\u9593", "SAMST"}},
            {"Europe/San_Marino", CET},
            {"Europe/Sarajevo", CET},
            {"Europe/Simferopol", FET},
            {"Europe/Skopje", CET},
            {"Europe/Sofia", EET},
            {"Europe/Stockholm", CET},
            {"Europe/Tallinn", EET},
            {"Europe/Tirane", CET},
            {"Europe/Tiraspol", EET},
            {"Europe/Uzhgorod", FET},
            {"Europe/Vaduz", CET},
            {"Europe/Vatican", CET},
            {"Europe/Vienna", CET},
            {"Europe/Vilnius", EET},
            {"Europe/Volgograd", new String[] {"\u30dc\u30eb\u30b4\u30b0\u30e9\u30fc\u30c9\u6642\u9593", "VOLT",
                                               "\u30dc\u30eb\u30b4\u30b0\u30e9\u30fc\u30c9\u590f\u6642\u9593", "VOLST"}},
            {"Europe/Warsaw", CET},
            {"Europe/Zagreb", CET},
            {"Europe/Zaporozhye", FET},
            {"Europe/Zurich", CET},
            {"GB", GMTBST},
            {"GB-Eire", GMTBST},
            {"Greenwich", GMT},
            {"Hongkong", HKT},
            {"Iceland", GMT},
            {"Iran", IRT},
            {"IST", IST},
            {"Indian/Antananarivo", EAT},
            {"Indian/Chagos", new String[] {"\u30a4\u30f3\u30c9\u6d0b\u5730\u57df\u6642\u9593", "IOT",
                                            "\u30a4\u30f3\u30c9\u6d0b\u5730\u57df\u590f\u6642\u9593", "IOST"}},
            {"Indian/Christmas", new String[] {"\u30af\u30ea\u30b9\u30de\u30b9\u8af8\u5cf6\u6642\u9593", "CXT",
                                               "\u30af\u30ea\u30b9\u30de\u30b9\u8af8\u5cf6\u590f\u6642\u9593", "CXST"}},
            {"Indian/Cocos", new String[] {"\u30b3\u30b3\u30b9\u8af8\u5cf6\u6642\u9593", "CCT",
                                           "\u30b3\u30b3\u30b9\u8af8\u5cf6\u590f\u6642\u9593", "CCST"}},
            {"Indian/Comoro", EAT},
            {"Indian/Kerguelen", new String[] {"\u4ecf\u5357\u65b9\u9818\u304a\u3088\u3073\u5357\u6975\u6642\u9593", "TFT",
                                               "\u4ecf\u5357\u65b9\u9818\u304a\u3088\u3073\u5357\u6975\u590f\u6642\u9593", "TFST"}},
            {"Indian/Mahe", new String[] {"\u30bb\u30a4\u30b7\u30a7\u30eb\u6642\u9593", "SCT",
                                          "\u30bb\u30a4\u30b7\u30a7\u30eb\u590f\u6642\u9593", "SCST"}},
            {"Indian/Maldives", new String[] {"\u30e2\u30eb\u30b8\u30d6\u6642\u9593", "MVT",
                                              "\u30e2\u30eb\u30b8\u30d6\u590f\u6642\u9593", "MVST"}},
            {"Indian/Mauritius", new String[] {"\u30e2\u30fc\u30ea\u30b7\u30e3\u30b9\u6642\u9593", "MUT",
                                               "\u30e2\u30fc\u30ea\u30b7\u30e3\u30b9\u590f\u6642\u9593", "MUST"}},
            {"Indian/Mayotte", EAT},
            {"Indian/Reunion", new String[] {"\u30ec\u30e6\u30cb\u30aa\u30f3\u6642\u9593", "RET",
                                             "\u30ec\u30e6\u30cb\u30aa\u30f3\u590f\u6642\u9593", "REST"}},
            {"Israel", ISRAEL},
            {"Jamaica", EST},
            {"Japan", JST},
            {"Kwajalein", MHT},
            {"Libya", EET},
            {"MET", new String[] {"\u4e2d\u90e8\u30e8\u30fc\u30ed\u30c3\u30d1\u6642\u9593", "MET",
                                  "\u4e2d\u90e8\u30e8\u30fc\u30ed\u30c3\u30d1\u590f\u6642\u9593", "MEST"}},
            {"Mexico/BajaNorte", PST},
            {"Mexico/BajaSur", MST},
            {"Mexico/General", CST},
            {"MIT", WST_SAMOA},
            {"MST7MDT", MST},
            {"Navajo", MST},
            {"NET", ARMT},
            {"NST", NZST},
            {"NZ", NZST},
            {"NZ-CHAT", CHAST},
            {"PLT", PKT},
            {"Portugal", WET},
            {"PRT", AST},
            {"Pacific/Apia", WST_SAMOA},
            {"Pacific/Auckland", NZST},
            {"Pacific/Chatham", CHAST},
            {"Pacific/Chuuk", CHUT},
            {"Pacific/Easter", EASTER},
            {"Pacific/Efate", new String[] {"\u30d0\u30cc\u30a2\u30c4\u6642\u9593", "VUT",
                                            "\u30d0\u30cc\u30a2\u30c4\u590f\u6642\u9593", "VUST"}},
            {"Pacific/Enderbury", new String[] {"\u30d5\u30a7\u30cb\u30c3\u30af\u30b9\u8af8\u5cf6\u6642\u9593", "PHOT",
                                                "\u30d5\u30a7\u30cb\u30c3\u30af\u30b9\u8af8\u5cf6\u590f\u6642\u9593", "PHOST"}},
            {"Pacific/Fakaofo", new String[] {"\u30c8\u30b1\u30e9\u30a6\u8af8\u5cf6\u6642\u9593", "TKT",
                                              "\u30c8\u30b1\u30e9\u30a6\u8af8\u5cf6\u590f\u6642\u9593", "TKST"}},
            {"Pacific/Fiji", new String[] {"\u30d5\u30a3\u30b8\u30fc\u6642\u9593", "FJT",
                                           "\u30d5\u30a3\u30b8\u30fc\u590f\u6642\u9593", "FJST"}},
            {"Pacific/Funafuti", new String[] {"\u30c4\u30d0\u30eb\u6642\u9593", "TVT",
                                               "\u30c4\u30d0\u30eb\u590f\u6642\u9593", "TVST"}},
            {"Pacific/Galapagos", new String[] {"\u30ac\u30e9\u30d1\u30b4\u30b9\u6642\u9593", "GALT",
                                                "\u30ac\u30e9\u30d1\u30b4\u30b9\u590f\u6642\u9593", "GALST"}},
            {"Pacific/Gambier", GAMBIER},
            {"Pacific/Guadalcanal", SBT},
            {"Pacific/Guam", ChST},
            {"Pacific/Johnston", HST},
            {"Pacific/Kiritimati", new String[] {"\u30e9\u30a4\u30f3\u8af8\u5cf6\u6642\u9593", "LINT",
                                                 "\u30e9\u30a4\u30f3\u8af8\u5cf6\u590f\u6642\u9593", "LINST"}},
            {"Pacific/Kosrae", new String[] {"\u30b3\u30b9\u30e9\u30a8\u6642\u9593", "KOST",
                                             "\u30b3\u30b9\u30e9\u30a8\u590f\u6642\u9593", "KOSST"}},
            {"Pacific/Kwajalein", MHT},
            {"Pacific/Majuro", MHT},
            {"Pacific/Marquesas", new String[] {"\u30de\u30eb\u30b1\u30b5\u30b9\u6642\u9593", "MART",
                                                "\u30de\u30eb\u30b1\u30b5\u30b9\u590f\u6642\u9593", "MARST"}},
            {"Pacific/Midway", SAMOA},
            {"Pacific/Nauru", new String[] {"\u30ca\u30a6\u30eb\u6642\u9593", "NRT",
                                            "\u30ca\u30a6\u30eb\u590f\u6642\u9593", "NRST"}},
            {"Pacific/Niue", new String[] {"\u30cb\u30a6\u30a8\u5cf6\u6642\u9593", "NUT",
                                           "\u30cb\u30a6\u30a8\u5cf6\u590f\u6642\u9593", "NUST"}},
            {"Pacific/Norfolk", new String[] {"\u30ce\u30fc\u30d5\u30a9\u30fc\u30af\u6642\u9593", "NFT",
                                              "\u30ce\u30fc\u30d5\u30a9\u30fc\u30af\u590f\u6642\u9593", "NFST"}},
            {"Pacific/Noumea", new String[] {"\u30cb\u30e5\u30fc\u30ab\u30ec\u30c9\u30cb\u30a2\u6642\u9593", "NCT",
                                             "\u30cb\u30e5\u30fc\u30ab\u30ec\u30c9\u30cb\u30a2\u590f\u6642\u9593", "NCST"}},
            {"Pacific/Pago_Pago", SAMOA},
            {"Pacific/Palau", new String[] {"\u30d1\u30e9\u30aa\u6642\u9593", "PWT",
                                            "\u30d1\u30e9\u30aa\u590f\u6642\u9593", "PWST"}},
            {"Pacific/Pitcairn", PITCAIRN},
            {"Pacific/Pohnpei", PONT},
            {"Pacific/Ponape", PONT},
            {"Pacific/Port_Moresby", new String[] {"\u30d1\u30d7\u30a2\u30cb\u30e5\u30fc\u30ae\u30cb\u30a2\u6642\u9593", "PGT",
                                                   "\u30d1\u30d7\u30a2\u30cb\u30e5\u30fc\u30ae\u30cb\u30a2\u590f\u6642\u9593", "PGST"}},
            {"Pacific/Rarotonga", new String[] {"\u30af\u30c3\u30af\u8af8\u5cf6\u6642\u9593", "CKT",
                                                "\u30af\u30c3\u30af\u8af8\u5cf6\u590f\u6642\u9593", "CKHST"}},
            {"Pacific/Saipan", ChST},
            {"Pacific/Samoa", SAMOA},
            {"Pacific/Tahiti", new String[] {"\u30bf\u30d2\u30c1\u6642\u9593", "TAHT",
                                             "\u30bf\u30d2\u30c1\u590f\u6642\u9593", "TAHST"}},
            {"Pacific/Tarawa", new String[] {"\u30ae\u30eb\u30d0\u30fc\u30c8\u8af8\u5cf6\u6642\u9593", "GILT",
                                             "\u30ae\u30eb\u30d0\u30fc\u30c8\u8af8\u5cf6\u590f\u6642\u9593", "GILST"}},
            {"Pacific/Tongatapu", new String[] {"\u30c8\u30f3\u30ac\u6642\u9593", "TOT",
                                                "\u30c8\u30f3\u30ac\u590f\u6642\u9593", "TOST"}},
            {"Pacific/Truk", CHUT},
            {"Pacific/Wake", new String[] {"\u30a6\u30a7\u30fc\u30af\u6642\u9593", "WAKT",
                                           "\u30a6\u30a7\u30fc\u30af\u590f\u6642\u9593", "WAKST"}},
            {"Pacific/Wallis", new String[] {"\u30ef\u30ea\u30b9\u53ca\u3073\u30d5\u30c4\u30ca\u6642\u9593", "WFT",
                                             "\u30ef\u30ea\u30b9\u53ca\u3073\u30d5\u30c4\u30ca\u590f\u6642\u9593", "WFST"}},
            {"Pacific/Yap", CHUT},
            {"Poland", CET},
            {"PRC", CTT},
            {"PST8PDT", PST},
            {"ROK", KST},
            {"Singapore", SGT},
            {"SST", SBT},
            {"SystemV/AST4", AST},
            {"SystemV/AST4ADT", AST},
            {"SystemV/CST6", CST},
            {"SystemV/CST6CDT", CST},
            {"SystemV/EST5", EST},
            {"SystemV/EST5EDT", EST},
            {"SystemV/HST10", HST},
            {"SystemV/MST7", MST},
            {"SystemV/MST7MDT", MST},
            {"SystemV/PST8", PST},
            {"SystemV/PST8PDT", PST},
            {"SystemV/YST9", AKST},
            {"SystemV/YST9YDT", AKST},
            {"Turkey", EET},
            {"UCT", UTC},
            {"Universal", UTC},
            {"US/Alaska", AKST},
            {"US/Aleutian", HAST},
            {"US/Arizona", MST},
            {"US/Central", CST},
            {"US/Eastern", EST},
            {"US/Hawaii", HST},
            {"US/Indiana-Starke", CST},
            {"US/East-Indiana", EST},
            {"US/Michigan", EST},
            {"US/Mountain", MST},
            {"US/Pacific", PST},
            {"US/Pacific-New", PST},
            {"US/Samoa", SAMOA},
            {"UTC", UTC},
            {"VST", ICT},
            {"W-SU", MSK},
            {"WET", WET},
            {"Zulu", UTC},
        };
    }
}
