/*
 * Copyright 1999 Sun Microsystems, Inc.  All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 */

#if defined(DEBUG)

#include "debug_util.h"

enum {
    MAX_ASSERT_MSG = 255+FILENAME_MAX+1
};

static DASSERT_CALLBACK PfnAssertCallback = NULL;

void DAssert_Impl(const char *msg, const char * filename, int linenumber) {
    if (PfnAssertCallback != NULL) {
        (*PfnAssertCallback)(msg, filename, linenumber);
    } else {
        fprintf(stderr, "Assert fail in file %s, line %d\n\t%s\n", filename, linenumber, msg);
        fflush(stderr);
        assert(FALSE);
    }
}

void DAssert_SetCallback(DASSERT_CALLBACK pfn) {
    PfnAssertCallback = pfn;
}

#endif  /* defined(DEBUG) */

/* The following line is only here to prevent compiler warnings
 * on release (non-debug) builds
 */
static int dummyVariable = 0;
