
#define NOVIRTUAL

// File		OpenGl_GraphicDriver_710.cxx
// Created	Mardi 28 janvier 1997
// Author	CAL

//-Copyright	MatraDatavision 1997

//-Version	

//-Design	Declaration des variables specifiques aux Drivers

//-Warning	Un driver encapsule les Pex et OpenGl drivers

//-References	

//-Language	C++ 2.0

//-Declarations

// for the class
#include <OpenGl_GraphicDriver.jxx>
#include <TCollection_AsciiString.hxx>

#include <Aspect_DriverDefinitionError.hxx>

extern "C" {
#include <InterfaceGraphic_Cextern.hxx>
}

//-Aliases

//-Global data definitions

//-Methods, in order

void OpenGl_GraphicDriver::Text (
                       const Graphic3d_CGroup& ACGroup,
                       const Standard_CString AText,
                       const Graphic3d_Vertex& APoint,
                       const Standard_Real AHeight,
                       const Quantity_PlaneAngle AAngle,
                       const Graphic3d_TextPath ATp,
                       const Graphic3d_HorizontalTextAlignment AHta,
                       const Graphic3d_VerticalTextAlignment AVta,
//                       const Standard_Boolean EvalMinMax
                       const Standard_Boolean 
                      ) {
#ifndef VIRTUAL

Graphic3d_CGroup MyCGroup = ACGroup;

Standard_Real X, Y, Z;

CALL_DEF_TEXT atext;
	APoint.Coord (X, Y, Z);
	atext.Position.x	= float (X);
	atext.Position.y	= float (Y);
	atext.Position.z	= float (Z);
	atext.Height		= float (AHeight);
	atext.Angle		= float (AAngle);
	atext.Path		= int (ATp);
	atext.HAlign		= int (AHta);
	atext.VAlign		= int (AVta);
	atext.string		= (char *) AText;

	if (MyTraceLevel) {
		PrintFunction ("call_togl_text");
		PrintCGroup (MyCGroup, 1);
	}
	call_togl_text (&MyCGroup, &atext);

#endif
}

void OpenGl_GraphicDriver::Text (
                       const Graphic3d_CGroup& ACGroup,
                       const Standard_CString AText, 
                       const Graphic3d_Vertex& APoint, 
                       const Standard_Real AHeight, 
//                       const Standard_Boolean EvalMinMax
                       const Standard_Boolean 
                      ) {
#ifndef VIRTUAL

Graphic3d_CGroup MyCGroup = ACGroup;

Standard_Real X, Y, Z;

CALL_DEF_TEXT atext;
	APoint.Coord (X, Y, Z);
	atext.Position.x	= float (X);
	atext.Position.y	= float (Y);
	atext.Position.z	= float (Z);
	atext.Height		= float (AHeight);
	atext.Angle		= float (Standard_PI / 2.);
	atext.Path		= int (Graphic3d_TP_RIGHT);
	atext.HAlign		= int (Graphic3d_HTA_NORMAL);
	atext.VAlign		= int (Graphic3d_VTA_NORMAL);
	atext.string		= (char *) AText;

	if (MyTraceLevel) {
		PrintFunction ("call_togl_text");
		PrintCGroup (MyCGroup, 1);
	}
	call_togl_text (&MyCGroup, &atext);

#endif
}

void OpenGl_GraphicDriver::Text (
                       const Graphic3d_CGroup& ACGroup,
                       const TCollection_ExtendedString& AText, 
                       const Graphic3d_Vertex& APoint, 
                       const Standard_Real AHeight, 
                       const Quantity_PlaneAngle AAngle, 
                       const Graphic3d_TextPath ATp, 
                       const Graphic3d_HorizontalTextAlignment AHta, 
                       const Graphic3d_VerticalTextAlignment AVta, 
 //                      const Standard_Boolean EvalMinMax
                       const Standard_Boolean 
                      ) {
#ifndef VIRTUAL

Graphic3d_CGroup MyCGroup = ACGroup;

Standard_Real X, Y, Z;
CALL_DEF_TEXT atext;
TCollection_AsciiString ascii (AText,'?');

	APoint.Coord (X, Y, Z);
	atext.Position.x	= float (X);
	atext.Position.y	= float (Y);
	atext.Position.z	= float (Z);
	atext.Height		= float (AHeight);
	atext.Angle		= float (AAngle);
	atext.Path		= int (ATp);
	atext.HAlign		= int (AHta);
	atext.VAlign		= int (AVta);
	atext.string		= (Standard_PCharacter)ascii.ToCString ();

	if (MyTraceLevel) {
		PrintFunction ("call_togl_text");
		PrintCGroup (MyCGroup, 1);
	}
	call_togl_text (&MyCGroup, &atext);
	ascii.Clear ();

#endif
}

void OpenGl_GraphicDriver::Text (
                       const Graphic3d_CGroup& ACGroup,
                       const TCollection_ExtendedString& AText, 
                       const Graphic3d_Vertex& APoint, 
                       const Standard_Real AHeight, 
//                       const Standard_Boolean EvalMinMax
                       const Standard_Boolean 
                      ) {
#ifndef VIRTUAL

Graphic3d_CGroup MyCGroup = ACGroup;

Standard_Real X, Y, Z;
CALL_DEF_TEXT atext;
TCollection_AsciiString ascii (AText, '?');

	APoint.Coord (X, Y, Z);
	atext.Position.x	= float (X);
	atext.Position.y	= float (Y);
	atext.Position.z	= float (Z);
	atext.Height		= float (AHeight);
	atext.Angle		= float (Standard_PI / 2.);
	atext.Path		= int (Graphic3d_TP_RIGHT);
	atext.HAlign		= int (Graphic3d_HTA_NORMAL);
	atext.VAlign		= int (Graphic3d_VTA_NORMAL);
	atext.string		= (Standard_PCharacter)ascii.ToCString ();

	if (MyTraceLevel) {
		PrintFunction ("call_togl_text");
		PrintCGroup (MyCGroup, 1);
	}
	call_togl_text (&MyCGroup, &atext);
	ascii.Clear ();

#endif
}
